/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.content.Context;
import com.crashlytics.android.core.BinaryImagesConverter;
import com.crashlytics.android.core.Sha1FileIdStrategy;
import io.fabric.sdk.android.services.common.CommonUtils;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;

final class NativeFileUtils {
    private NativeFileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    static byte[] readFile(File file) {
        byte[] byArray;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byArray = NativeFileUtils.readBytes(fis);
        }
        catch (FileNotFoundException e) {
            byte[] byArray2 = null;
            CommonUtils.closeQuietly((Closeable)fis);
            return byArray2;
        }
        catch (IOException e2) {
            byte[] byArray3 = null;
            {
                catch (Throwable throwable) {
                    CommonUtils.closeQuietly(fis);
                    throw throwable;
                }
            }
            CommonUtils.closeQuietly((Closeable)fis);
            return byArray3;
        }
        CommonUtils.closeQuietly((Closeable)fis);
        return byArray;
    }

    private static byte[] readBytes(InputStream inputStream) throws IOException {
        int c;
        byte[] b = new byte[1024];
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while ((c = inputStream.read(b)) != -1) {
            os.write(b, 0, c);
        }
        return os.toByteArray();
    }

    private static File filter(File directory, String extension) {
        for (File file : directory.listFiles()) {
            if (!file.getName().endsWith(extension)) continue;
            return file;
        }
        return null;
    }

    static byte[] minidumpFromDirectory(File directory) {
        File file = NativeFileUtils.filter(directory, ".dmp");
        return file == null ? new byte[]{} : NativeFileUtils.minidumpFromFile(file);
    }

    private static byte[] minidumpFromFile(File file) {
        return NativeFileUtils.readFile(file);
    }

    static byte[] binaryImagesJsonFromDirectory(File directory, Context context) throws IOException {
        File file = NativeFileUtils.filter(directory, ".maps");
        if (file != null) {
            return NativeFileUtils.binaryImagesJsonFromMapsFile(file, context);
        }
        file = NativeFileUtils.filter(directory, ".binary_libs");
        if (file != null) {
            return NativeFileUtils.binaryImagesJsonFromBinaryLibsFile(file, context);
        }
        return null;
    }

    private static byte[] binaryImagesJsonFromBinaryLibsFile(File file, Context context) throws IOException {
        byte[] raw = NativeFileUtils.readFile(file);
        if (raw == null || raw.length == 0) {
            return null;
        }
        return NativeFileUtils.processBinaryImages(context, new String(raw));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] binaryImagesJsonFromMapsFile(File file, Context context) throws IOException {
        byte[] byArray;
        if (!file.exists()) {
            return null;
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            byArray = new BinaryImagesConverter(context, new Sha1FileIdStrategy()).convert(reader);
        }
        catch (Throwable throwable) {
            CommonUtils.closeQuietly(reader);
            throw throwable;
        }
        CommonUtils.closeQuietly((Closeable)reader);
        return byArray;
    }

    static byte[] metadataJsonFromDirectory(File directory) {
        File file = NativeFileUtils.filter(directory, ".device_info");
        return file == null ? null : NativeFileUtils.readFile(file);
    }

    private static byte[] processBinaryImages(Context context, String binaryImages) throws IOException {
        return new BinaryImagesConverter(context, new Sha1FileIdStrategy()).convert(binaryImages);
    }
}

