/*
 * Decompiled with CFR 0.152.
 */
package com.crashlytics.android.core;

import android.annotation.SuppressLint;
import com.crashlytics.android.core.CrashlyticsCore;
import io.fabric.sdk.android.Kit;
import io.fabric.sdk.android.services.persistence.PreferenceStore;
import io.fabric.sdk.android.services.persistence.PreferenceStoreImpl;

@SuppressLint(value={"CommitPrefEdits"})
class PreferenceManager {
    private static final boolean SHOULD_ALWAYS_SEND_REPORTS_DEFAULT = false;
    private static final String PREF_MIGRATION_COMPLETE = "preferences_migration_complete";
    static final String PREF_ALWAYS_SEND_REPORTS_KEY = "always_send_reports_opt_in";
    private final PreferenceStore preferenceStore;
    private final CrashlyticsCore kit;

    public static PreferenceManager create(PreferenceStore preferenceStore, CrashlyticsCore kit) {
        return new PreferenceManager(preferenceStore, kit);
    }

    public PreferenceManager(PreferenceStore preferenceStore, CrashlyticsCore kit) {
        this.preferenceStore = preferenceStore;
        this.kit = kit;
    }

    void setShouldAlwaysSendReports(boolean send) {
        this.preferenceStore.save(this.preferenceStore.edit().putBoolean(PREF_ALWAYS_SEND_REPORTS_KEY, send));
    }

    boolean shouldAlwaysSendReports() {
        if (!this.preferenceStore.get().contains(PREF_MIGRATION_COMPLETE)) {
            boolean migrationRequired;
            PreferenceStoreImpl oldStore = new PreferenceStoreImpl((Kit)this.kit);
            boolean bl = migrationRequired = !this.preferenceStore.get().contains(PREF_ALWAYS_SEND_REPORTS_KEY) && oldStore.get().contains(PREF_ALWAYS_SEND_REPORTS_KEY);
            if (migrationRequired) {
                boolean alwaysSend = oldStore.get().getBoolean(PREF_ALWAYS_SEND_REPORTS_KEY, false);
                this.preferenceStore.save(this.preferenceStore.edit().putBoolean(PREF_ALWAYS_SEND_REPORTS_KEY, alwaysSend));
            }
            this.preferenceStore.save(this.preferenceStore.edit().putBoolean(PREF_MIGRATION_COMPLETE, true));
        }
        return this.preferenceStore.get().getBoolean(PREF_ALWAYS_SEND_REPORTS_KEY, false);
    }
}

