/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.SerializableComment;
import com.microsoft.schemas.vml.CTShape;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;

public class DelegatingXSSFComment
extends XSSFComment {
    private final SerializableComment delegate;
    private final Comments comments;
    private final CTShape ctShape;

    DelegatingXSSFComment(Comments comments, SerializableComment delegate, CTShape ctShape) {
        super(comments, null, ctShape);
        this.comments = comments;
        this.delegate = delegate;
        this.ctShape = ctShape;
    }

    @Override
    public String getAuthor() {
        return this.delegate.getAuthor();
    }

    @Override
    public int getColumn() {
        return this.delegate.getColumn();
    }

    @Override
    public int getRow() {
        return this.delegate.getRow();
    }

    @Override
    public boolean isVisible() {
        return this.delegate.isVisible();
    }

    @Override
    public CellAddress getAddress() {
        return this.delegate.getAddress();
    }

    @Override
    public XSSFRichTextString getString() {
        return this.delegate.getString();
    }

    public String getCommentText() {
        return this.delegate.getCommentText();
    }

    @Override
    public CTComment getCTComment() {
        CTRst rst = this.delegate.getString().getCTRst();
        CTComment ctComment = CTComment.Factory.newInstance();
        ctComment.setText(rst);
        return ctComment;
    }

    @Override
    public void setAddress(int row, int col) {
        CellAddress oldAddress = this.delegate.getAddress();
        this.delegate.setAddress(row, col);
        this.comments.referenceUpdated(oldAddress, this);
    }

    @Override
    public void setAddress(CellAddress address) {
        CellAddress oldAddress = this.delegate.getAddress();
        this.delegate.setAddress(address);
        this.comments.referenceUpdated(oldAddress, this);
    }

    @Override
    public void setRow(int row) {
        CellAddress oldAddress = this.delegate.getAddress();
        this.delegate.setRow(row);
        this.comments.referenceUpdated(oldAddress, this);
    }

    @Override
    public void setColumn(int col) {
        CellAddress oldAddress = this.delegate.getAddress();
        this.delegate.setColumn(col);
        this.comments.referenceUpdated(oldAddress, this);
    }

    @Override
    public void setString(RichTextString string) {
        this.delegate.setString(string);
        this.comments.commentUpdated(this);
    }

    @Override
    public void setString(String string) {
        this.delegate.setString(string);
        this.comments.commentUpdated(this);
    }

    @Override
    public void setAuthor(String author) {
        this.delegate.setAuthor(author);
        this.comments.commentUpdated(this);
    }

    @Override
    public void setVisible(boolean visible) {
        this.delegate.setVisible(visible);
        this.comments.commentUpdated(this);
    }

    @Override
    protected CTShape getCTShape() {
        return this.ctShape;
    }
}

