/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.bouncycastle.crypto.generators;

import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.databricks.internal.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.databricks.internal.bouncycastle.crypto.CryptoServicePurpose;
import com.databricks.internal.bouncycastle.crypto.CryptoServicesRegistrar;
import com.databricks.internal.bouncycastle.crypto.KeyGenerationParameters;
import com.databricks.internal.bouncycastle.crypto.constraints.ConstraintUtils;
import com.databricks.internal.bouncycastle.crypto.constraints.DefaultServiceProperties;
import com.databricks.internal.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import com.databricks.internal.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.databricks.internal.bouncycastle.crypto.params.DHParameters;
import com.databricks.internal.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.databricks.internal.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters keyGenerationParameters) {
        this.param = (DHKeyGenerationParameters)keyGenerationParameters;
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("DHKeyGen", ConstraintUtils.bitsOfSecurityFor(this.param.getParameters().getP()), this.param.getParameters(), CryptoServicePurpose.KEYGEN));
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper dHKeyGeneratorHelper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dHParameters = this.param.getParameters();
        BigInteger bigInteger = dHKeyGeneratorHelper.calculatePrivate(dHParameters, this.param.getRandom());
        BigInteger bigInteger2 = dHKeyGeneratorHelper.calculatePublic(dHParameters, bigInteger);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(bigInteger2, dHParameters), new DHPrivateKeyParameters(bigInteger, dHParameters));
    }
}

