/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.settings;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.settings.CreateOboTokenRequest;
import com.databricks.internal.sdk.service.settings.CreateOboTokenResponse;
import com.databricks.internal.sdk.service.settings.DeleteTokenManagementRequest;
import com.databricks.internal.sdk.service.settings.GetTokenManagementRequest;
import com.databricks.internal.sdk.service.settings.GetTokenPermissionLevelsResponse;
import com.databricks.internal.sdk.service.settings.GetTokenResponse;
import com.databricks.internal.sdk.service.settings.ListTokenManagementRequest;
import com.databricks.internal.sdk.service.settings.ListTokensResponse;
import com.databricks.internal.sdk.service.settings.TokenInfo;
import com.databricks.internal.sdk.service.settings.TokenManagementImpl;
import com.databricks.internal.sdk.service.settings.TokenManagementService;
import com.databricks.internal.sdk.service.settings.TokenPermissions;
import com.databricks.internal.sdk.service.settings.TokenPermissionsRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class TokenManagementAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TokenManagementAPI.class);
    private final TokenManagementService impl;

    public TokenManagementAPI(ApiClient apiClient) {
        this.impl = new TokenManagementImpl(apiClient);
    }

    public TokenManagementAPI(TokenManagementService mock) {
        this.impl = mock;
    }

    public CreateOboTokenResponse createOboToken(CreateOboTokenRequest request) {
        return this.impl.createOboToken(request);
    }

    public void delete(String tokenId) {
        this.delete(new DeleteTokenManagementRequest().setTokenId(tokenId));
    }

    public void delete(DeleteTokenManagementRequest request) {
        this.impl.delete(request);
    }

    public GetTokenResponse get(String tokenId) {
        return this.get(new GetTokenManagementRequest().setTokenId(tokenId));
    }

    public GetTokenResponse get(GetTokenManagementRequest request) {
        return this.impl.get(request);
    }

    public GetTokenPermissionLevelsResponse getPermissionLevels() {
        return this.impl.getPermissionLevels();
    }

    public TokenPermissions getPermissions() {
        return this.impl.getPermissions();
    }

    public Iterable<TokenInfo> list(ListTokenManagementRequest request) {
        return new Paginator(request, this.impl::list, ListTokensResponse::getTokenInfos, response -> null);
    }

    public TokenPermissions setPermissions(TokenPermissionsRequest request) {
        return this.impl.setPermissions(request);
    }

    public TokenPermissions updatePermissions(TokenPermissionsRequest request) {
        return this.impl.updatePermissions(request);
    }

    public TokenManagementService impl() {
        return this.impl;
    }
}

