/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractReconnectionHandler;
import com.datastax.driver.core.AuthInfoProvider;
import com.datastax.driver.core.BusyConnectionException;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Connection;
import com.datastax.driver.core.ConnectionException;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostConnectionPool;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleFuture;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.collect.HashMultimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.Message;
import org.apache.cassandra.transport.messages.EventMessage;
import org.apache.cassandra.transport.messages.PrepareMessage;
import org.apache.cassandra.utils.MD5Digest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cluster {
    private static final Logger logger = LoggerFactory.getLogger(Cluster.class);
    final Manager manager;

    private Cluster(List<InetAddress> contactPoints, Configuration configuration) {
        this.manager = new Manager(contactPoints, configuration);
        this.manager.init();
    }

    public static Cluster buildFrom(Initializer initializer) {
        List<InetAddress> contactPoints = initializer.getContactPoints();
        if (contactPoints.isEmpty()) {
            throw new IllegalArgumentException("Cannot build a cluster without contact points");
        }
        return new Cluster(contactPoints, initializer.getConfiguration());
    }

    public static Builder builder() {
        return new Builder();
    }

    public Session connect() {
        return this.manager.newSession();
    }

    public Session connect(String keyspace) {
        Session session = this.connect();
        session.manager.setKeyspace(keyspace);
        return session;
    }

    public Metadata getMetadata() {
        return this.manager.metadata;
    }

    public Configuration getConfiguration() {
        return this.manager.configuration;
    }

    public Metrics getMetrics() {
        return this.manager.configuration.isMetricsEnabled() ? this.manager.metrics : null;
    }

    public void shutdown() {
        this.manager.shutdown();
    }

    private static ThreadFactory threadFactory(String nameFormat) {
        return new ThreadFactoryBuilder().setNameFormat(nameFormat).build();
    }

    static /* synthetic */ ThreadFactory access$400(String x0) {
        return Cluster.threadFactory(x0);
    }

    class Manager
    implements Host.StateListener,
    Connection.DefaultResponseHandler {
        final List<InetAddress> contactPoints;
        final Set<Session> sessions = new CopyOnWriteArraySet<Session>();
        final Metadata metadata;
        final Configuration configuration;
        final Metrics metrics;
        final Connection.Factory connectionFactory;
        final ControlConnection controlConnection;
        final ConvictionPolicy.Factory convictionPolicyFactory = new ConvictionPolicy.Simple.Factory();
        final ScheduledExecutorService reconnectionExecutor = Executors.newScheduledThreadPool(2, Cluster.access$400("Reconnection-%d"));
        final ScheduledExecutorService scheduledTasksExecutor = Executors.newScheduledThreadPool(1, Cluster.access$400("Scheduled Tasks-%d"));
        final ExecutorService executor = Executors.newCachedThreadPool(Cluster.access$400("Cassandra Java Driver worker-%d"));
        final AtomicBoolean isShutdown = new AtomicBoolean(false);
        final Map<MD5Digest, PreparedStatement> preparedQueries = new ConcurrentHashMap<MD5Digest, PreparedStatement>();

        private Manager(List<InetAddress> contactPoints, Configuration configuration) {
            this.configuration = configuration;
            this.metadata = new Metadata(this);
            this.contactPoints = contactPoints;
            this.connectionFactory = new Connection.Factory(this, configuration.getAuthInfoProvider());
            for (InetAddress address : contactPoints) {
                this.addHost(address, false);
            }
            this.controlConnection = new ControlConnection(this, this.metadata);
            this.metrics = new Metrics(this);
            this.configuration.register(this);
            try {
                this.controlConnection.connect();
            }
            catch (NoHostAvailableException e) {
                this.shutdown();
                throw e;
            }
        }

        private void init() {
            this.configuration.getPolicies().getLoadBalancingPolicy().init(Cluster.this, this.metadata.getAllHosts());
        }

        Cluster getCluster() {
            return Cluster.this;
        }

        private Session newSession() {
            Session session = new Session(Cluster.this, this.metadata.allHosts());
            this.sessions.add(session);
            return session;
        }

        private void shutdown() {
            if (!this.isShutdown.compareAndSet(false, true)) {
                return;
            }
            logger.debug("Shutting down");
            this.controlConnection.shutdown();
            for (Session session : this.sessions) {
                session.shutdown();
            }
            this.reconnectionExecutor.shutdownNow();
            this.scheduledTasksExecutor.shutdownNow();
            this.executor.shutdownNow();
            this.connectionFactory.shutdown();
            if (this.metrics != null) {
                this.metrics.shutdown();
            }
        }

        @Override
        public void onUp(Host host) {
            logger.trace("Host {} is UP", (Object)host);
            ScheduledFuture scheduledAttempt = host.reconnectionAttempt.getAndSet(null);
            if (scheduledAttempt != null) {
                scheduledAttempt.cancel(false);
            }
            try {
                this.prepareAllQueries(host);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            this.controlConnection.onUp(host);
            for (Session s : this.sessions) {
                s.manager.onUp(host);
            }
        }

        @Override
        public void onDown(final Host host) {
            logger.trace("Host {} is DOWN", (Object)host);
            this.controlConnection.onDown(host);
            for (Session s : this.sessions) {
                s.manager.onDown(host);
            }
            logger.debug("{} is down, scheduling connection retries", (Object)host);
            new AbstractReconnectionHandler(this.reconnectionExecutor, this.configuration.getPolicies().getReconnectionPolicy().newSchedule(), host.reconnectionAttempt){

                @Override
                protected Connection tryReconnect() throws ConnectionException, InterruptedException {
                    return Manager.this.connectionFactory.open(host);
                }

                @Override
                protected void onReconnection(Connection connection) {
                    logger.debug("Successful reconnection to {}, setting host UP", (Object)host);
                    host.getMonitor().reset();
                }

                @Override
                protected boolean onConnectionException(ConnectionException e, long nextDelayMs) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Failed reconnection to {} ({}), scheduling retry in {} milliseconds", new Object[]{host, e.getMessage(), nextDelayMs});
                    }
                    return true;
                }

                @Override
                protected boolean onUnknownException(Exception e, long nextDelayMs) {
                    logger.error(String.format("Unknown error during control connection reconnection, scheduling retry in %d milliseconds", nextDelayMs), (Throwable)e);
                    return true;
                }
            }.start();
        }

        @Override
        public void onAdd(Host host) {
            logger.trace("Adding new host {}", (Object)host);
            try {
                this.prepareAllQueries(host);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
            }
            this.controlConnection.onAdd(host);
            for (Session s : this.sessions) {
                s.manager.onAdd(host);
            }
        }

        @Override
        public void onRemove(Host host) {
            logger.trace("Removing host {}", (Object)host);
            this.controlConnection.onRemove(host);
            for (Session s : this.sessions) {
                s.manager.onRemove(host);
            }
        }

        public Host addHost(InetAddress address, boolean signal) {
            Host newHost = this.metadata.add(address);
            if (newHost != null && signal) {
                logger.info("New Cassandra host {} added", (Object)newHost);
                this.onAdd(newHost);
            }
            return newHost;
        }

        public void removeHost(Host host) {
            if (host == null) {
                return;
            }
            if (this.metadata.remove(host)) {
                logger.info("Cassandra host {} removed", (Object)host);
                this.onRemove(host);
            }
        }

        public void ensurePoolsSizing() {
            for (Session session : this.sessions) {
                for (HostConnectionPool pool : session.manager.pools.values()) {
                    pool.ensureCoreConnections();
                }
            }
        }

        public void prepare(MD5Digest digest, PreparedStatement stmt, InetAddress toExclude) throws InterruptedException {
            this.preparedQueries.put(digest, stmt);
            for (Session s : this.sessions) {
                s.manager.prepare(stmt.getQueryString(), toExclude);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void prepareAllQueries(Host host) throws InterruptedException {
            if (this.preparedQueries.isEmpty()) {
                return;
            }
            logger.debug("Preparing {} prepared queries on newly up node {}", (Object)this.preparedQueries.size(), (Object)host);
            try {
                Connection connection = this.connectionFactory.open(host);
                try {
                    try {
                        ControlConnection.waitForSchemaAgreement(connection, this.metadata);
                    }
                    catch (ExecutionException e) {
                        // empty catch block
                    }
                    HashMultimap perKeyspace = HashMultimap.create();
                    for (PreparedStatement ps : this.preparedQueries.values()) {
                        String keyspace = ps.getQueryKeyspace() == null ? "" : ps.getQueryKeyspace();
                        perKeyspace.put((Object)keyspace, (Object)ps.getQueryString());
                    }
                    for (String keyspace : perKeyspace.keySet()) {
                        if (!keyspace.isEmpty()) {
                            connection.setKeyspace(keyspace);
                        }
                        ArrayList<Connection.Future> futures = new ArrayList<Connection.Future>(this.preparedQueries.size());
                        for (String query : perKeyspace.get((Object)keyspace)) {
                            futures.add(connection.write((Message.Request)new PrepareMessage(query)));
                        }
                        for (Connection.Future future : futures) {
                            try {
                                future.get();
                            }
                            catch (ExecutionException e) {
                                logger.debug("Unexpected error while preparing queries on new/newly up host", (Throwable)e);
                            }
                        }
                    }
                }
                finally {
                    connection.close();
                }
            }
            catch (ConnectionException e) {
            }
            catch (AuthenticationException e) {
            }
            catch (BusyConnectionException busyConnectionException) {
                // empty catch block
            }
        }

        public void submitSchemaRefresh(final String keyspace, final String table) {
            logger.trace("Submitting schema refresh");
            this.executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Manager.this.controlConnection.refreshSchema(keyspace, table);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            });
        }

        public void refreshSchema(final Connection connection, final SimpleFuture future, final ResultSet rs, final String keyspace, final String table) {
            if (logger.isDebugEnabled()) {
                logger.debug("Refreshing schema for {}{}", (Object)(keyspace == null ? "" : keyspace), (Object)(table == null ? "" : "." + table));
            }
            this.executor.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ControlConnection.waitForSchemaAgreement(connection, Manager.this.metadata);
                        ControlConnection.refreshSchema(connection, keyspace, table, Manager.this);
                    }
                    catch (Exception e) {
                        logger.error("Error during schema refresh ({}). The schema from Cluster.getMetadata() might appear stale. Asynchronously submitting job to fix.", (Object)e.getMessage());
                        Manager.this.submitSchemaRefresh(keyspace, table);
                    }
                    finally {
                        future.set(rs);
                    }
                }
            });
        }

        @Override
        public void handle(Message.Response response) {
            if (!(response instanceof EventMessage)) {
                logger.error("Received an unexpected message from the server: {}", (Object)response);
                return;
            }
            final Event event = ((EventMessage)response).event;
            logger.debug("Received event {}, scheduling delivery", (Object)response);
            this.scheduledTasksExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    block0 : switch (event.type) {
                        case TOPOLOGY_CHANGE: {
                            Event.TopologyChange tpc = (Event.TopologyChange)event;
                            switch (tpc.change) {
                                case NEW_NODE: {
                                    Manager.this.addHost(tpc.node.getAddress(), true);
                                    break;
                                }
                                case REMOVED_NODE: {
                                    Manager.this.removeHost(Manager.this.metadata.getHost(tpc.node.getAddress()));
                                    break;
                                }
                                case MOVED_NODE: {
                                    Manager.this.controlConnection.refreshNodeListAndTokenMap();
                                }
                            }
                            break;
                        }
                        case STATUS_CHANGE: {
                            Event.StatusChange stc = (Event.StatusChange)event;
                            switch (stc.status) {
                                case UP: {
                                    Host host = Manager.this.metadata.getHost(stc.node.getAddress());
                                    if (host == null) {
                                        Manager.this.addHost(stc.node.getAddress(), true);
                                        break block0;
                                    }
                                    Manager.this.onUp(host);
                                    break block0;
                                }
                            }
                            break;
                        }
                        case SCHEMA_CHANGE: {
                            Event.SchemaChange scc = (Event.SchemaChange)event;
                            switch (scc.change) {
                                case CREATED: {
                                    if (scc.table.isEmpty()) {
                                        Manager.this.submitSchemaRefresh(null, null);
                                        break block0;
                                    }
                                    Manager.this.submitSchemaRefresh(scc.keyspace, null);
                                    break block0;
                                }
                                case DROPPED: {
                                    if (scc.table.isEmpty()) {
                                        Manager.this.submitSchemaRefresh(null, null);
                                        break block0;
                                    }
                                    Manager.this.submitSchemaRefresh(scc.keyspace, null);
                                    break block0;
                                }
                                case UPDATED: {
                                    if (scc.table.isEmpty()) {
                                        Manager.this.submitSchemaRefresh(scc.keyspace, null);
                                        break block0;
                                    }
                                    Manager.this.submitSchemaRefresh(scc.keyspace, scc.table);
                                }
                            }
                        }
                    }
                }
            }, 1L, TimeUnit.SECONDS);
        }
    }

    public static class Builder
    implements Initializer {
        private final List<InetAddress> addresses = new ArrayList<InetAddress>();
        private int port = 9042;
        private AuthInfoProvider authProvider = AuthInfoProvider.NONE;
        private LoadBalancingPolicy loadBalancingPolicy;
        private ReconnectionPolicy reconnectionPolicy;
        private RetryPolicy retryPolicy;
        private ProtocolOptions.Compression compression = ProtocolOptions.Compression.NONE;
        private boolean metricsEnabled = true;
        private final PoolingOptions poolingOptions = new PoolingOptions();
        private final SocketOptions socketOptions = new SocketOptions();

        @Override
        public List<InetAddress> getContactPoints() {
            return this.addresses;
        }

        public Builder withPort(int port) {
            this.port = port;
            return this;
        }

        public Builder addContactPoint(String address) {
            try {
                this.addresses.add(InetAddress.getByName(address));
                return this;
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public Builder addContactPoints(String ... addresses) {
            for (String address : addresses) {
                this.addContactPoint(address);
            }
            return this;
        }

        public Builder addContactPoints(InetAddress ... addresses) {
            for (InetAddress address : addresses) {
                this.addresses.add(address);
            }
            return this;
        }

        public Builder withLoadBalancingPolicy(LoadBalancingPolicy policy) {
            this.loadBalancingPolicy = policy;
            return this;
        }

        public Builder withReconnectionPolicy(ReconnectionPolicy policy) {
            this.reconnectionPolicy = policy;
            return this;
        }

        public Builder withRetryPolicy(RetryPolicy policy) {
            this.retryPolicy = policy;
            return this;
        }

        public Builder withAuthInfoProvider(AuthInfoProvider authInfoProvider) {
            this.authProvider = authInfoProvider;
            return this;
        }

        public Builder withCompression(ProtocolOptions.Compression compression) {
            this.compression = compression;
            return this;
        }

        public Builder withoutMetrics() {
            this.metricsEnabled = false;
            return this;
        }

        public PoolingOptions poolingOptions() {
            return this.poolingOptions;
        }

        public SocketOptions socketOptions() {
            return this.socketOptions;
        }

        @Override
        public Configuration getConfiguration() {
            Policies policies = new Policies(this.loadBalancingPolicy == null ? Policies.DEFAULT_LOAD_BALANCING_POLICY : this.loadBalancingPolicy, this.reconnectionPolicy == null ? Policies.DEFAULT_RECONNECTION_POLICY : this.reconnectionPolicy, this.retryPolicy == null ? Policies.DEFAULT_RETRY_POLICY : this.retryPolicy);
            return new Configuration(policies, new ProtocolOptions(this.port).setCompression(this.compression), this.poolingOptions, this.socketOptions, this.authProvider, this.metricsEnabled);
        }

        public Cluster build() {
            return Cluster.buildFrom(this);
        }
    }

    public static interface Initializer {
        public List<InetAddress> getContactPoints();

        public Configuration getConfiguration();
    }
}

