/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import org.apache.cassandra.transport.FrameCompressor;

public class ProtocolOptions {
    public static final int DEFAULT_PORT = 9042;
    private final int port;
    private volatile Compression compression = Compression.NONE;
    private volatile Cluster.Manager manager;

    public ProtocolOptions() {
        this(9042);
    }

    public ProtocolOptions(int port) {
        this.port = port;
    }

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getPort() {
        return this.port;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public ProtocolOptions setCompression(Compression compression) {
        if (compression != Compression.NONE && compression.compressor == null) {
            throw new IllegalStateException("The requested compression is not available (some compression require a JAR to be found in the classpath)");
        }
        this.compression = compression;
        return this;
    }

    public static enum Compression {
        NONE("", null),
        SNAPPY("snappy", (FrameCompressor)FrameCompressor.SnappyCompressor.instance);

        final String protocolName;
        final FrameCompressor compressor;

        private Compression(String protocolName, FrameCompressor compressor) {
            this.protocolName = protocolName;
            this.compressor = compressor;
        }

        FrameCompressor compressor() {
            return this.compressor;
        }

        public String toString() {
            return this.protocolName;
        }
    }
}

