/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.api.core.metadata.TokenMap;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.DefaultNodeFilterHelper;
import com.datastax.oss.driver.internal.core.loadbalancing.helper.OptionalLocalDcHelper;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.DcAgnosticNodeSet;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.MultiDcNodeSet;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.NodeSet;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.SingleDcNodeSet;
import com.datastax.oss.driver.internal.core.util.ArrayUtils;
import com.datastax.oss.driver.internal.core.util.collection.CompositeQueryPlan;
import com.datastax.oss.driver.internal.core.util.collection.LazyQueryPlan;
import com.datastax.oss.driver.internal.core.util.collection.QueryPlan;
import com.datastax.oss.driver.internal.core.util.collection.SimpleQueryPlan;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import net.jcip.annotations.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BasicLoadBalancingPolicy
implements LoadBalancingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(BasicLoadBalancingPolicy.class);
    protected static final IntUnaryOperator INCREMENT = i -> i == Integer.MAX_VALUE ? 0 : i + 1;
    private static final Object[] EMPTY_NODES = new Object[0];
    @NonNull
    protected final InternalDriverContext context;
    @NonNull
    protected final DriverExecutionProfile profile;
    @NonNull
    protected final String logPrefix;
    protected final AtomicInteger roundRobinAmount = new AtomicInteger();
    private final int maxNodesPerRemoteDc;
    private final boolean allowDcFailoverForLocalCl;
    private final ConsistencyLevel defaultConsistencyLevel;
    private volatile LoadBalancingPolicy.DistanceReporter distanceReporter;
    private volatile Predicate<Node> filter;
    private volatile String localDc;
    private volatile NodeSet liveNodes;

    public BasicLoadBalancingPolicy(@NonNull DriverContext context, @NonNull String profileName) {
        this.context = (InternalDriverContext)context;
        this.profile = context.getConfig().getProfile(profileName);
        this.logPrefix = context.getSessionName() + "|" + profileName;
        this.maxNodesPerRemoteDc = this.profile.getInt(DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC);
        this.allowDcFailoverForLocalCl = this.profile.getBoolean(DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_ALLOW_FOR_LOCAL_CONSISTENCY_LEVELS);
        this.defaultConsistencyLevel = this.context.getConsistencyLevelRegistry().nameToLevel(this.profile.getString(DefaultDriverOption.REQUEST_CONSISTENCY));
    }

    @Nullable
    protected String getLocalDatacenter() {
        return this.localDc;
    }

    protected NodeSet getLiveNodes() {
        return this.liveNodes;
    }

    @Override
    public void init(@NonNull Map<UUID, Node> nodes, @NonNull LoadBalancingPolicy.DistanceReporter distanceReporter) {
        this.distanceReporter = distanceReporter;
        this.localDc = this.discoverLocalDc(nodes).orElse(null);
        this.filter = this.createNodeFilter(this.localDc, nodes);
        this.liveNodes = this.localDc == null ? new DcAgnosticNodeSet() : (this.maxNodesPerRemoteDc <= 0 ? new SingleDcNodeSet(this.localDc) : new MultiDcNodeSet());
        for (Node node : nodes.values()) {
            NodeDistance distance = this.computeNodeDistance(node);
            distanceReporter.setDistance(node, distance);
            if (distance == NodeDistance.IGNORED || node.getState() == NodeState.DOWN) continue;
            this.liveNodes.add(node);
        }
    }

    @NonNull
    protected Optional<String> discoverLocalDc(@NonNull Map<UUID, Node> nodes) {
        return new OptionalLocalDcHelper(this.context, this.profile, this.logPrefix).discoverLocalDc(nodes);
    }

    @NonNull
    protected Predicate<Node> createNodeFilter(@Nullable String localDc, @NonNull Map<UUID, Node> nodes) {
        return new DefaultNodeFilterHelper(this.context, this.profile, this.logPrefix).createNodeFilter(localDc, nodes);
    }

    @Override
    @NonNull
    public Queue<Node> newQueryPlan(@Nullable Request request, @Nullable Session session) {
        Object[] currentNodes = this.liveNodes.dc(this.localDc).toArray();
        Set<Node> allReplicas = this.getReplicas(request, session);
        int replicaCount = 0;
        if (!allReplicas.isEmpty()) {
            for (int i = 0; i < currentNodes.length; ++i) {
                Node node = (Node)currentNodes[i];
                if (!allReplicas.contains(node)) continue;
                ArrayUtils.bubbleUp(currentNodes, i, replicaCount);
                ++replicaCount;
            }
            if (replicaCount > 1) {
                this.shuffleHead(currentNodes, replicaCount);
            }
        }
        LOG.trace("[{}] Prioritizing {} local replicas", (Object)this.logPrefix, (Object)replicaCount);
        ArrayUtils.rotate(currentNodes, replicaCount, currentNodes.length - replicaCount, this.roundRobinAmount.getAndUpdate(INCREMENT));
        QueryPlan plan = currentNodes.length == 0 ? QueryPlan.EMPTY : new SimpleQueryPlan(currentNodes);
        return this.maybeAddDcFailover(request, plan);
    }

    @NonNull
    protected Set<Node> getReplicas(@Nullable Request request, @Nullable Session session) {
        ByteBuffer key;
        Token token;
        CqlIdentifier keyspace;
        if (request == null || session == null) {
            return Collections.emptySet();
        }
        Optional<TokenMap> maybeTokenMap = this.context.getMetadataManager().getMetadata().getTokenMap();
        if (!maybeTokenMap.isPresent()) {
            return Collections.emptySet();
        }
        try {
            keyspace = request.getKeyspace();
            if (keyspace == null) {
                keyspace = request.getRoutingKeyspace();
            }
            if (keyspace == null && session.getKeyspace().isPresent()) {
                keyspace = session.getKeyspace().get();
            }
            if (keyspace == null) {
                return Collections.emptySet();
            }
            token = request.getRoutingToken();
            ByteBuffer byteBuffer = key = token == null ? request.getRoutingKey() : null;
            if (token == null && key == null) {
                return Collections.emptySet();
            }
        }
        catch (Exception e) {
            LOG.error("Unexpected error while trying to compute query plan", (Throwable)e);
            return Collections.emptySet();
        }
        TokenMap tokenMap = maybeTokenMap.get();
        return token != null ? tokenMap.getReplicas(keyspace, token) : tokenMap.getReplicas(keyspace, key);
    }

    @NonNull
    protected Queue<Node> maybeAddDcFailover(@Nullable Request request, @NonNull Queue<Node> local) {
        if (this.maxNodesPerRemoteDc <= 0 || this.localDc == null) {
            return local;
        }
        if (!this.allowDcFailoverForLocalCl && request instanceof Statement) {
            Statement statement = (Statement)request;
            ConsistencyLevel consistency = statement.getConsistencyLevel();
            if (consistency == null) {
                consistency = this.defaultConsistencyLevel;
            }
            if (consistency.isDcLocal()) {
                return local;
            }
        }
        LazyQueryPlan remote = new LazyQueryPlan(){

            @Override
            protected Object[] computeNodes() {
                Object[] dcs = BasicLoadBalancingPolicy.this.liveNodes.dcs().toArray();
                if (dcs.length <= 1) {
                    return EMPTY_NODES;
                }
                Object[] remoteNodes = new Object[(dcs.length - 1) * BasicLoadBalancingPolicy.this.maxNodesPerRemoteDc];
                int remoteNodesLength = 0;
                for (Object dc : dcs) {
                    if (dc.equals(BasicLoadBalancingPolicy.this.localDc)) continue;
                    Object[] remoteNodesInDc = BasicLoadBalancingPolicy.this.liveNodes.dc((String)dc).toArray();
                    for (int i = 0; i < BasicLoadBalancingPolicy.this.maxNodesPerRemoteDc && i < remoteNodesInDc.length; ++i) {
                        remoteNodes[remoteNodesLength++] = remoteNodesInDc[i];
                    }
                }
                if (remoteNodesLength == 0) {
                    return EMPTY_NODES;
                }
                BasicLoadBalancingPolicy.this.shuffleHead(remoteNodes, remoteNodesLength);
                if (remoteNodes.length == remoteNodesLength) {
                    return remoteNodes;
                }
                Object[] trimmedRemoteNodes = new Object[remoteNodesLength];
                System.arraycopy(remoteNodes, 0, trimmedRemoteNodes, 0, remoteNodesLength);
                return trimmedRemoteNodes;
            }
        };
        return new CompositeQueryPlan(local, remote);
    }

    protected void shuffleHead(Object[] currentNodes, int headLength) {
        ArrayUtils.shuffleHead(currentNodes, headLength);
    }

    @Override
    public void onAdd(@NonNull Node node) {
        NodeDistance distance = this.computeNodeDistance(node);
        this.distanceReporter.setDistance(node, distance);
        LOG.debug("[{}] {} was added, setting distance to {}", new Object[]{this.logPrefix, node, distance});
    }

    @Override
    public void onUp(@NonNull Node node) {
        NodeDistance distance = this.computeNodeDistance(node);
        if (node.getDistance() != distance) {
            this.distanceReporter.setDistance(node, distance);
        }
        if (distance != NodeDistance.IGNORED && this.liveNodes.add(node)) {
            LOG.debug("[{}] {} came back UP, added to live set", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void onDown(@NonNull Node node) {
        if (this.liveNodes.remove(node)) {
            LOG.debug("[{}] {} went DOWN, removed from live set", (Object)this.logPrefix, (Object)node);
        }
    }

    @Override
    public void onRemove(@NonNull Node node) {
        if (this.liveNodes.remove(node)) {
            LOG.debug("[{}] {} was removed, removed from live set", (Object)this.logPrefix, (Object)node);
        }
    }

    protected NodeDistance computeNodeDistance(@NonNull Node node) {
        if (!this.filter.test(node)) {
            return NodeDistance.IGNORED;
        }
        if (this.localDc == null) {
            return NodeDistance.LOCAL;
        }
        if (Objects.equals(node.getDatacenter(), this.localDc)) {
            return NodeDistance.LOCAL;
        }
        if (this.maxNodesPerRemoteDc > 0) {
            Object[] remoteNodes = this.liveNodes.dc(node.getDatacenter()).toArray();
            for (int i = 0; i < this.maxNodesPerRemoteDc; ++i) {
                if (i == remoteNodes.length) {
                    return NodeDistance.REMOTE;
                }
                if (remoteNodes[i] != node) continue;
                return NodeDistance.REMOTE;
            }
        }
        return NodeDistance.IGNORED;
    }

    @Override
    public void close() {
    }
}

