/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.util;

import com.datastax.oss.driver.internal.core.util.Reflection;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;

public enum DependencyCheck {
    SNAPPY("org.xerial.snappy.Snappy"),
    LZ4("net.jpountz.lz4.LZ4Compressor"),
    ESRI("com.datastax.oss.driver.shaded.esri.core.geometry.ogc.OGCGeometry"),
    TINKERPOP("org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal", "org.apache.tinkerpop.gremlin.tinkergraph.structure.TinkerIoRegistryV3d0"),
    REACTIVE_STREAMS("org.reactivestreams.Publisher"),
    JACKSON("com.datastax.oss.driver.shaded.fasterxml.jackson.core.JsonParser", "com.datastax.oss.driver.shaded.fasterxml.jackson.databind.ObjectMapper");

    private final ImmutableSet<String> fqcns;

    private DependencyCheck(String ... fqcns) {
        this.fqcns = ImmutableSet.copyOf((Object[])fqcns);
    }

    public boolean isPresent() {
        for (String fqcn : this.fqcns) {
            if (Reflection.loadClass(null, fqcn) != null) continue;
            return false;
        }
        return true;
    }
}

