/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.util.ConfigCheck$;
import com.datastax.spark.connector.util.ConfigParameter;
import org.apache.spark.SparkConf;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ReadConf$
implements Serializable {
    public static final ReadConf$ MODULE$;
    private final String ReferenceSection;
    private final ConfigParameter<Object> SplitSizeInMBParam;
    private final ConfigParameter<Object> FetchSizeInRowsParam;
    private final ConfigParameter<ConsistencyLevel> ConsistencyLevelParam;
    private final ConfigParameter<Object> TaskMetricParam;
    private final ConfigParameter<Object> ThroughputJoinQueryPerSecParam;
    private final Set<ConfigParameter<? super Object>> Properties;

    static {
        new ReadConf$();
    }

    public String ReferenceSection() {
        return this.ReferenceSection;
    }

    public ConfigParameter<Object> SplitSizeInMBParam() {
        return this.SplitSizeInMBParam;
    }

    public ConfigParameter<Object> FetchSizeInRowsParam() {
        return this.FetchSizeInRowsParam;
    }

    public ConfigParameter<ConsistencyLevel> ConsistencyLevelParam() {
        return this.ConsistencyLevelParam;
    }

    public ConfigParameter<Object> TaskMetricParam() {
        return this.TaskMetricParam;
    }

    public ConfigParameter<Object> ThroughputJoinQueryPerSecParam() {
        return this.ThroughputJoinQueryPerSecParam;
    }

    public Set<ConfigParameter<? super Object>> Properties() {
        return this.Properties;
    }

    public ReadConf fromSparkConf(SparkConf conf) {
        ConfigCheck$.MODULE$.checkConfig(conf);
        int x$2 = conf.getInt(this.FetchSizeInRowsParam().name(), BoxesRunTime.unboxToInt((Object)this.FetchSizeInRowsParam().default()));
        int x$3 = conf.getInt(this.SplitSizeInMBParam().name(), BoxesRunTime.unboxToInt((Object)this.SplitSizeInMBParam().default()));
        ConsistencyLevel x$4 = ConsistencyLevel.valueOf((String)conf.get(this.ConsistencyLevelParam().name(), ((Enum)this.ConsistencyLevelParam().default()).name()));
        boolean x$5 = conf.getBoolean(this.TaskMetricParam().name(), BoxesRunTime.unboxToBoolean((Object)this.TaskMetricParam().default()));
        long x$6 = conf.getLong(this.ThroughputJoinQueryPerSecParam().name(), BoxesRunTime.unboxToLong((Object)this.ThroughputJoinQueryPerSecParam().default()));
        Option<Object> x$7 = this.apply$default$1();
        return new ReadConf(x$7, x$3, x$2, x$4, x$5, x$6);
    }

    public ReadConf apply(Option<Object> splitCount, int splitSizeInMB, int fetchSizeInRows, ConsistencyLevel consistencyLevel, boolean taskMetricsEnabled, long throughputJoinQueryPerSec) {
        return new ReadConf(splitCount, splitSizeInMB, fetchSizeInRows, consistencyLevel, taskMetricsEnabled, throughputJoinQueryPerSec);
    }

    public Option<Tuple6<Option<Object>, Object, Object, ConsistencyLevel, Object, Object>> unapply(ReadConf x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6(x$0.splitCount(), (Object)BoxesRunTime.boxToInteger((int)x$0.splitSizeInMB()), (Object)BoxesRunTime.boxToInteger((int)x$0.fetchSizeInRows()), (Object)x$0.consistencyLevel(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.taskMetricsEnabled()), (Object)BoxesRunTime.boxToLong((long)x$0.throughputJoinQueryPerSec())));
    }

    public Option<Object> apply$default$1() {
        return None$.MODULE$;
    }

    public int apply$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.SplitSizeInMBParam().default());
    }

    public int apply$default$3() {
        return BoxesRunTime.unboxToInt((Object)this.FetchSizeInRowsParam().default());
    }

    public ConsistencyLevel apply$default$4() {
        return this.ConsistencyLevelParam().default();
    }

    public boolean apply$default$5() {
        return BoxesRunTime.unboxToBoolean((Object)this.TaskMetricParam().default());
    }

    public long apply$default$6() {
        return BoxesRunTime.unboxToLong((Object)this.ThroughputJoinQueryPerSecParam().default());
    }

    public Option<Object> $lessinit$greater$default$1() {
        return None$.MODULE$;
    }

    public int $lessinit$greater$default$2() {
        return BoxesRunTime.unboxToInt((Object)this.SplitSizeInMBParam().default());
    }

    public int $lessinit$greater$default$3() {
        return BoxesRunTime.unboxToInt((Object)this.FetchSizeInRowsParam().default());
    }

    public ConsistencyLevel $lessinit$greater$default$4() {
        return this.ConsistencyLevelParam().default();
    }

    public boolean $lessinit$greater$default$5() {
        return BoxesRunTime.unboxToBoolean((Object)this.TaskMetricParam().default());
    }

    public long $lessinit$greater$default$6() {
        return BoxesRunTime.unboxToLong((Object)this.ThroughputJoinQueryPerSecParam().default());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private ReadConf$() {
        MODULE$ = this;
        this.ReferenceSection = "Read Tuning Parameters";
        this.SplitSizeInMBParam = new ConfigParameter<Integer>("spark.cassandra.input.split.size_in_mb", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)64), (String)new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString("Approx amount of data to be fetched into a Spark partition. Minimum number of resulting Spark\n        | partitions is <code>1 + 2 * SparkContext.defaultParallelism</code>\n        |")).stripMargin())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(char x$1) {
                return x$1 >= ' ';
            }
        }));
        this.FetchSizeInRowsParam = new ConfigParameter<Integer>("spark.cassandra.input.fetch.size_in_rows", this.ReferenceSection(), BoxesRunTime.boxToInteger((int)1000), "Number of CQL rows fetched per driver request");
        this.ConsistencyLevelParam = new ConfigParameter<ConsistencyLevel>("spark.cassandra.input.consistency.level", this.ReferenceSection(), ConsistencyLevel.LOCAL_ONE, "Consistency level to use when reading\t");
        this.TaskMetricParam = new ConfigParameter<Boolean>("spark.cassandra.input.metrics", this.ReferenceSection(), BoxesRunTime.boxToBoolean((boolean)true), "Sets whether to record connector specific metrics on write");
        this.ThroughputJoinQueryPerSecParam = new ConfigParameter<Long>("spark.cassandra.input.join.throughput_query_per_sec", this.ReferenceSection(), BoxesRunTime.boxToLong((long)Long.MAX_VALUE), "Maximum read throughput allowed per single core in query/s while joining RDD with C* table");
        this.Properties = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigParameter[]{this.SplitSizeInMBParam(), this.FetchSizeInRowsParam(), this.ConsistencyLevelParam(), this.TaskMetricParam(), this.ThroughputJoinQueryPerSecParam()}));
    }
}

