/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.streaming;

import com.datastax.spark.connector.AllColumns$;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.PartitionKeyColumns$;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.package$;
import com.datastax.spark.connector.rdd.CassandraJoinRDD;
import com.datastax.spark.connector.rdd.ValidRDDType;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitionedRDD;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartitioner;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import com.datastax.spark.connector.streaming.DStreamFunctions$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Logging$class;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.TableWriter;
import com.datastax.spark.connector.writer.TableWriter$;
import com.datastax.spark.connector.writer.WritableToCassandra;
import com.datastax.spark.connector.writer.WriteConf;
import com.datastax.spark.connector.writer.WriteConf$;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.dstream.DStream;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0001\u0003\u00015\u0011\u0001\u0003R*ue\u0016\fWNR;oGRLwN\\:\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0005d_:tWm\u0019;pe*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\t\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001U\u0011abF\n\u0005\u0001=\u0019c\u0005E\u0002\u0011'Ui\u0011!\u0005\u0006\u0003%\u0011\taa\u001e:ji\u0016\u0014\u0018B\u0001\u000b\u0012\u0005M9&/\u001b;bE2,Gk\\\"bgN\fg\u000e\u001a:b!\t1r\u0003\u0004\u0001\u0005\u000ba\u0001!\u0019A\r\u0003\u0003Q\u000b\"A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\u000f9{G\u000f[5oOB\u00111$I\u0005\u0003Eq\u00111!\u00118z!\tYB%\u0003\u0002&9\ta1+\u001a:jC2L'0\u00192mKB\u0011qEK\u0007\u0002Q)\u0011\u0011\u0006B\u0001\u0005kRLG.\u0003\u0002,Q\t9Aj\\4hS:<\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0018\u0002\u000f\u0011\u001cHO]3b[B\u0019qfN\u000b\u000e\u0003AR!!L\u0019\u000b\u0005\r\u0011$BA\u00044\u0015\t!T'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0005\u0019qN]4\n\u0005a\u0002$a\u0002#TiJ,\u0017-\u001c\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005qr\u0004cA\u001f\u0001+5\t!\u0001C\u0003.s\u0001\u0007a\u0006C\u0003A\u0001\u0011\u0005\u0011)\u0001\fxCJt\u0017JZ&fKB\fE.\u001b<f\u0013N\u001c\u0006n\u001c:u)\u0005\u0011\u0005CA\u000eD\u0013\t!ED\u0001\u0003V]&$\b\"\u0002$\u0001\t\u0003:\u0015\u0001D:qCJ\\7i\u001c8uKb$X#\u0001%\u0011\u0005%SU\"\u0001\u001a\n\u0005-\u0013$\u0001D*qCJ\\7i\u001c8uKb$\b\"B'\u0001\t\u0003q\u0015\u0001B2p]\u001a,\u0012a\u0014\t\u0003\u0013BK!!\u0015\u001a\u0003\u0013M\u0003\u0018M]6D_:4\u0007\"B*\u0001\t\u0003!\u0016aD:bm\u0016$vnQ1tg\u0006tGM]1\u0015\u000bU\u00137.\\:\u0015\u0007\t3V\fC\u0004\u0006%B\u0005\t9A,\u0011\u0005a[V\"A-\u000b\u0005i#\u0011aA2rY&\u0011A,\u0017\u0002\u0013\u0007\u0006\u001c8/\u00198ee\u0006\u001cuN\u001c8fGR|'\u000fC\u0003_%\u0002\u000fq,A\u0002so\u001a\u00042\u0001\u00051\u0016\u0013\t\t\u0017C\u0001\tS_^<&/\u001b;fe\u001a\u000b7\r^8ss\")1M\u0015a\u0001I\u0006a1.Z=ta\u0006\u001cWMT1nKB\u0011Q\r\u001b\b\u00037\u0019L!a\u001a\u000f\u0002\rA\u0013X\rZ3g\u0013\tI'N\u0001\u0004TiJLgn\u001a\u0006\u0003OrAQ\u0001\u001c*A\u0002\u0011\f\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000f9\u0014\u0006\u0013!a\u0001_\u0006Y1m\u001c7v[:t\u0015-\\3t!\t\u0001\u0018/D\u0001\u0005\u0013\t\u0011HA\u0001\bD_2,XN\\*fY\u0016\u001cGo\u001c:\t\u000fQ\u0014\u0006\u0013!a\u0001k\u0006IqO]5uK\u000e{gN\u001a\t\u0003!YL!a^\t\u0003\u0013]\u0013\u0018\u000e^3D_:4\u0007\"B=\u0001\t\u0003Q\u0018!\b:fa\u0006\u0014H/\u001b;j_:\u0014\u0015pQ1tg\u0006tGM]1SKBd\u0017nY1\u0015\u0013m\fi!a\u0004\u0002\u0012\u0005mA#\u0002\u0018}{\u0006-\u0001bB\u0003y!\u0003\u0005\u001da\u0016\u0005\u0006}b\u0004\u001da`\u0001\fGV\u0014(/\u001a8u)f\u0004X\rE\u0003\u0002\u0002\u0005\u001dQ#\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u000f\u0002\u000fI,g\r\\3di&!\u0011\u0011BA\u0002\u0005!\u0019E.Y:t)\u0006<\u0007\"\u00020y\u0001\by\u0006\"B2y\u0001\u0004!\u0007\"\u00027y\u0001\u0004!\u0007\"CA\nqB\u0005\t\u0019AA\u000b\u0003E\u0001\u0018M\u001d;ji&|gn\u001d)fe\"{7\u000f\u001e\t\u00047\u0005]\u0011bAA\r9\t\u0019\u0011J\u001c;\t\u0011\u0005u\u0001\u0010%AA\u0002=\f!\u0003]1si&$\u0018n\u001c8LKfl\u0015\r\u001d9fe\"9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012A\u00066pS:<\u0016\u000e\u001e5DCN\u001c\u0018M\u001c3sCR\u000b'\r\\3\u0016\t\u0005\u0015\u00121\u0007\u000b\u000b\u0003O\ti'a\u001c\u0002r\u0005UDCDA\u0015\u0003o\tI$a\u0010\u0002\\\u0005\u001d\u0014\u0011\u000e\t\u0005_]\nY\u0003\u0005\u0004\u001c\u0003[)\u0012\u0011G\u0005\u0004\u0003_a\"A\u0002+va2,'\u0007E\u0002\u0017\u0003g!q!!\u000e\u0002 \t\u0007\u0011DA\u0001S\u0011!)\u0011q\u0004I\u0001\u0002\b9\u0006\u0002CA\u001e\u0003?\u0001\u001d!!\u0010\u0002\u000f9,w\u000fV=qKB1\u0011\u0011AA\u0004\u0003cA\u0001\"!\u0011\u0002 \u0001\u000f\u00111I\u0001\u0004eJ4\u0007CBA#\u0003\u001f\n\t$\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u0019\u0011X-\u00193fe*\u0019\u0011Q\n\u0003\u0002\u0007I$G-\u0003\u0003\u0002R\u0005\u001d#\u0001\u0005*poJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:zQ\u0011\ty$!\u0016\u0011\u0007m\t9&C\u0002\u0002Zq\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011\u0005u\u0013q\u0004a\u0002\u0003?\n!!\u001a<\u0011\r\u0005\u0005\u00141MA\u0019\u001b\t\tY%\u0003\u0003\u0002f\u0005-#\u0001\u0004,bY&$'\u000b\u0012#UsB,\u0007B\u0002@\u0002 \u0001\u000fq\u0010\u0003\u0004_\u0003?\u0001\u001da\u0018\u0015\u0005\u0003S\n)\u0006\u0003\u0004d\u0003?\u0001\r\u0001\u001a\u0005\u0007Y\u0006}\u0001\u0019\u00013\t\u0013\u0005M\u0014q\u0004I\u0001\u0002\u0004y\u0017aD:fY\u0016\u001cG/\u001a3D_2,XN\\:\t\u0013\u0005]\u0014q\u0004I\u0001\u0002\u0004y\u0017a\u00036pS:\u001cu\u000e\\;n]ND\u0011\"a\u001f\u0001#\u0003%\t!! \u00023M\fg/\u001a+p\u0007\u0006\u001c8/\u00198ee\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0003\u007fR3a\\AAW\t\t\u0019\t\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\u0013Ut7\r[3dW\u0016$'bAAG9\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0015q\u0011\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAK\u0001E\u0005I\u0011AAL\u0003e\u0019\u0018M^3U_\u000e\u000b7o]1oIJ\fG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005e%fA;\u0002\u0002\"I\u0011Q\u0014\u0001\u0012\u0002\u0013\u0005\u0011qT\u0001\u001ag\u00064X\rV8DCN\u001c\u0018M\u001c3sC\u0012\"WMZ1vYR$S\u0007\u0006\u0006\u0002\"\u0006\r\u0016QUAT\u0003SS3aVAA\u0011\u0019\u0019\u00171\u0014a\u0001I\"1A.a'A\u0002\u0011DaA\\AN\u0001\u0004y\u0007B\u0002;\u0002\u001c\u0002\u0007Q\u000fC\u0005\u0002.\u0002\t\n\u0011\"\u0001\u00020\u00069#/\u001a9beRLG/[8o\u0005f\u001c\u0015m]:b]\u0012\u0014\u0018MU3qY&\u001c\u0017\r\n3fM\u0006,H\u000e\u001e\u00134+\t\t\tL\u000b\u0003\u0002\u0016\u0005\u0005\u0005\"CA[\u0001E\u0005I\u0011AA?\u0003\u001d\u0012X\r]1si&$\u0018n\u001c8Cs\u000e\u000b7o]1oIJ\f'+\u001a9mS\u000e\fG\u0005Z3gCVdG\u000f\n\u001b\t\u0013\u0005e\u0006!%A\u0005\u0002\u0005m\u0016a\n:fa\u0006\u0014H/\u001b;j_:\u0014\u0015pQ1tg\u0006tGM]1SKBd\u0017nY1%I\u00164\u0017-\u001e7uIU\"\"\"!)\u0002>\u0006}\u0016\u0011YAb\u0011\u0019\u0019\u0017q\u0017a\u0001I\"1A.a.A\u0002\u0011D\u0001\"a\u0005\u00028\u0002\u0007\u0011Q\u0003\u0005\b\u0003;\t9\f1\u0001p\u0011%\t9\rAI\u0001\n\u0003\tI-\u0001\u0011k_&tw+\u001b;i\u0007\u0006\u001c8/\u00198ee\u0006$\u0016M\u00197fI\u0011,g-Y;mi\u0012\u001aT\u0003BA?\u0003\u0017$q!!\u000e\u0002F\n\u0007\u0011\u0004C\u0005\u0002P\u0002\t\n\u0011\"\u0001\u0002R\u0006\u0001#n\\5o/&$\bnQ1tg\u0006tGM]1UC\ndW\r\n3fM\u0006,H\u000e\u001e\u00135+\u0011\ti(a5\u0005\u000f\u0005U\u0012Q\u001ab\u00013!I\u0011q\u001b\u0001\u0012\u0002\u0013\u0005\u0011\u0011\\\u0001!U>LgnV5uQ\u000e\u000b7o]1oIJ\fG+\u00192mK\u0012\"WMZ1vYR$S'\u0006\u0003\u0002\\\u0006\u0015HCCAQ\u0003;\fy.!9\u0002d\"11-!6A\u0002\u0011Da\u0001\\Ak\u0001\u0004!\u0007bBA:\u0003+\u0004\ra\u001c\u0005\b\u0003o\n)\u000e1\u0001p\t\u001d\t)$!6C\u0002e\u0001")
public class DStreamFunctions<T>
extends WritableToCassandra<T>
implements Serializable,
Logging {
    private final DStream<T> dstream;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    @Override
    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    @Override
    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public Logger log() {
        return Logging$class.log(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    public void warnIfKeepAliveIsShort() {
        Duration streamDuration;
        Duration keepAliveDuration = new Duration((long)this.conf().getInt(CassandraConnectorConf$.MODULE$.KeepAliveMillisParam().name(), BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.KeepAliveMillisParam().default())));
        if (keepAliveDuration.$less(streamDuration = this.dstream.slideDuration())) {
            this.logWarning((Function0<String>)new Serializable(this, keepAliveDuration, streamDuration){
                public static final long serialVersionUID = 0L;
                private final Duration keepAliveDuration$1;
                private final Duration streamDuration$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently ", "  is set to\n        |", ", which is less than ", ". This will cause connections to\n        | be closed and recreated between batches. If this is not what you intended, increase the value\n        | of ", " to a larger value."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CassandraConnectorConf$.MODULE$.KeepAliveMillisParam().name(), this.keepAliveDuration$1, this.streamDuration$1, CassandraConnectorConf$.MODULE$.KeepAliveMillisParam().name()})))).stripMargin();
                }
                {
                    void var3_3;
                    this.keepAliveDuration$1 = keepAliveDuration$1;
                    this.streamDuration$1 = var3_3;
                }
            });
        }
    }

    @Override
    public SparkContext sparkContext() {
        return this.dstream.context().sparkContext();
    }

    public SparkConf conf() {
        return this.sparkContext().getConf();
    }

    @Override
    public void saveToCassandra(String keyspaceName, String tableName, ColumnSelector columnNames2, WriteConf writeConf, CassandraConnector connector, RowWriterFactory<T> rwf) {
        this.warnIfKeepAliveIsShort();
        TableWriter<T> writer = TableWriter$.MODULE$.apply(connector, keyspaceName, tableName, columnNames2, writeConf, rwf);
        this.dstream.foreachRDD((Function1)new Serializable(this, writer){
            public static final long serialVersionUID = 0L;
            public final TableWriter writer$1;

            public final void apply(RDD<T> rdd) {
                rdd.sparkContext().runJob(rdd, (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$saveToCassandra$1 $outer;

                    public final void apply(TaskContext taskContext, Iterator<T> data) {
                        this.$outer.writer$1.write(taskContext, data);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.Unit());
            }
            {
                this.writer$1 = writer$1;
            }
        });
    }

    public ColumnSelector saveToCassandra$default$3() {
        return AllColumns$.MODULE$;
    }

    public WriteConf saveToCassandra$default$4() {
        return WriteConf$.MODULE$.fromSparkConf(this.conf());
    }

    public CassandraConnector saveToCassandra$default$5(String keyspaceName, String tableName, ColumnSelector columnNames2, WriteConf writeConf) {
        return CassandraConnector$.MODULE$.apply(this.conf());
    }

    public DStream<T> repartitionByCassandraReplica(String keyspaceName, String tableName, int partitionsPerHost, ColumnSelector partitionKeyMapper, CassandraConnector connector, ClassTag<T> currentType, RowWriterFactory<T> rwf) {
        ReplicaPartitioner<T> partitioner2 = new ReplicaPartitioner<T>(tableName, keyspaceName, partitionsPerHost, partitionKeyMapper, connector, currentType, rwf);
        return this.dstream.transform((Function1)new Serializable(this, keyspaceName, tableName, currentType, partitioner2){
            public static final long serialVersionUID = 0L;
            private final String keyspaceName$1;
            private final String tableName$1;
            private final ClassTag currentType$1;
            private final ReplicaPartitioner partitioner$1;

            public final CassandraPartitionedRDD<T> apply(RDD<T> rdd) {
                RDD x$4 = rdd.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<T, None$> apply(T x$1) {
                        return new Tuple2(x$1, (Object)None$.MODULE$);
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                ClassTag x$5 = this.currentType$1;
                ClassTag x$6 = ClassTag$.MODULE$.apply(None$.class);
                RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$4);
                Object x$7 = null;
                RDD repart = RDD$.MODULE$.rddToPairRDDFunctions(x$4, x$5, x$6, null).partitionBy((Partitioner)this.partitioner$1).mapPartitions((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Iterator<T> apply(Iterator<Tuple2<T, None$>> x$2) {
                        return x$2.map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final T apply(Tuple2<T, None$> x$3) {
                                return (T)x$3._1();
                            }
                        });
                    }
                }, true, this.currentType$1);
                return new CassandraPartitionedRDD<T>(repart, this.keyspaceName$1, this.tableName$1, this.currentType$1);
            }
            {
                void var5_5;
                void var4_4;
                void var3_3;
                this.keyspaceName$1 = keyspaceName$1;
                this.tableName$1 = var3_3;
                this.currentType$1 = var4_4;
                this.partitioner$1 = var5_5;
            }
        }, currentType);
    }

    public int repartitionByCassandraReplica$default$3() {
        return 10;
    }

    public ColumnSelector repartitionByCassandraReplica$default$4() {
        return PartitionKeyColumns$.MODULE$;
    }

    public CassandraConnector repartitionByCassandraReplica$default$5(String keyspaceName, String tableName, int partitionsPerHost, ColumnSelector partitionKeyMapper) {
        return CassandraConnector$.MODULE$.apply(this.conf());
    }

    public <R> DStream<Tuple2<T, R>> joinWithCassandraTable(String keyspaceName, String tableName, ColumnSelector selectedColumns, ColumnSelector joinColumns, CassandraConnector connector, ClassTag<R> newType, RowReaderFactory<R> rrf, ValidRDDType<R> ev, ClassTag<T> currentType, RowWriterFactory<T> rwf) {
        this.warnIfKeepAliveIsShort();
        RDD rdd = this.dstream.context().sparkContext().emptyRDD(currentType);
        CassandraJoinRDD cjRdd = package$.MODULE$.toRDDFunctions(rdd).joinWithCassandraTable(keyspaceName, tableName, selectedColumns, joinColumns, connector, newType, rrf, ev, currentType, rwf);
        return this.dstream.transform((Function1)new Serializable(this, cjRdd){
            public static final long serialVersionUID = 0L;
            private final CassandraJoinRDD cjRdd$1;

            public final CassandraJoinRDD<T, R> apply(RDD<T> rdd) {
                return this.cjRdd$1.applyToRDD(rdd);
            }
            {
                this.cjRdd$1 = cjRdd$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <R> ColumnSelector joinWithCassandraTable$default$3() {
        return AllColumns$.MODULE$;
    }

    public <R> ColumnSelector joinWithCassandraTable$default$4() {
        return PartitionKeyColumns$.MODULE$;
    }

    public <R> CassandraConnector joinWithCassandraTable$default$5(String keyspaceName, String tableName, ColumnSelector selectedColumns, ColumnSelector joinColumns) {
        return CassandraConnector$.MODULE$.apply(this.sparkContext().getConf());
    }

    public DStreamFunctions(DStream<T> dstream) {
        this.dstream = dstream;
        Logging$class.$init$(this);
    }
}

