/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.hadoop.hive.metastore;

import com.datastax.bdp.hadoop.hive.metastore.CassandraHiveMetaStoreException;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;

public class CassandraClientConfiguration
extends HashMap {
    public static final String META_DB_ROW_KEY = "__meta__";
    public static final String DATABASES_ROW_KEY = "__databases__";
    public static final String DEF_META_STORE_CF = "MetaStore";
    public static final String HIVE_DEF_META_STORE_KEYSPACE = "HiveMetaStore";
    public static final String CONF_PARAM_PREFIX = "cassandra.connection.";
    public static final String CONF_PARAM_KEYSPACE_NAME = "cassandra.connection.metaStoreKeyspaceName";
    public static final String CONF_PARAM_CF_NAME = "cassandra.connection.metaStoreColumnFamilyName";
    public static final String CONF_PARAM_HOST = "cassandra.host";
    public static final String CONF_PARAM_NATIVE_PORT = "cassandra.connection.native.port";
    public static final String CONF_PARAM_SPARK_ENABLE = "spark.enable";
    public static final String AUTO_CREATE_HIVE_SCHEMA = "cassandra.autoCreateHiveSchema";
    public static final String CASSANDRA_PORT = "cassandra.port";
    public static final String CASSANDRA_USERNAME = "cassandra.username";
    public static final String CASSANDRA_PASSWORD = "cassandra.password";
    public static final String INPUT_NATIVE_AUTH_PROVIDER = "cassandra.input.native.auth.provider";
    public static final String INPUT_NATIVE_SSL_TRUST_STORE_PATH = "cassandra.input.native.ssl.trust.store.path";
    public static final String INPUT_NATIVE_SSL_KEY_STORE_PATH = "cassandra.input.native.ssl.key.store.path";
    public static final String INPUT_NATIVE_SSL_TRUST_STORE_PASSWORD = "cassandra.input.native.ssl.trust.store.password";
    public static final String INPUT_NATIVE_SSL_KEY_STORE_PASSWORD = "cassandra.input.native.ssl.key.store.password";
    public static final String INPUT_NATIVE_SSL_CIPHER_SUITES = "cassandra.input.native.ssl.cipher.suites";
    public static final String INPUT_NATIVE_PROTOCOL_VERSION = "cassandra.input.native.protocol.version";
    public static final String DEFAULT_CASSANDRA_NATIVE_PORT = "9042";
    public static String[] cassandraPropertiesList = new String[]{"cassandra.connection.metaStoreKeyspaceName", "cassandra.connection.metaStoreColumnFamilyName", "cassandra.host", "cassandra.connection.native.port", "spark.enable", "cassandra.port", "cassandra.username", "cassandra.password", "cassandra.input.native.auth.provider", "cassandra.input.native.ssl.trust.store.path", "cassandra.input.native.ssl.key.store.path", "cassandra.input.native.ssl.trust.store.password", "cassandra.input.native.ssl.key.store.password", "cassandra.input.native.ssl.cipher.suites", "cassandra.input.native.protocol.version", "cassandra.autoCreateHiveSchema", "spark.enable"};
    private final String keyspaceName;
    private final String columnFamily;
    private final String username;
    private final String password;
    private String host;
    private final int port;
    private final boolean sparkMetastoreEnabled;
    private final boolean autoCreateSchema;
    private Configuration hadoopConfiguration;

    public int getPort() {
        return this.port;
    }

    public boolean isAutoCreateSchema() {
        return this.autoCreateSchema;
    }

    public boolean isSparkMetastoreEnabled() {
        return this.sparkMetastoreEnabled;
    }

    public String getKeyspaceName() {
        return this.keyspaceName;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getHost() {
        return this.host;
    }

    public Configuration getHadoopConfiguration() {
        return this.hadoopConfiguration;
    }

    public CassandraClientConfiguration() {
        this(new Configuration());
    }

    /*
     * WARNING - void declaration
     */
    public CassandraClientConfiguration(Configuration configuration) {
        for (String string : cassandraPropertiesList) {
            String string2 = configuration.get(string);
            if (string2 == null) continue;
            this.put(string, string2);
        }
        this.hadoopConfiguration = configuration;
        this.keyspaceName = configuration.get(CONF_PARAM_KEYSPACE_NAME, HIVE_DEF_META_STORE_KEYSPACE);
        this.columnFamily = configuration.get(CONF_PARAM_CF_NAME, DEF_META_STORE_CF);
        this.username = configuration.get(CASSANDRA_USERNAME);
        this.password = configuration.get(CASSANDRA_PASSWORD);
        this.host = configuration.get(CONF_PARAM_HOST);
        String string = configuration.get(CONF_PARAM_NATIVE_PORT);
        if (string == null) {
            String string3 = DEFAULT_CASSANDRA_NATIVE_PORT;
        }
        try {
            void var2_5;
            this.port = Integer.parseInt((String)var2_5);
        }
        catch (NumberFormatException numberFormatException) {
            throw new CassandraHiveMetaStoreException("cassandra.port must be a number");
        }
        this.sparkMetastoreEnabled = configuration.get(CONF_PARAM_SPARK_ENABLE, "false").equalsIgnoreCase("true");
        this.autoCreateSchema = configuration.getBoolean(AUTO_CREATE_HIVE_SCHEMA, false);
    }
}

