/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.hadoop.hive.metastore;

import com.datastax.bdp.hadoop.hive.metastore.CassandraClientConfiguration;
import com.datastax.bdp.hadoop.hive.metastore.CassandraHiveMetaStoreException;
import com.datastax.bdp.hadoop.hive.metastore.HiveMetaStoreNotFoundException;
import com.datastax.bdp.hadoop.hive.metastore.MetaStorePersister;
import com.datastax.bdp.hadoop.hive.metastore.SchemaManagerService;
import com.datastax.spark.connector.cql.CassandraConnector;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.CurrentNotificationEventId;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.HiveObjectPrivilege;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.InvalidInputException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidPartitionException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.api.NotificationEventRequest;
import org.apache.hadoop.hive.metastore.api.NotificationEventResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionEventType;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.PrivilegeBag;
import org.apache.hadoop.hive.metastore.api.Role;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownPartitionException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.model.MDBPrivilege;
import org.apache.hadoop.hive.metastore.model.MGlobalPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MPartitionPrivilege;
import org.apache.hadoop.hive.metastore.model.MRoleMap;
import org.apache.hadoop.hive.metastore.model.MTableColumnPrivilege;
import org.apache.hadoop.hive.metastore.model.MTablePrivilege;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionExpressionForMetastore;
import org.apache.hive.common.util.HiveVersionInfo;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.thrift.TBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraHiveMetaStore
implements RawStore {
    public static final String DEFAULT_DECIMAL_PARAMS = "(38,18)";
    private static final Logger log = LoggerFactory.getLogger(CassandraHiveMetaStore.class);
    private CassandraClientConfiguration configuration;
    private MetaStorePersister metaStorePersister;
    private SchemaManagerService schemaManagerService;
    private Pattern hive12DecimalPattern = Pattern.compile("\\bdecimal\\s*\\(.*?\\)", 2);
    private Pattern hive13DecimalPattern = Pattern.compile("\\bdecimal(?!\\s*\\()", 2);

    public CassandraHiveMetaStore() {
        log.debug("Creating CassandraHiveMetaStore");
    }

    public void setConf(Configuration configuration) {
        this.configuration = new CassandraClientConfiguration(configuration);
        CassandraConnector cassandraConnector = SchemaManagerService.getCassandraConnector(this.configuration);
        this.metaStorePersister = MetaStorePersister.getInstance(this.configuration, cassandraConnector);
        this.schemaManagerService = SchemaManagerService.getInstance(this.configuration, cassandraConnector);
    }

    public Configuration getConf() {
        return this.configuration.getHadoopConfiguration();
    }

    public SchemaManagerService getSchemaManagerService() {
        return this.schemaManagerService;
    }

    public void createDatabase(Database database) {
        log.debug("createDatabase with {}", (Object)database);
        try {
            this.metaStorePersister.load((TBase)database, database.getName());
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            this.metaStorePersister.save(Database.metaDataMap, (TBase)database, database.getName());
            this.metaStorePersister.save(Database.metaDataMap, (TBase)database, "__databases__");
        }
    }

    public boolean hasDatabase(String string) {
        log.debug("in hasDatabase with database name: {}", (Object)string);
        Database database = new Database();
        database.setName(string);
        try {
            this.metaStorePersister.load((TBase)database, string);
            return true;
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            return false;
        }
    }

    public Database getDatabase(String string) throws NoSuchObjectException {
        log.debug("in getDatabase with database name: {}", (Object)string);
        Database database = new Database();
        database.setName(string);
        try {
            this.metaStorePersister.load((TBase)database, string);
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            if (!this.schemaManagerService.isInternalKeyspace(string) && this.configuration.isAutoCreateSchema() && this.schemaManagerService.createKeyspaceSchemaIfNeeded(string, this)) {
                log.debug("Configured for auto schema creation with keyspace found: {}", (Object)string);
                try {
                    this.metaStorePersister.load((TBase)database, string);
                }
                catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException2) {
                    throw new CassandraHiveMetaStoreException("Could not auto create schema.", hiveMetaStoreNotFoundException2);
                }
            }
            throw new NoSuchObjectException("Database named " + string + " did not exist.");
        }
        return database;
    }

    public List<String> getDatabases(String string) {
        this.schemaManagerService.createKeyspaceSchemasIfNeeded(this);
        log.debug("in getDatabases with databaseNamePattern: {}", (Object)string);
        if ("*".equals(string)) {
            string = "";
        }
        String string2 = string.toLowerCase();
        string2 = string2.replace('.', '_');
        log.debug("finally in getDatabases with databaseNamePattern: {}", (Object)string2);
        List<TBase> list = this.metaStorePersister.find((TBase)new Database(), "__databases__", string2, Integer.MAX_VALUE);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (TBase tBase : list) {
            Database database = (Database)tBase;
            if (!StringUtils.isEmpty((CharSequence)string) && !database.getName().matches(string) && !database.getName().toLowerCase().matches(string)) continue;
            arrayList.add(database.getName());
        }
        return arrayList;
    }

    public boolean alterDatabase(String string, Database database) throws MetaException {
        this.createDatabase(database);
        List<String> list = this.getAllTables(string);
        ArrayList<TBase> arrayList = new ArrayList<TBase>();
        for (String string2 : list) {
            Table table = this.getTable(string, string2);
            try {
                Table table2 = table.deepCopy();
                table2.setDbName(database.getName());
                arrayList.addAll(this.updateTableComponents(string, database, table.getTableName(), table));
                this.createTable(table2);
            }
            catch (Exception exception) {
                throw new MetaException("Problem in database rename");
            }
            arrayList.add((TBase)table);
        }
        this.metaStorePersister.removeAll(arrayList, string);
        return true;
    }

    public boolean dropDatabase(String string) {
        Database database = new Database();
        database.setName(string);
        this.metaStorePersister.remove((TBase)database, string);
        this.metaStorePersister.remove((TBase)database, "__databases__");
        return true;
    }

    public List<String> getAllDatabases() throws MetaException {
        return this.getDatabases("");
    }

    public void createTable(Table table) {
        this.metaStorePersister.save(Table.metaDataMap, (TBase)table, table.getDbName());
    }

    private String getProperty(String string, Table table) {
        String string2 = (String)table.getParameters().get(string);
        if (string2 == null) {
            string2 = (String)table.getSd().getSerdeInfo().getParameters().get(string);
        }
        return string2;
    }

    private String fixDecimalType(String string) {
        if (HiveVersionInfo.getVersion().compareTo("0.13.0") < 0) {
            return this.hive12DecimalPattern.matcher(string).replaceAll("decimal");
        }
        return this.hive13DecimalPattern.matcher(string).replaceAll("decimal(38,18)");
    }

    public boolean hasMapping(String string, String string2) {
        log.debug("check mapping database name: {} and table name: {}", (Object)string, (Object)string2);
        Table table = new Table();
        table.setTableName(string2);
        try {
            return this.metaStorePersister.load((TBase)table, string) != null;
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            log.debug("no mapping for database name: {} and table name: {}", (Object)string, (Object)string2);
            return false;
        }
    }

    public Table getTable(String string, String string2) throws MetaException {
        Table table = this.getTableAllowNullSchema(string, string2);
        if (table == null) {
            return null;
        }
        Map map = table.getParameters();
        if (map != null && map.containsKey("auto_created") && !map.containsKey(HiveExternalCatalog.DATASOURCE_SCHEMA_NUMPARTS())) {
            this.metaStorePersister.remove((TBase)table, string);
            log.info("Found an old auto_created table without schema information. Remaking {}.{}", (Object)string, (Object)string2);
            table = this.getTableAllowNullSchema(string, string2);
        }
        table.setDbName(table.getDbName().toLowerCase());
        table.setTableName(table.getTableName().toLowerCase());
        return table;
    }

    public Table getTableAllowNullSchema(String string, String string2) throws MetaException {
        Object object;
        log.debug("in getTable with database name: {} and table name: {}", (Object)string, (Object)string2);
        Table table = new Table();
        table.setTableName(string2);
        try {
            this.metaStorePersister.load((TBase)table, string);
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            if (this.configuration.isAutoCreateSchema()) {
                this.schemaManagerService.refreshMetadata();
                this.schemaManagerService.createUnmappedTables(string, this);
                try {
                    this.metaStorePersister.load((TBase)table, string);
                }
                catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException2) {
                    log.info("Table not found after auto mapping: " + string + "." + string2, (Throwable)hiveMetaStoreNotFoundException2);
                    return null;
                }
            }
            return null;
        }
        try {
            object = table.getSd();
            if (object != null) {
                String string3;
                if (object.getLocation() != null) {
                    FieldSchema fieldSchema;
                    String string4 = object.getLocation().toLowerCase();
                    if (string4.startsWith("cfs:") || string4.startsWith("dsefs:")) {
                        object.setLocation(this.removedHostLocalFile(this.fixFsHost(object.getLocation())));
                    }
                    if (!(string3 = (fieldSchema = new Path(object.getLocation())).getFileSystem(this.configuration.getHadoopConfiguration())).exists((Path)fieldSchema)) {
                        string3.mkdirs((Path)fieldSchema);
                    }
                }
                for (FieldSchema fieldSchema : object.getCols()) {
                    string3 = fieldSchema.getType();
                    if (!string3.contains("decimal")) continue;
                    fieldSchema.setType(this.fixDecimalType(string3));
                }
            }
        }
        catch (IOException iOException) {
            log.error("Failed to getTable for " + string + "." + string2, (Throwable)iOException);
            throw new MetaException(iOException.getMessage());
        }
        object = table.getParameters();
        if (object != null && object.containsKey("auto_created") && !object.containsKey(HiveExternalCatalog.DATASOURCE_SCHEMA_NUMPARTS())) {
            this.metaStorePersister.remove((TBase)table, string);
            log.info("Found an old auto_created table without schema information. Remaking {}.{}", (Object)string, (Object)string2);
            table = this.getTable(string, string2);
        }
        table.setDbName(table.getDbName().toLowerCase());
        table.setTableName(table.getTableName().toLowerCase());
        return table;
    }

    public List<String> getTables(String string, String string2) throws MetaException {
        if (this.schemaManagerService.getSystemKeyspaces().contains(string)) {
            return new ArrayList<String>();
        }
        log.info("in getTables with dbName: {} and tableNamePattern: {}", (Object)string, (Object)string2);
        this.schemaManagerService.refreshMetadata();
        if (this.configuration.isAutoCreateSchema()) {
            this.schemaManagerService.createUnmappedTables(string, this);
        }
        List<TBase> list = this.metaStorePersister.find((TBase)new Table(), string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (TBase tBase : list) {
            if ("*".equals(string2)) {
                string2 = "";
            }
            Table table = (Table)tBase;
            if (!StringUtils.isEmpty((CharSequence)string2) && !table.getTableName().matches(string2) && !table.getTableName().toLowerCase().matches(string2)) continue;
            log.debug("Adding table: {}", (Object)table);
            if (!this.schemaManagerService.verifyExternalTable(table)) {
                log.warn("Removing deleted external table: {}", (Object)table.getTableName());
                this.dropTable(string, table.getTableName());
                continue;
            }
            arrayList.add(table.getTableName());
        }
        return arrayList;
    }

    public List<String> getAllTables(String string) throws MetaException {
        log.debug("in getAllTables");
        if (this.schemaManagerService.getSystemKeyspaces().contains(string)) {
            return new ArrayList<String>();
        }
        return this.getTables(string, "");
    }

    public List<Table> getTables(String string) throws MetaException {
        if (this.schemaManagerService.getSystemKeyspaces().contains(string)) {
            return new ArrayList<Table>();
        }
        log.info("in getTables with dbName: {}", (Object)string);
        this.schemaManagerService.refreshMetadata();
        if (this.configuration.isAutoCreateSchema()) {
            this.schemaManagerService.createUnmappedTables(string, this);
        }
        List<TBase> list = this.metaStorePersister.find((TBase)new Table(), string);
        ArrayList<Table> arrayList = new ArrayList<Table>(list.size());
        for (TBase tBase : list) {
            Table table = (Table)tBase;
            log.debug("Adding table: {}", (Object)table);
            if (!this.schemaManagerService.verifyExternalTable(table)) {
                log.warn("Removing deleted external table: {}", (Object)table.getTableName());
                this.dropTable(string, table.getTableName());
                continue;
            }
            arrayList.add(table);
        }
        return arrayList;
    }

    public void alterTable(String string, String string2, Table table) throws InvalidObjectException, MetaException {
        if (log.isDebugEnabled()) {
            log.debug("Altering oldTableName {} on datbase: {} new Table: {}", new Object[]{string2, string, table.getTableName()});
        }
        if (string2.equalsIgnoreCase(table.getTableName())) {
            this.createTable(table);
        } else {
            List<TBase> list = this.updateTableComponents(string, null, string2, table);
            Table table2 = new Table();
            table2.setDbName(string);
            table2.setTableName(string2);
            this.metaStorePersister.remove((TBase)table2, string);
            if (list != null && !list.isEmpty()) {
                this.metaStorePersister.removeAll(list, string);
            }
        }
    }

    private List<TBase> updateTableComponents(String string, Database database, String string2, Table table) {
        this.createTable(table);
        ArrayList<TBase> arrayList = new ArrayList<TBase>();
        List<Partition> list = this.getPartitions(string, string2);
        for (Partition object2 : list) {
            arrayList.add((TBase)object2.deepCopy());
            if (database != null) {
                object2.setDbName(database.getName());
            }
            object2.setTableName(table.getTableName());
            this.addPartition(object2);
        }
        List<Index> list2 = this.getIndexes(string, string2);
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            Index index = (Index)iterator.next();
            arrayList.add((TBase)index.deepCopy());
            if (database != null) {
                index.setDbName(database.getName());
            }
            index.setOrigTableName(table.getTableName());
            this.addIndex(index);
        }
        return arrayList;
    }

    public boolean dropTable(String string, String string2) throws MetaException {
        List<Index> list;
        log.debug("in dropTable with databaseName: {} and tableName: {}", (Object)string, (Object)string2);
        Table table = this.getTable(string, string2);
        ArrayList<TBase> arrayList = new ArrayList<TBase>();
        List<Partition> list2 = this.getPartitions(string, string2);
        if (list2 != null && !list2.isEmpty()) {
            arrayList.addAll(list2);
        }
        if ((list = this.getIndexes(string, string2)) != null && !list.isEmpty()) {
            arrayList.addAll(list);
        }
        this.metaStorePersister.remove((TBase)table, string);
        if (!arrayList.isEmpty()) {
            this.metaStorePersister.removeAll(arrayList, string);
        }
        return true;
    }

    public boolean addIndex(Index index) {
        if (index.getParameters() != null) {
            Set set = index.getParameters().entrySet();
            for (Map.Entry entry : set) {
                if (entry.getValue() != null) continue;
                set.remove(entry);
            }
        }
        this.metaStorePersister.save(Index.metaDataMap, (TBase)index, index.getDbName());
        return false;
    }

    public Index getIndex(String string, String string2, String string3) throws MetaException {
        if (log.isDebugEnabled()) {
            log.debug("in getIndex with databaseName: {}, tableName: {} indexName: {}", new Object[]{string, string2, string3});
        }
        Index index = new Index();
        index.setDbName(string);
        index.setIndexName(string3);
        index.setOrigTableName(string2);
        try {
            this.metaStorePersister.load((TBase)index, string);
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            throw new MetaException("Index: " + string3 + " did not exist for table: " + string2 + " in database: " + string);
        }
        return index;
    }

    private List<Index> getIndexes(String string, String string2) {
        return this.getIndexes(string, string2, Integer.MAX_VALUE);
    }

    public List<Index> getIndexes(String string, String string2, int n) {
        List<TBase> list = this.metaStorePersister.find((TBase)new Index(), string, string2, n);
        return list;
    }

    public List<String> listIndexNames(String string, String string2, short s) {
        List<Index> list = this.getIndexes(string, string2, s);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Index index : list) {
            arrayList.add(index.getIndexName());
        }
        return arrayList;
    }

    public void alterIndex(String string, String string2, String string3, Index index) {
        if (log.isDebugEnabled()) {
            log.debug("Altering index {} on database: {} and table: {} Index: {}", new Object[]{string3, string, string2, index});
        }
        if (!index.getIndexName().equalsIgnoreCase(string3)) {
            this.dropIndex(string, string2, string3);
        }
        this.addIndex(index);
    }

    public boolean dropIndex(String string, String string2, String string3) {
        if (log.isDebugEnabled()) {
            log.debug("In dropIndex with databaseName: {} and originalTableName: {} indexName: {}", new Object[]{string, string2, string3});
        }
        Index index = new Index();
        index.setDbName(string);
        index.setOrigTableName(string2);
        index.setIndexName(string3);
        this.metaStorePersister.remove((TBase)index, string);
        return true;
    }

    public boolean addPartition(Partition partition) {
        log.debug("in addPartition with: {}", (Object)partition);
        this.metaStorePersister.save(Partition.metaDataMap, (TBase)partition, partition.getDbName());
        return true;
    }

    public boolean addPartitions(String string, String string2, List<Partition> list) throws MetaException {
        for (Partition partition : list) {
            if (!Objects.equals(partition.getTableName(), string2) || !Objects.equals(partition.getDbName(), string)) {
                throw new MetaException("Partition does not belong to target table " + string + "." + string2 + ": " + partition);
            }
            this.addPartition(partition);
        }
        return true;
    }

    public boolean addPartitions(String string, String string2, PartitionSpecProxy partitionSpecProxy, boolean bl) throws MetaException {
        ArrayList<Partition> arrayList = new ArrayList<Partition>();
        PartitionSpecProxy.PartitionIterator partitionIterator = partitionSpecProxy.getPartitionIterator();
        while (partitionIterator.hasNext()) {
            Partition partition = (Partition)partitionIterator.next();
            if (this.doesPartitionExist(string, string2, partition.getValues())) {
                if (bl) continue;
                throw new MetaException("Partition already exists: " + partition);
            }
            arrayList.add(partition);
        }
        return this.addPartitions(string, string2, arrayList);
    }

    public Partition getPartition(String string, String string2, List<String> list) throws NoSuchObjectException {
        log.debug("in getPartition databaseName: {} tableName: {} partitions: {}", new Object[]{string, string2, list});
        Partition partition = new Partition();
        partition.setDbName(string);
        partition.setTableName(string2);
        partition.setValues(list);
        try {
            this.metaStorePersister.load((TBase)partition, string);
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            throw new NoSuchObjectException("Could not find partition for: " + list + " on table: " + string2 + " in database: " + string);
        }
        return partition;
    }

    public boolean doesPartitionExist(String string, String string2, List<String> list) {
        try {
            return this.getPartition(string, string2, list) != null;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            log.debug("Partitions not found. Exception {}", (Throwable)noSuchObjectException);
            return false;
        }
    }

    private List<Partition> getPartitions(String string, String string2) {
        return this.getPartitions(string, string2, Integer.MAX_VALUE);
    }

    public List<Partition> getPartitions(String string, String string2, int n) {
        log.debug("in getPartitions: databaseName: {} tableName: {} max: {}", new Object[]{string, string2, n});
        List<TBase> list = this.metaStorePersister.find((TBase)new Partition(), string, string2, n);
        log.debug("Found partitions: {}", list);
        return list;
    }

    public List<String> listPartitionNames(String string, String string2, short s) {
        log.debug("in listPartitionNames: databaseName: {} tableName: {} max: {}", new Object[]{string, string2, s});
        List<Partition> list = this.getPartitions(string, string2, s);
        return this.getPartitionNames(list);
    }

    private List<String> getPartitionNames(List<Partition> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (list == null) {
            return arrayList;
        }
        String string = null;
        for (Partition partition : list) {
            String string2 = partition.getSd().getLocation();
            if (string == null) {
                string = partition.getTableName();
            }
            String string3 = string2.split("/" + string + "/")[1];
            arrayList.add(string3);
        }
        return arrayList;
    }

    public void alterPartition(String string, String string2, Partition partition) throws InvalidObjectException {
        if (log.isDebugEnabled()) {
            log.debug("Altering partition for table {} on database: {} Partition: {}", new Object[]{string2, string, partition});
        }
        try {
            this.getPartition(string, string2, partition.getValues());
        }
        catch (NoSuchObjectException noSuchObjectException) {
            throw new InvalidObjectException(noSuchObjectException.getMessage());
        }
        this.addPartition(partition);
    }

    public boolean dropPartition(String string, String string2, List<String> list) {
        Partition partition = new Partition();
        partition.setDbName(string);
        partition.setTableName(string2);
        partition.setValues(list);
        if (log.isDebugEnabled()) {
            log.debug("Dropping partition: {}", (Object)partition);
        }
        this.metaStorePersister.remove((TBase)partition, string);
        return true;
    }

    public void dropPartitions(String string, String string2, List<String> list) throws MetaException {
        for (String string3 : list) {
            this.dropPartition(string, string2, Warehouse.getPartValuesFromPartName((String)string3));
        }
    }

    public boolean addRole(String string, String string2) {
        Role role = new Role();
        role.setOwnerName(string2);
        role.setRoleName(string);
        this.metaStorePersister.save(Role.metaDataMap, (TBase)role, "__meta__");
        return true;
    }

    public Role getRole(String string) throws NoSuchObjectException {
        Role role = new Role();
        role.setRoleName(string);
        try {
            this.metaStorePersister.load((TBase)role, "__meta__");
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            throw new NoSuchObjectException("could not find role: " + string);
        }
        return role;
    }

    public boolean createType(Type type) {
        this.metaStorePersister.save(Type.metaDataMap, (TBase)type, "__meta__");
        return true;
    }

    public Type getType(String string) {
        Type type = new Type();
        type.setName(string);
        try {
            this.metaStorePersister.load((TBase)type, "__meta__");
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            return null;
        }
        return type;
    }

    public boolean dropType(String string) {
        Type type = new Type();
        type.setName(string);
        this.metaStorePersister.remove((TBase)type, "__meta__");
        return true;
    }

    public boolean commitTransaction() {
        return true;
    }

    public PrincipalPrivilegeSet getColumnPrivilegeSet(String string, String string2, String string3, String string4, String string5, List<String> list) throws InvalidObjectException, MetaException {
        return null;
    }

    public PrincipalPrivilegeSet getDBPrivilegeSet(String string, String string2, List<String> list) throws InvalidObjectException, MetaException {
        return null;
    }

    public PrincipalPrivilegeSet getPartitionPrivilegeSet(String string, String string2, String string3, String string4, List<String> list) throws InvalidObjectException, MetaException {
        return null;
    }

    public Partition getPartitionWithAuth(String string, String string2, List<String> list, String string3, List<String> list2) throws MetaException, NoSuchObjectException {
        log.debug("in getPartitionWithAuth: databaseName: {} tableName: {} userName: {} groupNames: {}", new Object[]{string, string2, string3, list2});
        return this.getPartition(string, string2, list);
    }

    public List<Partition> getPartitionsWithAuth(String string, String string2, short s, String string3, List<String> list) {
        log.debug("in getPartitionsWithAuth: databaseName: {} tableName: {} maxParts: {} userName: {}", new Object[]{string, string2, s, string3});
        return this.getPartitions(string, string2, s);
    }

    public List<Partition> getPartitionsByFilter(String string, String string2, String string3, short s) throws MetaException {
        Table table = this.getTable(string, string2);
        List<Partition> list = this.getPartitions(string, string2);
        ArrayList<Partition> arrayList = new ArrayList<Partition>();
        if (list == null) {
            return arrayList;
        }
        if (log.isDebugEnabled()) {
            log.debug("filter: {}", (Object)string3);
        }
        for (Partition partition : list) {
            Map<String, String> map = this.getPartitionName(table, partition);
            boolean bl = this.isValid(map, string3);
            if (log.isDebugEnabled()) {
                log.debug("partition name: {}", map);
                log.debug("partition location: {}", (Object)partition.getSd().getLocation());
                log.debug("partition isValid: " + bl);
            }
            if (!bl) continue;
            arrayList.add(partition);
        }
        return arrayList;
    }

    public boolean getPartitionsByExpr(String string, String string2, byte[] byArray, String string3, short s, List<Partition> list) {
        try {
            PartitionExpressionForMetastore partitionExpressionForMetastore = new PartitionExpressionForMetastore();
            String string4 = partitionExpressionForMetastore.convertExprToFilter(byArray);
            List<Partition> list2 = this.getPartitionsByFilter(string, string2, string4, s);
            list.addAll(list2);
        }
        catch (MetaException metaException) {
            log.error("failed to getPartitionsByExpr", (Throwable)metaException);
        }
        return false;
    }

    private Map<String, String> getPartitionName(Table table, Partition partition) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < table.getPartitionKeysSize(); ++i) {
            String string = ((FieldSchema)table.getPartitionKeys().get(i)).getName();
            String string2 = (String)partition.getValues().get(i);
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    private boolean isValid(Map<String, String> map, String string) {
        assert (string.split("=").length == 2);
        if (map.size() == 0) {
            return false;
        }
        Operator operator = this.getOpr(string);
        String string2 = operator.getValue();
        String[] stringArray = string.replace("(", "").replace(" " + string2 + " '", string2).replace(")", "").replaceAll("'", "").split(string2);
        String string3 = map.get(stringArray[0].trim());
        if (string3 == null) {
            return false;
        }
        return this.compare(string3, stringArray[1].trim().replaceAll("^\"|\"$", ""), operator);
    }

    private Operator getOpr(String string) {
        if (string.contains(Operator.LARGER_THAN_OR_EQUAL.getValue())) {
            return Operator.LARGER_THAN_OR_EQUAL;
        }
        if (string.contains(Operator.LESS_THAN_OR_EQUAL.getValue())) {
            return Operator.LESS_THAN_OR_EQUAL;
        }
        if (string.contains(Operator.EQUAL.getValue())) {
            return Operator.EQUAL;
        }
        if (string.contains(Operator.LESS_THAN.getValue())) {
            return Operator.LESS_THAN;
        }
        if (string.contains(Operator.LARGER_THAN.getValue())) {
            return Operator.LARGER_THAN;
        }
        return null;
    }

    private boolean compare(String string, String string2, Operator operator) {
        switch (operator) {
            case EQUAL: {
                return string.compareTo(string2) == 0;
            }
            case LARGER_THAN: {
                return string.compareTo(string2) > 0;
            }
            case LESS_THAN: {
                return string.compareTo(string2) < 0;
            }
            case LARGER_THAN_OR_EQUAL: {
                return string.compareTo(string2) >= 0;
            }
            case LESS_THAN_OR_EQUAL: {
                return string.compareTo(string2) <= 0;
            }
        }
        return false;
    }

    public PrincipalPrivilegeSet getTablePrivilegeSet(String string, String string2, String string3, List<String> list) throws InvalidObjectException, MetaException {
        return null;
    }

    public PrincipalPrivilegeSet getUserPrivilegeSet(String string, List<String> list) throws InvalidObjectException, MetaException {
        return null;
    }

    public boolean grantPrivileges(PrivilegeBag privilegeBag) throws InvalidObjectException, MetaException, NoSuchObjectException {
        return false;
    }

    public boolean revokePrivileges(PrivilegeBag privilegeBag, boolean bl) throws InvalidObjectException, MetaException, NoSuchObjectException {
        return false;
    }

    public boolean grantRole(Role role, String string, PrincipalType principalType, String string2, PrincipalType principalType2, boolean bl) throws MetaException, NoSuchObjectException, InvalidObjectException {
        return false;
    }

    public boolean revokeRole(Role role, String string, PrincipalType principalType, boolean bl) throws MetaException, NoSuchObjectException {
        return false;
    }

    public List<MTablePrivilege> listAllTableGrants(String string, PrincipalType principalType, String string2, String string3) {
        return null;
    }

    public List<String> listPartitionNamesByFilter(String string, String string2, String string3, short s) throws MetaException {
        log.debug("listPartitionNamesByFilter:" + string3);
        Table table = this.getTable(string, string2);
        List<Partition> list = this.getPartitions(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>(s);
        if (list == null) {
            return arrayList;
        }
        for (Partition partition : list) {
            if (arrayList.size() >= s) break;
            String string4 = partition.getSd().getLocation();
            if (!this.isValid(this.getPartitionName(table, partition), string3)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public List<MDBPrivilege> listPrincipalDBGrants(String string, PrincipalType principalType, String string2) {
        return null;
    }

    public List<MGlobalPrivilege> listPrincipalGlobalGrants(String string, PrincipalType principalType) {
        return null;
    }

    public List<MPartitionColumnPrivilege> listPrincipalPartitionColumnGrants(String string, PrincipalType principalType, String string2, String string3, String string4, String string5) {
        return null;
    }

    public List<MPartitionPrivilege> listPrincipalPartitionGrants(String string, PrincipalType principalType, String string2, String string3, String string4) {
        return null;
    }

    public List<MTableColumnPrivilege> listPrincipalTableColumnGrants(String string, PrincipalType principalType, String string2, String string3, String string4) {
        return null;
    }

    public List<String> listRoleNames() {
        return null;
    }

    public List<MRoleMap> listRoles(String string, PrincipalType principalType) {
        return null;
    }

    public List<MRoleMap> listRoleMembers(String string) {
        return null;
    }

    public boolean openTransaction() {
        return true;
    }

    public boolean removeRole(String string) throws MetaException, NoSuchObjectException {
        return false;
    }

    public boolean revokePrivileges(PrivilegeBag privilegeBag) throws InvalidObjectException, MetaException, NoSuchObjectException {
        return false;
    }

    public boolean revokeRole(Role role, String string, PrincipalType principalType) throws MetaException, NoSuchObjectException {
        return false;
    }

    public void rollbackTransaction() {
    }

    public void shutdown() {
    }

    private List<FieldSchema> convertToFieldSchemas(List<FieldSchema> list) {
        ArrayList<FieldSchema> arrayList = null;
        if (list != null) {
            arrayList = new ArrayList<FieldSchema>(list.size());
            for (FieldSchema fieldSchema : list) {
                arrayList.add(new FieldSchema(fieldSchema.getName(), fieldSchema.getType(), fieldSchema.getComment()));
            }
        }
        return arrayList;
    }

    public void alterPartition(String string, String string2, List<String> list, Partition partition) throws InvalidObjectException, MetaException {
        this.alterPartition(string, string2, partition);
    }

    public long cleanupEvents() {
        return 0L;
    }

    public List<Partition> getPartitionsByNames(String string, String string2, List<String> list) {
        return this.getPartitionsByNames(string, string2, list, Integer.MAX_VALUE);
    }

    public List<Partition> getPartitionsByNames(String string, String string2, List<String> list, int n) {
        List<Partition> list2 = this.getPartitions(string, string2, n);
        ArrayList<Partition> arrayList = new ArrayList<Partition>();
        if (list2 == null) {
            return arrayList;
        }
        list.remove("");
        for (Partition partition : list2) {
            if (!partition.getValues().containsAll(list)) continue;
            arrayList.add(partition);
        }
        return arrayList;
    }

    public List<Table> getTableObjectsByName(String string, List<String> list) throws MetaException {
        ArrayList<Table> arrayList = new ArrayList<Table>();
        for (String string2 : list) {
            arrayList.add(this.getTable(string, string2));
        }
        return arrayList;
    }

    public boolean isPartitionMarkedForEvent(String string, String string2, Map<String, String> map, PartitionEventType partitionEventType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        return false;
    }

    public List<String> listPartitionNamesPs(String string, String string2, List<String> list, short s) {
        List<Partition> list2 = this.getPartitionsByNames(string, string2, list, s);
        return this.getPartitionNames(list2);
    }

    private String getPartNameMatcher(Table table, List<String> list) throws MetaException {
        List list2 = table.getPartitionKeys();
        int n = list2.size();
        if (list.size() > n) {
            throw new MetaException("Incorrect number of partition values. numPartKeys=" + n + ", partSpecs=" + list.size());
        }
        list2 = list2.subList(0, list.size());
        String string = Warehouse.makePartName(list2, list, (String)".*");
        if (list.size() < n) {
            string = string + ".*";
        }
        return string;
    }

    public List<Partition> listPartitionsPsWithAuth(String string, String string2, List<String> list, short s, String string3, List<String> list2) throws MetaException {
        List<Partition> list3 = this.getPartitionsWithAuth(string, string2, s, string3, list2);
        if (list == null || list.size() == 0) {
            return list3;
        }
        short s2 = 0;
        Table table = this.getTable(string, string2);
        String string4 = this.getPartNameMatcher(table, list);
        LinkedList<Partition> linkedList = new LinkedList<Partition>();
        for (Partition partition : list3) {
            String string5 = Warehouse.makePartName((List)table.getPartitionKeys(), (List)partition.getValues());
            if (!string5.matches(string4) || s != -1 && s2 >= s) continue;
            linkedList.add(partition);
        }
        return linkedList;
    }

    public List<String> listTableNamesByFilter(String string, String string2, short s) throws MetaException {
        List<String> list = this.getAllTables(string);
        ArrayList<String> arrayList = new ArrayList<String>(s);
        for (String string3 : list) {
            if (arrayList.size() >= s) break;
            if (!string3.contains(string2)) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    public Table markPartitionForEvent(String string, String string2, Map<String, String> map, PartitionEventType partitionEventType) throws MetaException, UnknownTableException, InvalidPartitionException, UnknownPartitionException {
        return null;
    }

    private String fixFsHost(String string) {
        URI uRI = new Path(string).toUri();
        URI uRI2 = FileSystem.getDefaultUri((Configuration)this.configuration.getHadoopConfiguration());
        try {
            return new URI(uRI.getScheme(), uRI2.getAuthority(), uRI.getPath(), uRI.getQuery(), uRI.getFragment()).toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
    }

    private String removedHostLocalFile(String string) {
        if (string.startsWith("file://")) {
            String string2 = string.substring("file://".length(), string.length());
            int n = string2.indexOf("/");
            return "file:///" + string2.substring(n + 1, string2.length());
        }
        return string;
    }

    public void alterPartitions(String string, String string2, List<List<String>> list, List<Partition> list2) throws InvalidObjectException, MetaException {
    }

    public boolean updateTableColumnStatistics(ColumnStatistics columnStatistics) {
        return true;
    }

    public boolean updatePartitionColumnStatistics(ColumnStatistics columnStatistics, List<String> list) {
        return true;
    }

    public ColumnStatistics getTableColumnStatistics(String string, String string2, List<String> list) {
        return null;
    }

    public List<ColumnStatistics> getPartitionColumnStatistics(String string, String string2, List<String> list, List<String> list2) {
        return null;
    }

    public ColumnStatistics getTableColumnStatistics(String string, String string2, String string3) throws MetaException, NoSuchObjectException, InvalidInputException, InvalidObjectException {
        return null;
    }

    public ColumnStatistics getPartitionColumnStatistics(String string, String string2, String string3, List<String> list, String string4) throws MetaException, NoSuchObjectException, InvalidInputException, InvalidObjectException {
        return null;
    }

    public boolean deletePartitionColumnStatistics(String string, String string2, String string3, List<String> list, String string4) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        return true;
    }

    public boolean deleteTableColumnStatistics(String string, String string2, String string3) throws NoSuchObjectException, MetaException, InvalidObjectException, InvalidInputException {
        return true;
    }

    public boolean addToken(String string, String string2) {
        throw new UnsupportedOperationException("CassandraHiveMetaStore does not implement persistent storage of authentication tokens");
    }

    public boolean removeToken(String string) {
        throw new UnsupportedOperationException("CassandraHiveMetaStore does not implement persistent storage of authentication tokens");
    }

    public String getToken(String string) {
        throw new UnsupportedOperationException("CassandraHiveMetaStore does not implement persistent storage of authentication tokens");
    }

    public List<String> getAllTokenIdentifiers() {
        throw new UnsupportedOperationException("CassandraHiveMetaStore does not implement persistent storage of authentication tokens");
    }

    public int addMasterKey(String string) throws MetaException {
        throw new UnsupportedOperationException("CassandraHiveMetaStore does not implement persistent storage of authentication tokens");
    }

    public void updateMasterKey(Integer n, String string) throws NoSuchObjectException, MetaException {
        throw new UnsupportedOperationException("CassandraHiveMetaStore does not implement persistent storage of authentication tokens");
    }

    public boolean removeMasterKey(Integer n) {
        throw new UnsupportedOperationException("CassandraHiveMetaStore does not implement persistent storage of authentication tokens");
    }

    public String[] getMasterKeys() {
        throw new UnsupportedOperationException("CassandraHiveMetaStore does not implement persistent storage of authentication tokens");
    }

    public void verifySchema() throws MetaException {
    }

    public String getMetaStoreSchemaVersion() throws MetaException {
        return null;
    }

    public void setMetaStoreSchemaVersion(String string, String string2) throws MetaException {
    }

    public List<HiveObjectPrivilege> listPrincipalDBGrantsAll(String string, PrincipalType principalType) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listPrincipalTableGrantsAll(String string, PrincipalType principalType) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listPrincipalPartitionGrantsAll(String string, PrincipalType principalType) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listPrincipalTableColumnGrantsAll(String string, PrincipalType principalType) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listPrincipalPartitionColumnGrantsAll(String string, PrincipalType principalType) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listGlobalGrantsAll() {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listDBGrantsAll(String string) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listPartitionColumnGrantsAll(String string, String string2, String string3, String string4) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listTableGrantsAll(String string, String string2) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listPartitionGrantsAll(String string, String string2, String string3) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public List<HiveObjectPrivilege> listTableColumnGrantsAll(String string, String string2, String string3) {
        return new ArrayList<HiveObjectPrivilege>();
    }

    public void createFunction(Function function) {
        log.debug("createFunction with {}", (Object)function);
        this.metaStorePersister.save(Function.metaDataMap, (TBase)function, function.getDbName());
    }

    public void alterFunction(String string, String string2, Function function) {
        log.debug("Altering funcName {} on datbase: {} new Function: {}", new Object[]{string2, string, function.getFunctionName()});
        if (!string2.equals(function.getFunctionName())) {
            this.dropFunction(string, string2);
        }
        this.createFunction(function);
    }

    public void dropFunction(String string, String string2) {
        Function function = this.getFunction(string, string2);
        this.metaStorePersister.remove((TBase)function, string);
    }

    public Function getFunction(String string, String string2) {
        Function function = new Function();
        function.setDbName(string);
        function.setFunctionName(string2);
        try {
            this.metaStorePersister.load((TBase)function, string);
            return function;
        }
        catch (HiveMetaStoreNotFoundException hiveMetaStoreNotFoundException) {
            return null;
        }
    }

    public List<String> getFunctions(String string, String string2) {
        if (this.schemaManagerService.getSystemKeyspaces().contains(string)) {
            return new ArrayList<String>();
        }
        log.info("in getFunctions with dbName: {} and functionNamePattern: {}", (Object)string, (Object)string2);
        List<TBase> list = this.metaStorePersister.find((TBase)new Function(), string);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (TBase tBase : list) {
            if ("*".equals(string2)) {
                string2 = "";
            }
            Function function = (Function)tBase;
            if (!StringUtils.isEmpty((CharSequence)string2) && !function.getFunctionName().matches(string2)) continue;
            log.debug("Adding function: {}", (Object)function);
            arrayList.add(function.getFunctionName());
        }
        return arrayList;
    }

    public AggrStats get_aggr_stats_for(String string, String string2, List<String> list, List<String> list2) throws MetaException, NoSuchObjectException {
        return null;
    }

    public NotificationEventResponse getNextNotification(NotificationEventRequest notificationEventRequest) {
        return null;
    }

    public void addNotificationEvent(NotificationEvent notificationEvent) {
    }

    public void cleanNotificationEvents(int n) {
    }

    public CurrentNotificationEventId getCurrentNotificationEventId() {
        return null;
    }

    private static enum Operator {
        LARGER_THAN(">"),
        LESS_THAN("<"),
        LESS_THAN_OR_EQUAL("<="),
        LARGER_THAN_OR_EQUAL(">="),
        EQUAL("=");

        private final String value;

        private Operator(String string2) {
            this.value = string2;
        }

        String getValue() {
            return this.value;
        }
    }
}

