/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.hadoop.hive.metastore;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.Version;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreVersionUtil {
    private static final Logger logger = LoggerFactory.getLogger(HiveMetaStoreVersionUtil.class);
    public static final TreeMap<Version, Integer> hiveMetaStoreVerions = new TreeMap<Version, Integer>(){
        {
            this.put(Version.parse((String)"4.5.5"), 1);
            this.put(Version.parse((String)"5.1.0"), 2);
        }
    };
    public static final Integer nonHiveMetastoreVersion = -1;

    public static int getHiveMetastoreVersion(String string) {
        if ("4.6.0".equals(string)) {
            return nonHiveMetastoreVersion;
        }
        try {
            Version version = Version.parse((String)string);
            Map.Entry<Version, Integer> entry = hiveMetaStoreVerions.floorEntry(version);
            return entry == null ? nonHiveMetastoreVersion.intValue() : entry.getValue().intValue();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error("Wrong dse version : " + string, (Throwable)illegalArgumentException);
            return nonHiveMetastoreVersion;
        }
    }

    public static Version getDSEVersion(CqlSession cqlSession) {
        return cqlSession.getMetadata().getNodes().values().stream().map(node -> (Version)node.getExtras().get("DSE_VERSION")).map(version -> version == null ? Version.V6_8_0 : version).min(Version::compareTo).orElseThrow(() -> new RuntimeException("No host to get the current DSE version"));
    }
}

