/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.hadoop.hive.metastore;

import com.datastax.bdp.hadoop.hive.metastore.CassandraHiveMetaStore;
import com.datastax.bdp.hadoop.hive.metastore.HiveMetaStoreVersionUtil;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import io.netty.util.internal.StringUtil;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetastoreMigrateTool {
    private static Logger logger = LoggerFactory.getLogger(HiveMetastoreMigrateTool.class);
    private static final String insertQuery_template = "INSERT INTO \"%s\" (key, entity, value) VALUES( ?, ?, ?) IF NOT EXISTS";
    private static final String selectQuery_template = "SELECT key, entity, value FROM \"%s\"";
    private static final int EXIT_SUCCESS = 0;
    private static final int EXIT_FAILURE = 1;

    public void migrate(String string, String string2, CqlSession cqlSession, PrintStream printStream, Configuration configuration) throws MetaException, InvalidObjectException {
        String[] stringArray;
        String string3 = HiveMetaStoreVersionUtil.getDSEVersion(cqlSession).toString();
        if (StringUtil.isNullOrEmpty((String)string2)) {
            string2 = string3;
        }
        if ((stringArray = string2.split("\\.")).length == 3) {
            int n;
            int n2 = this.versionValue(stringArray);
            if (n2 < 452) {
                printStream.println("Don't need upgrade metastore to release earlier than 4.5.2");
                System.exit(0);
            }
            if ((n = this.versionValue(stringArray = string3.split("\\."))) < n2) {
                printStream.println("You can't upgrade metastore to release after current release: " + string3);
                System.exit(1);
            }
            if (string != null) {
                stringArray = string.split("\\.");
                if (stringArray.length != 3) {
                    printStream.println("Wrong from version number: " + string);
                    System.exit(1);
                } else if (this.versionValue(stringArray) < 452) {
                    string = null;
                } else if (this.versionValue(stringArray) >= n2) {
                    printStream.println(String.format("from version %s should be before version %s", string, string2));
                    System.exit(1);
                }
            } else {
                printStream.println("Missing --from input");
            }
        } else {
            printStream.println("Wrong to version number: " + string2);
            System.exit(1);
        }
        if (HiveMetaStoreVersionUtil.getHiveMetastoreVersion(string2) == 2) {
            CassandraHiveMetaStore cassandraHiveMetaStore = new CassandraHiveMetaStore();
            cassandraHiveMetaStore.setConf(configuration);
            for (String object2 : cassandraHiveMetaStore.getAllDatabases()) {
                cassandraHiveMetaStore.getAllTables(object2);
            }
        }
        String string4 = configuration.get("cassandra.connection.metaStoreColumnFamilyName", "MetaStore");
        String string5 = configuration.get("cassandra.connection.metaStoreKeyspaceName", "HiveMetaStore");
        cqlSession.execute("USE \"" + string5 + "\"");
        this.migrate(string, string2, cqlSession, string4);
        CassandraHiveMetaStore cassandraHiveMetaStore = new CassandraHiveMetaStore();
        cassandraHiveMetaStore.setConf(configuration);
        for (String string6 : cassandraHiveMetaStore.getAllDatabases()) {
            for (Table table : cassandraHiveMetaStore.getTables(string6)) {
                cassandraHiveMetaStore.alterTable(string6, table.getTableName(), HiveMetastoreMigrateTool.updateTable(table));
            }
        }
        printStream.println("Upgrading is done");
        System.exit(0);
    }

    private void migrate(String string, String string2, CqlSession cqlSession, String string3) {
        String string4;
        int n = HiveMetaStoreVersionUtil.nonHiveMetastoreVersion;
        String string5 = string == null ? "" : ((n = HiveMetaStoreVersionUtil.getHiveMetastoreVersion(string)) == HiveMetaStoreVersionUtil.nonHiveMetastoreVersion ? String.format("_%s_", string) : String.format("_%s_", n));
        int n2 = HiveMetaStoreVersionUtil.getHiveMetastoreVersion(string2);
        if (n2 == HiveMetaStoreVersionUtil.nonHiveMetastoreVersion) {
            string4 = String.format("_%s_", string2);
        } else {
            if (n == n2) {
                return;
            }
            string4 = String.format("_%s_", n2);
        }
        PreparedStatement preparedStatement = cqlSession.prepare(String.format(insertQuery_template, string3));
        ResultSet resultSet = cqlSession.execute(String.format(selectQuery_template, string3));
        for (Row row : resultSet) {
            String string6 = row.getString("key");
            String string7 = row.getString("entity");
            ByteBuffer byteBuffer = row.getByteBuffer("value");
            if (!this.startWith(string6, string5)) continue;
            this.insert(cqlSession, preparedStatement, this.replace(string6, string5, string4), string7, byteBuffer);
        }
    }

    private boolean startWith(String string, String string2) {
        if ("".equals(string2)) {
            return !string.startsWith("_") || "__databases__".equals(string) || "__meta__".equals(string);
        }
        return string.startsWith(string2);
    }

    private String replace(String string, String string2, String string3) {
        if (!"".equals(string2)) {
            return string.replaceFirst(string2, string3);
        }
        return string3 + string;
    }

    private void insert(CqlSession cqlSession, PreparedStatement preparedStatement, String string, String string2, ByteBuffer byteBuffer) {
        logger.info(String.format("Insert key: %s, entity: %s with CAS", string, string2));
        cqlSession.execute((Statement)preparedStatement.bind(new Object[]{string, string2, byteBuffer}));
    }

    private int versionValue(String[] stringArray) {
        assert (stringArray.length == 3);
        return Integer.valueOf(stringArray[0]) * 100 + Integer.valueOf(stringArray[1]) * 10 + Integer.valueOf(stringArray[2]);
    }

    private static Table updateTable(Table table) {
        String string = table.getSd().getLocation();
        if (string != null && string.indexOf("cfs://") == 0) {
            String string2 = string.replace("cfs://", "dsefs://");
            table.getSd().setLocation(string2);
        }
        return table;
    }
}

