/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.hadoop.hive.metastore;

import com.datastax.bdp.hadoop.hive.metastore.CassandraClientConfiguration;
import com.datastax.bdp.hadoop.hive.metastore.CassandraHiveMetaStore;
import com.datastax.bdp.hadoop.hive.metastore.CassandraHiveMetaStoreException;
import com.datastax.bdp.hadoop.hive.metastore.CatalogTableMetadata;
import com.datastax.bdp.hadoop.hive.metastore.GraphEdgeTableMetadata;
import com.datastax.bdp.hadoop.hive.metastore.GraphVertexTableMetadata;
import com.datastax.bdp.hadoop.hive.metastore.TableOrViewMetadata;
import com.datastax.dse.driver.api.core.graph.GraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.servererrors.InvalidQueryException;
import com.datastax.oss.driver.api.core.servererrors.SyntaxError;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hive.HiveExternalCatalog;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManagerService {
    private static final Logger log = LoggerFactory.getLogger(SchemaManagerService.class);
    private CassandraClientConfiguration configuration;
    private String wareHouseRoot;
    private CassandraConnector connector;
    private Metadata metadata;
    private Set<String> systemKeyspaces = Sets.newHashSet();
    private Optional<Set<String>> graphNames = Optional.empty();
    public static final String DSE_GRAPH_DATABASE_NAME = "dse_graph";
    private static WeakHashMap<CassandraClientConfiguration, SchemaManagerService> SchemaManagerServiceCache = new WeakHashMap();
    private Pattern graphTablePattern = Pattern.compile("(.*)(_edges|_vertices)");

    public void setActiveSession(SparkSession sparkSession) {
        assert (sparkSession != null);
        SparkSession.setActiveSession((SparkSession)sparkSession);
    }

    public static synchronized SchemaManagerService getInstance(CassandraClientConfiguration cassandraClientConfiguration, CassandraConnector cassandraConnector) {
        SchemaManagerService schemaManagerService = SchemaManagerServiceCache.get(cassandraClientConfiguration);
        if (schemaManagerService == null) {
            schemaManagerService = new SchemaManagerService(cassandraClientConfiguration, cassandraConnector);
            SchemaManagerServiceCache.put(cassandraClientConfiguration, schemaManagerService);
        } else {
            schemaManagerService.configuration = cassandraClientConfiguration;
        }
        return schemaManagerService;
    }

    private SchemaManagerService(CassandraClientConfiguration cassandraClientConfiguration, CassandraConnector cassandraConnector) {
        this.configuration = cassandraClientConfiguration;
        this.wareHouseRoot = HiveConf.getVar((Configuration)this.configuration.getHadoopConfiguration(), (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREWAREHOUSE);
        this.connector = cassandraConnector;
    }

    public Set<String> getSystemKeyspaces() {
        return this.systemKeyspaces;
    }

    public static CassandraConnector getCassandraConnector(CassandraClientConfiguration cassandraClientConfiguration) {
        SparkConf sparkConf = new SparkConf(true);
        cassandraClientConfiguration.getHadoopConfiguration().iterator().forEachRemaining(entry -> {
            if (((String)entry.getKey()).startsWith("spark.")) {
                sparkConf.set((String)entry.getKey(), (String)entry.getValue());
            } else {
                sparkConf.set("spark.hadoop." + (String)entry.getKey(), (String)entry.getValue());
            }
        });
        return new CassandraConnector(CassandraConnectorConf.fromSparkConf(sparkConf));
    }

    public void refreshMetadata() {
        log.info("Refresh cluster meta data");
        this.connector.jWithSessionDo(cqlSession -> {
            try {
                this.metadata = cqlSession.refreshSchema();
                this.systemKeyspaces = Sets.newHashSet();
                GraphResultSet graphResultSet = cqlSession.execute((GraphStatement)ScriptGraphStatement.builder((String)"system.graphs()").build());
                this.graphNames = Optional.of(StreamSupport.stream(graphResultSet.spliterator(), false).map(graphNode -> graphNode.asString()).collect(Collectors.toSet()));
            }
            catch (AllNodesFailedException | InvalidQueryException | SyntaxError | ClassCastException | IllegalArgumentException throwable) {
                this.graphNames = Optional.empty();
            }
            return this.graphNames;
        });
    }

    public boolean isGraphEnabled() {
        return this.graphNames.isPresent();
    }

    private Metadata getClusterMetadata() {
        return this.metadata;
    }

    public List<String> findUnmappedKeyspaces(CassandraHiveMetaStore cassandraHiveMetaStore) {
        this.refreshMetadata();
        HashSet<String> hashSet = new HashSet<String>();
        for (KeyspaceMetadata keyspaceMetadata : this.getClusterMetadata().getKeyspaces().values()) {
            String string = keyspaceMetadata.getName().asInternal();
            log.debug("Found ksDef name: {}", (Object)string);
            if (this.isInternalKeyspace(string) || this.isLegacyGraphKs(string) || this.isKeyspaceMapped(string, cassandraHiveMetaStore)) continue;
            log.debug("Adding ks name from unmapped List: {}", (Object)string);
            hashSet.add(string);
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(hashSet);
        return arrayList;
    }

    private boolean isLegacyGraphKs(String string) {
        return string.endsWith("_pvt") || string.endsWith("_system") || this.metadata.getKeyspace(string + "_system").isPresent();
    }

    public String getKeyspaceForDatabaseName(String string) {
        for (KeyspaceMetadata keyspaceMetadata : this.getClusterMetadata().getKeyspaces().values()) {
            String string2 = keyspaceMetadata.getName().asInternal();
            if (!StringUtils.equalsIgnoreCase((CharSequence)string2, (CharSequence)string)) continue;
            return string2;
        }
        return null;
    }

    public boolean isKeyspaceMapped(String string, CassandraHiveMetaStore cassandraHiveMetaStore) {
        return cassandraHiveMetaStore.hasDatabase(string);
    }

    public void createKeyspaceSchema(String string, CassandraHiveMetaStore cassandraHiveMetaStore) {
        if (this.isInternalKeyspace(string)) {
            return;
        }
        cassandraHiveMetaStore.createDatabase(this.buildDatabase(string));
    }

    public boolean createKeyspaceSchemaIfNeeded(String string, CassandraHiveMetaStore cassandraHiveMetaStore) {
        this.refreshMetadata();
        log.info("adding dse_graph keyspace if needed");
        if (this.isGraphEnabled() && string.equals(DSE_GRAPH_DATABASE_NAME)) {
            if (!this.isKeyspaceMapped(string, cassandraHiveMetaStore)) {
                this.createKeyspaceSchema(DSE_GRAPH_DATABASE_NAME, cassandraHiveMetaStore);
                return true;
            }
            return false;
        }
        String string2 = this.getKeyspaceForDatabaseName(string);
        if (string2 != null) {
            log.debug("Cassandra keyspace {} exists, but is not present in the metastore. Automatically creating metastore schema now.", (Object)string);
            this.createKeyspaceSchema(string2, cassandraHiveMetaStore);
            return true;
        }
        log.debug("No Cassandra Keyspace found with the name {}. Unable to build metastore schema for non-existent keyspace", (Object)string);
        return false;
    }

    public void createKeyspaceSchemasIfNeeded(CassandraHiveMetaStore cassandraHiveMetaStore) {
        if (this.configuration.isAutoCreateSchema()) {
            try {
                log.info("Updating Cassandra Keyspace to Metastore Database Mapping");
                List<String> list = this.findUnmappedKeyspaces(cassandraHiveMetaStore);
                for (String string : list) {
                    this.createKeyspaceSchema(string, cassandraHiveMetaStore);
                }
                log.info("adding dse_graph keyspace if needed");
                if (this.isGraphEnabled() && !this.isKeyspaceMapped(DSE_GRAPH_DATABASE_NAME, cassandraHiveMetaStore)) {
                    this.createKeyspaceSchema(DSE_GRAPH_DATABASE_NAME, cassandraHiveMetaStore);
                }
            }
            catch (Exception exception) {
                throw new CassandraHiveMetaStoreException("Problem finding unmapped keyspaces", exception);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createUnmappedTables(String string, CassandraHiveMetaStore cassandraHiveMetaStore) {
        if (string.equals(DSE_GRAPH_DATABASE_NAME)) {
            this.createUnmappedGraphTables(cassandraHiveMetaStore);
            return;
        }
        String string2 = this.getKeyspaceForDatabaseName(string);
        log.info("Create mapping in hive db: {}, for unmapped tables from keyspace: {}", (Object)string, (Object)string2);
        if (string2 == null || this.isInternalKeyspace(string2)) {
            return;
        }
        try {
            for (CatalogTableMetadata catalogTableMetadata : this.getTableOrViewMetadatas(string2)) {
                try {
                    if (cassandraHiveMetaStore.hasMapping(string2, catalogTableMetadata.getTableName())) continue;
                    this.createTableMapping(catalogTableMetadata, cassandraHiveMetaStore);
                }
                catch (InvalidObjectException invalidObjectException) {
                    throw new CassandraHiveMetaStoreException("Could not create table for CF: " + catalogTableMetadata.getTableName(), invalidObjectException);
                }
                catch (MetaException metaException) {
                    throw new CassandraHiveMetaStoreException("Problem persisting table for CF: " + catalogTableMetadata.getTableName(), metaException);
                    return;
                }
            }
        }
        catch (Exception exception) {
            throw new CassandraHiveMetaStoreException("There was a problem retrieving column families for keyspace " + string2, exception);
        }
    }

    private void createUnmappedGraphTables(CassandraHiveMetaStore cassandraHiveMetaStore) {
        for (String string : this.graphNames.get()) {
            try {
                if (!cassandraHiveMetaStore.hasMapping(DSE_GRAPH_DATABASE_NAME, string + "_vertices")) {
                    this.createTableMapping(new GraphVertexTableMetadata(string), cassandraHiveMetaStore);
                }
                if (cassandraHiveMetaStore.hasMapping(DSE_GRAPH_DATABASE_NAME, string + "_edges")) continue;
                this.createTableMapping(new GraphEdgeTableMetadata(string), cassandraHiveMetaStore);
            }
            catch (InvalidObjectException invalidObjectException) {
                throw new CassandraHiveMetaStoreException("Could not create table for Graph: " + this.graphNames, invalidObjectException);
            }
            catch (MetaException metaException) {
                throw new CassandraHiveMetaStoreException("Problem persisting metadata for Graph: " + this.graphNames, metaException);
            }
        }
    }

    public boolean verifyExternalTable(Table table) throws CassandraHiveMetaStoreException {
        if (table.getTableType() == null || !table.getTableType().equals(TableType.EXTERNAL_TABLE.toString())) {
            return true;
        }
        boolean bl = false;
        Map map = table.getParameters();
        if (!map.containsKey("auto_created")) {
            return true;
        }
        Map map2 = table.getSd().getSerdeInfo().getParameters();
        String string = (String)map2.get("keyspace");
        String string2 = (String)map2.get("table");
        try {
            for (CatalogTableMetadata catalogTableMetadata : this.getTableOrViewMetadatas(string)) {
                if (!StringUtils.equalsIgnoreCase((CharSequence)catalogTableMetadata.getTableName(), (CharSequence)string2)) continue;
                bl = true;
                break;
            }
        }
        catch (Exception exception) {
            throw new CassandraHiveMetaStoreException("There was a problem verifying an externally mapped table", exception);
        }
        return bl || this.verifyGraphExternalTable(table);
    }

    private boolean verifyGraphExternalTable(Table table) {
        if (!this.isGraphEnabled() || !table.getDbName().equals(DSE_GRAPH_DATABASE_NAME)) {
            return false;
        }
        Matcher matcher = this.graphTablePattern.matcher(table.getTableName());
        return matcher.matches() && this.graphNames.get().contains(matcher.group(1));
    }

    private Database buildDatabase(String string) {
        Database database = new Database();
        database.setLocationUri(new Path(this.wareHouseRoot, string.toLowerCase() + ".db").toString());
        database.setName(string);
        return database;
    }

    private Table createTableMapping(CatalogTableMetadata catalogTableMetadata, CassandraHiveMetaStore cassandraHiveMetaStore) throws InvalidObjectException, MetaException {
        Table table = this.buildSparkSourceTable(catalogTableMetadata);
        if (table != null) {
            cassandraHiveMetaStore.createTable(table);
        }
        return table;
    }

    public Table buildSparkSourceTable(CatalogTableMetadata catalogTableMetadata) {
        String string5;
        Table table = new Table();
        String string2 = catalogTableMetadata.getDbName();
        String string3 = catalogTableMetadata.getTableName();
        SparkSession sparkSession = (SparkSession)SparkSession.getActiveSession().get();
        StructType structType = sparkSession.read().format(catalogTableMetadata.getSourceProvider()).options(catalogTableMetadata.getSerDeInfo().getParameters()).load().schema();
        int n = 4000;
        String string4 = structType.json();
        Iterable iterable = Splitter.fixedLength((int)n).split((CharSequence)string4);
        table.putToParameters(HiveExternalCatalog.DATASOURCE_SCHEMA_NUMPARTS(), Integer.toString(Iterables.size((Iterable)iterable)));
        int n2 = 0;
        for (String string5 : iterable) {
            table.putToParameters(HiveExternalCatalog.DATASOURCE_SCHEMA_PART_PREFIX() + n2, string5);
            ++n2;
        }
        log.info("Creating external Spark table mapping for {}.{} C* table", (Object)string2, (Object)string3);
        table.setDbName(string2);
        table.setTableName(string3);
        table.setTableType(TableType.EXTERNAL_TABLE.toString());
        table.putToParameters("EXTERNAL", "TRUE");
        table.putToParameters("auto_created", "true");
        table.putToParameters("spark.sql.sources.provider", catalogTableMetadata.getSourceProvider());
        table.setPartitionKeys(Collections.emptyList());
        table.setCreateTime((int)(System.currentTimeMillis() / 1000L));
        try {
            table.setOwner(UserGroupInformation.getCurrentUser().getShortUserName());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        table.setPrivileges(new PrincipalPrivilegeSet());
        StorageDescriptor storageDescriptor = new StorageDescriptor();
        storageDescriptor.setParameters(new HashMap());
        storageDescriptor.addToCols(new FieldSchema("Fake", "string", "Fake column for source table"));
        log.debug("create source table options");
        string5 = catalogTableMetadata.getSerDeInfo();
        storageDescriptor.setSerdeInfo((SerDeInfo)string5);
        storageDescriptor.setBucketCols(Collections.emptyList());
        storageDescriptor.setSortCols(Collections.emptyList());
        table.setSd(storageDescriptor);
        if (log.isDebugEnabled()) {
            log.debug("constructed table for CF:{} {}", (Object)string3, (Object)table.toString());
        }
        return table;
    }

    public Collection<CatalogTableMetadata> getTableOrViewMetadatas(String string) {
        if (!this.isInternalKeyspace(string)) {
            return this.getTableOrViewMetadatas((KeyspaceMetadata)this.getClusterMetadata().getKeyspace(CqlIdentifier.fromInternal((String)string)).orElse(null));
        }
        return Collections.EMPTY_LIST;
    }

    public Collection<CatalogTableMetadata> getAllTableOrViewMetadatas() {
        LinkedList<CatalogTableMetadata> linkedList = new LinkedList<CatalogTableMetadata>();
        for (KeyspaceMetadata keyspaceMetadata : this.getClusterMetadata().getKeyspaces().values()) {
            if (this.isInternalKeyspace(keyspaceMetadata.getName().asInternal())) continue;
            linkedList.addAll(this.getTableOrViewMetadatas(keyspaceMetadata));
        }
        return linkedList;
    }

    private Collection<CatalogTableMetadata> getTableOrViewMetadatas(KeyspaceMetadata keyspaceMetadata) {
        Object object22;
        LinkedList<CatalogTableMetadata> linkedList = new LinkedList<CatalogTableMetadata>();
        List<Object> list = keyspaceMetadata == null ? Collections.emptyList() : keyspaceMetadata.getTables().values();
        for (Object object22 : list) {
            linkedList.add(new TableOrViewMetadata((TableMetadata)object22));
        }
        Collection<Object> collection = keyspaceMetadata == null ? Collections.emptyList() : keyspaceMetadata.getViews().values();
        object22 = collection.iterator();
        while (object22.hasNext()) {
            ViewMetadata viewMetadata = (ViewMetadata)object22.next();
            linkedList.add(new TableOrViewMetadata(viewMetadata));
        }
        return linkedList;
    }

    public boolean isInternalKeyspace(String string) {
        return this.getSystemKeyspaces().contains(string);
    }

    public static SimpleStatement getMetaStoreTableSchema(String string, String string2) {
        return SchemaBuilder.createTable((String)string, (String)string2).withPartitionKey("key", DataTypes.TEXT).withClusteringColumn("entity", DataTypes.TEXT).withColumn("value", DataTypes.BLOB).build();
    }
}

