/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.TimeUUIDType$;
import com.datastax.spark.connector.util.Logging;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.sources.Filter;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;

public final class TimeUUIDPredicateRules$
implements CassandraPredicateRules,
Logging {
    public static final TimeUUIDPredicateRules$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new TimeUUIDPredicateRules$();
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public boolean org$apache$spark$sql$cassandra$TimeUUIDPredicateRules$$isTimeUUIDNonEqualPredicate(TableDef tableDef, Filter predicate2) {
        boolean bl;
        if (PredicateOps$FilterOps$.MODULE$.isSingleColumnPredicate(predicate2)) {
            String columnName2 = PredicateOps$FilterOps$.MODULE$.columnName(predicate2);
            boolean isRange = PredicateOps$FilterOps$.MODULE$.isRangePredicate(predicate2);
            boolean isTimeUUID = tableDef.columnByName().get((Object)columnName2).exists((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(ColumnDef x$1) {
                    ColumnType columnType = x$1.columnType();
                    TimeUUIDType$ timeUUIDType$ = TimeUUIDType$.MODULE$;
                    return !(columnType != null ? !columnType.equals(timeUUIDType$) : timeUUIDType$ != null);
                }
            });
            bl = isRange && isTimeUUID;
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef, SparkConf conf) {
        Set unhandledTimeUUIDNonEqual = (Set)predicates.handledBySpark().filter((Function1)new Serializable(tableDef){
            public static final long serialVersionUID = 0L;
            private final TableDef tableDef$1;

            public final boolean apply(Filter x$2) {
                return TimeUUIDPredicateRules$.MODULE$.org$apache$spark$sql$cassandra$TimeUUIDPredicateRules$$isTimeUUIDNonEqualPredicate(this.tableDef$1, x$2);
            }
            {
                this.tableDef$1 = tableDef$1;
            }
        });
        Predef$.MODULE$.require(unhandledTimeUUIDNonEqual.isEmpty(), (Function0)new Serializable(unhandledTimeUUIDNonEqual){
            public static final long serialVersionUID = 0L;
            private final Set unhandledTimeUUIDNonEqual$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         | You are attempting to do a non-equality comparison on a TimeUUID column in Spark.\n         | Spark can only compare TimeUUIDs Lexically which means that the comparison will be\n         | different than the comparison done in C* which is done based on the Time Portion of\n         | TimeUUID. This will in almost all cases lead to incorrect results. If possible restrict\n         | doing a TimeUUID comparison only to columns which can be pushed down to Cassandra.\n         | https://datastax-oss.atlassian.net/browse/SPARKC-405.\n         |\n         | ", "\n    "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.unhandledTimeUUIDNonEqual$1})))).stripMargin();
            }
            {
                this.unhandledTimeUUIDNonEqual$1 = unhandledTimeUUIDNonEqual$1;
            }
        });
        return predicates;
    }

    private TimeUUIDPredicateRules$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

