/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class Either<L, R> {
    private Either() {
    }

    public abstract boolean isLeft();

    public final boolean isRight() {
        return !this.isLeft();
    }

    public abstract L getLeft();

    public abstract R getRight();

    public final void ifLeft(Consumer<? super L> consumer) {
        Objects.requireNonNull(consumer);
        if (this.isLeft()) {
            consumer.accept(this.getLeft());
        }
    }

    public final void ifRight(Consumer<? super R> consumer) {
        Objects.requireNonNull(consumer);
        if (this.isRight()) {
            consumer.accept(this.getRight());
        }
    }

    public final Optional<L> asOptionalLeft() {
        return this.fold(Optional::of, val -> Optional.empty());
    }

    public final Optional<R> asOptionalRight() {
        return this.fold(val -> Optional.empty(), Optional::of);
    }

    public final <T> T fold(Function<? super L, ? extends T> left, Function<? super R, ? extends T> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        if (this.isLeft()) {
            return left.apply(this.getLeft());
        }
        return right.apply(this.getRight());
    }

    public final void accept(Consumer<? super L> left, Consumer<? super R> right) {
        Objects.requireNonNull(left);
        Objects.requireNonNull(right);
        if (this.isLeft()) {
            left.accept(this.getLeft());
        } else {
            right.accept(this.getRight());
        }
    }

    public final <T> Either<T, R> mapLeft(Function<? super L, ? extends T> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isLeft()) {
            return Either.createLeft(mapper.apply(this.getLeft()));
        }
        return this;
    }

    public final <T> Either<L, T> mapRight(Function<? super R, ? extends T> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isLeft()) {
            return this;
        }
        return Either.createRight(mapper.apply(this.getRight()));
    }

    public final void acceptBoth(Consumer<? super L> left, Consumer<? super R> right, @Nullable L defaultLeft, @Nullable R defaultRight) {
        left.accept(this.isLeft() ? this.getLeft() : defaultLeft);
        right.accept(this.isRight() ? this.getRight() : defaultRight);
    }

    public static <L, R> Either<L, R> create(@Nullable L l, @Nullable R r) {
        if (l == null && r != null) {
            return Either.createRight(r);
        }
        if (l != null && r == null) {
            return Either.createLeft(l);
        }
        if (l == null) {
            throw new IllegalArgumentException("Both arguments were null.");
        }
        throw new IllegalArgumentException("Both arguments were non-null: " + l + " " + r);
    }

    public static <L, R> Either<L, R> createLeft(L l) {
        return new Left(l);
    }

    public static <L, R> Either<L, R> createRight(R r) {
        return new Right(r);
    }

    private static final class Right<L, R>
    extends Either<L, R> {
        private final R value;

        private Right(R value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public final boolean isLeft() {
            return false;
        }

        @Override
        public final L getLeft() {
            throw new NoSuchElementException();
        }

        @Override
        public final R getRight() {
            return this.value;
        }

        public final boolean equals(@Nullable Object otherObj) {
            if (otherObj instanceof Right) {
                return Objects.equals(this.value, ((Right)otherObj).value);
            }
            return false;
        }

        public final int hashCode() {
            return this.value.hashCode() % 2 + 1;
        }

        public final String toString() {
            return "Right[" + this.value.toString() + "]";
        }
    }

    private static final class Left<L, R>
    extends Either<L, R> {
        private final L value;

        private Left(L value) {
            this.value = Objects.requireNonNull(value);
        }

        @Override
        public final boolean isLeft() {
            return true;
        }

        @Override
        public final L getLeft() {
            return this.value;
        }

        @Override
        public final R getRight() {
            throw new NoSuchElementException();
        }

        public final boolean equals(@Nullable Object otherObj) {
            if (otherObj instanceof Left) {
                return Objects.equals(this.value, ((Left)otherObj).value);
            }
            return false;
        }

        public final int hashCode() {
            return this.value.hashCode() % 2;
        }

        public final String toString() {
            return "Left[" + this.value.toString() + "]";
        }
    }
}

