/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.base;

import com.diffplug.common.base.Consumers;
import com.diffplug.common.base.DurianPlugins;
import com.diffplug.common.base.Throwables;
import com.diffplug.common.base.Throwing;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public abstract class Errors
implements Consumer<Throwable> {
    protected final Consumer<Throwable> handler;
    private static final Handling suppress = Errors.createHandling(Consumers.doNothing());
    private static final Rethrowing rethrow = Errors.createRethrowing(Errors::rethrowErrorAndWrapOthersAsRuntime);
    private static Handling log;
    private static Handling dialog;

    static void resetForTesting() {
        log = null;
        dialog = null;
    }

    protected Errors(Consumer<Throwable> error) {
        this.handler = Objects.requireNonNull(error);
    }

    public static Handling createHandling(Consumer<Throwable> handler) {
        return new Handling(handler);
    }

    public static Rethrowing createRethrowing(Function<Throwable, RuntimeException> transform) {
        return new Rethrowing(transform);
    }

    public static Handling suppress() {
        return suppress;
    }

    public static Rethrowing rethrow() {
        return rethrow;
    }

    private static RuntimeException rethrowErrorAndWrapOthersAsRuntime(Throwable e) {
        if (e instanceof Error) {
            throw (Error)e;
        }
        return Errors.asRuntime(e);
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="This race condition is fine, as explained in the comment below.")
    public static Handling log() {
        if (log == null) {
            log = Errors.createHandling(DurianPlugins.get(Plugins.Log.class, Plugins::defaultLog));
        }
        return log;
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="This race condition is fine, as explained in the comment below.")
    public static Handling dialog() {
        if (dialog == null) {
            dialog = Errors.createHandling(DurianPlugins.get(Plugins.Dialog.class, Plugins::defaultDialog));
        }
        return dialog;
    }

    @Override
    public void accept(Throwable error) {
        Objects.requireNonNull(error);
        this.handler.accept(error);
    }

    public Consumer<Optional<Throwable>> asTerminal() {
        return errorOpt -> {
            if (errorOpt.isPresent()) {
                this.accept((Throwable)errorOpt.get());
            }
        };
    }

    public void run(Throwing.Runnable runnable) {
        this.wrap(runnable).run();
    }

    public Runnable wrap(Throwing.Runnable runnable) {
        Objects.requireNonNull(runnable);
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                this.handler.accept(e);
            }
        };
    }

    public <T> Consumer<T> wrap(Throwing.Consumer<T> consumer) {
        Objects.requireNonNull(consumer);
        return val -> {
            try {
                consumer.accept(val);
            }
            catch (Throwable e) {
                this.handler.accept(e);
            }
        };
    }

    public static RuntimeException asRuntime(Throwable e) {
        Objects.requireNonNull(e);
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new WrappedAsRuntimeException(e);
    }

    public static <E extends Throwable> ConstrainedTo<E> constrainTo(Class<E> exceptionClass) {
        return new ConstrainedTo(exceptionClass);
    }

    public static final class ConstrainedTo<E extends Throwable> {
        final Class<E> exceptionClass;

        private ConstrainedTo(Class<E> exceptionClass) {
            this.exceptionClass = Objects.requireNonNull(exceptionClass);
        }

        public void run(Throwing.Runnable runnable) throws E {
            try {
                runnable.run();
            }
            catch (Throwable error) {
                if (this.exceptionClass.isAssignableFrom(error.getClass())) {
                    throw error;
                }
                throw Errors.asRuntime(error);
            }
        }

        public <T> T get(Throwing.Supplier<T> supplier) throws E {
            try {
                return supplier.get();
            }
            catch (Throwable error) {
                if (this.exceptionClass.isAssignableFrom(error.getClass())) {
                    throw error;
                }
                throw Errors.asRuntime(error);
            }
        }
    }

    public static interface Plugins {
        public static void defaultLog(Throwable error) {
            error.printStackTrace();
        }

        public static void defaultDialog(Throwable error) {
            error.printStackTrace();
            try {
                Method invokeLater = Class.forName("javax.swing.SwingUtilities").getMethod("invokeLater", Runnable.class);
                Class<?> javaAwtComponent = Class.forName("java.awt.Component");
                Method showMessageDialog = Class.forName("javax.swing.JOptionPane").getMethod("showMessageDialog", javaAwtComponent, Object.class, String.class, Integer.TYPE);
                Runnable runnable = () -> {
                    try {
                        String title = error.getClass().getSimpleName();
                        showMessageDialog.invoke(null, null, error.getMessage() + "\n\n" + Throwables.getStackTraceAsString(error), title, 0);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                        // empty catch block
                    }
                };
                invokeLater.invoke(null, runnable);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                // empty catch block
            }
        }

        public static class OnErrorThrowAssertion
        implements Log,
        Dialog {
            @Override
            public void accept(Throwable error) {
                throw new AssertionError((Object)error);
            }
        }

        public static interface Dialog
        extends Consumer<Throwable> {
        }

        public static interface Log
        extends Consumer<Throwable> {
        }
    }

    public static class WrappedAsRuntimeException
    extends RuntimeException {
        private static final long serialVersionUID = -912202209702586994L;

        public WrappedAsRuntimeException(Throwable e) {
            super(e);
        }
    }

    public static class Rethrowing
    extends Errors {
        private final Function<Throwable, RuntimeException> transform;

        protected Rethrowing(Function<Throwable, RuntimeException> transform) {
            super((Throwable error) -> {
                throw (RuntimeException)transform.apply((Throwable)error);
            });
            this.transform = Objects.requireNonNull(transform);
        }

        public <T> T get(Throwing.Supplier<T> supplier) {
            return this.wrap(supplier).get();
        }

        public <T> Supplier<T> wrap(Throwing.Supplier<T> supplier) {
            Objects.requireNonNull(supplier);
            return () -> {
                try {
                    return supplier.get();
                }
                catch (Throwable e) {
                    throw this.transform.apply(e);
                }
            };
        }

        public <T, R> Function<T, R> wrap(Throwing.Function<T, R> function) {
            return this.wrapFunction(function);
        }

        public <T> Predicate<T> wrap(Throwing.Predicate<T> predicate) {
            return this.wrapPredicate(predicate);
        }

        public <T, R> Function<T, R> wrapFunction(Throwing.Function<T, R> function) {
            Objects.requireNonNull(function);
            return arg -> {
                try {
                    return function.apply(arg);
                }
                catch (Throwable e) {
                    throw this.transform.apply(e);
                }
            };
        }

        public <T> Predicate<T> wrapPredicate(Throwing.Predicate<T> predicate) {
            Objects.requireNonNull(predicate);
            return arg -> {
                try {
                    return predicate.test(arg);
                }
                catch (Throwable e) {
                    throw this.transform.apply(e);
                }
            };
        }
    }

    public static class Handling
    extends Errors {
        protected Handling(Consumer<Throwable> error) {
            super(error);
        }

        public <T> T getWithDefault(Throwing.Supplier<T> supplier, @Nullable T onFailure) {
            return this.wrapWithDefault(supplier, onFailure).get();
        }

        public <T> Supplier<T> wrapWithDefault(Throwing.Supplier<T> supplier, @Nullable T onFailure) {
            Objects.requireNonNull(supplier);
            return () -> {
                try {
                    return supplier.get();
                }
                catch (Throwable e) {
                    this.handler.accept(e);
                    return onFailure;
                }
            };
        }

        public <T, R> Function<T, R> wrapWithDefault(Throwing.Function<T, R> function, @Nullable R onFailure) {
            return this.wrapFunctionWithDefault(function, onFailure);
        }

        public <T> Predicate<T> wrapWithDefault(Throwing.Predicate<T> predicate, boolean onFailure) {
            return this.wrapPredicateWithDefault(predicate, onFailure);
        }

        public <T, R> Function<T, R> wrapFunctionWithDefault(Throwing.Function<T, R> function, @Nullable R onFailure) {
            Objects.requireNonNull(function);
            return input -> {
                try {
                    return function.apply(input);
                }
                catch (Throwable e) {
                    this.handler.accept(e);
                    return onFailure;
                }
            };
        }

        public <T> Predicate<T> wrapPredicateWithDefault(Throwing.Predicate<T> predicate, boolean onFailure) {
            Objects.requireNonNull(predicate);
            return input -> {
                try {
                    return predicate.test(input);
                }
                catch (Throwable e) {
                    this.handler.accept(e);
                    return onFailure;
                }
            };
        }
    }
}

