/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.glue.ktfmt;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.glue.ktfmt.KtfmtFormattingOptions;
import com.diffplug.spotless.glue.ktfmt.KtfmtStyle;
import com.facebook.ktfmt.format.Formatter;
import com.facebook.ktfmt.format.FormattingOptions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class KtfmtFormatterFunc
implements FormatterFunc {
    @Nonnull
    private final KtfmtStyle style;
    @Nullable
    private final KtfmtFormattingOptions ktfmtFormattingOptions;

    public KtfmtFormatterFunc() {
        this(KtfmtStyle.DEFAULT, null);
    }

    public KtfmtFormatterFunc(@Nonnull KtfmtStyle style) {
        this(style, null);
    }

    public KtfmtFormatterFunc(@Nullable KtfmtFormattingOptions ktfmtFormattingOptions) {
        this(KtfmtStyle.DEFAULT, ktfmtFormattingOptions);
    }

    public KtfmtFormatterFunc(@Nonnull KtfmtStyle style, @Nullable KtfmtFormattingOptions ktfmtFormattingOptions) {
        this.style = style;
        this.ktfmtFormattingOptions = ktfmtFormattingOptions;
    }

    @Override
    @Nonnull
    public String apply(@Nonnull String input) throws Exception {
        return Formatter.format((FormattingOptions)this.createFormattingOptions(), (String)input);
    }

    private FormattingOptions createFormattingOptions() {
        FormattingOptions formattingOptions;
        switch (this.style) {
            case DEFAULT: {
                formattingOptions = new FormattingOptions();
                break;
            }
            case DROPBOX: {
                formattingOptions = Formatter.DROPBOX_FORMAT;
                break;
            }
            case GOOGLE: {
                formattingOptions = Formatter.GOOGLE_FORMAT;
                break;
            }
            case KOTLIN_LANG: {
                formattingOptions = Formatter.KOTLINLANG_FORMAT;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown formatting option");
            }
        }
        if (this.ktfmtFormattingOptions != null) {
            formattingOptions = formattingOptions.copy(formattingOptions.getStyle(), this.ktfmtFormattingOptions.getMaxWidth().orElse(formattingOptions.getMaxWidth()).intValue(), this.ktfmtFormattingOptions.getBlockIndent().orElse(formattingOptions.getBlockIndent()).intValue(), this.ktfmtFormattingOptions.getContinuationIndent().orElse(formattingOptions.getContinuationIndent()).intValue(), this.ktfmtFormattingOptions.getRemoveUnusedImport().orElse(formattingOptions.getRemoveUnusedImports()).booleanValue(), formattingOptions.getDebuggingPrintOpsAfterFormatting());
        }
        return formattingOptions;
    }
}

