/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.typescript;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.npm.TsConfigFileType;
import com.diffplug.spotless.npm.TsFmtFormatterStep;
import com.diffplug.spotless.npm.TypedTsFmtConfigFile;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class Tsfmt
implements FormatterStepFactory {
    @Parameter
    private String tslintFile;
    @Parameter
    private String tsconfigFile;
    @Parameter
    private String vscodeFile;
    @Parameter
    private String tsfmtFile;
    @Parameter
    private String typescriptFormatterVersion;
    @Parameter
    private String typescriptVersion;
    @Parameter
    private String tslintVersion;
    @Parameter
    private String npmExecutable;
    @Parameter
    private Map<String, String> config;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig stepConfig) {
        TypedTsFmtConfigFile configFile;
        LinkedHashMap<String, Object> configInline;
        Map devDependencies = TsFmtFormatterStep.defaultDevDependencies();
        if (this.typescriptFormatterVersion != null) {
            devDependencies.put("typescript-formatter", this.typescriptFormatterVersion);
        }
        if (this.typescriptVersion != null) {
            devDependencies.put("typescript", this.typescriptVersion);
        }
        if (this.tslintVersion != null) {
            devDependencies.put("tslint", this.tslintVersion);
        }
        File npm = this.npmExecutable != null ? stepConfig.getFileLocator().locateLocal(this.npmExecutable) : null;
        if (this.tsconfigFile != null ^ this.tsfmtFile != null ^ this.tslintFile != null ^ this.vscodeFile != null) {
            if (this.config != null) {
                throw Tsfmt.onlyOneConfig();
            }
            configInline = null;
            if (this.tsconfigFile != null) {
                configFile = new TypedTsFmtConfigFile(TsConfigFileType.TSCONFIG, stepConfig.getFileLocator().locateLocal(this.tsconfigFile));
            } else if (this.tsfmtFile != null) {
                configFile = new TypedTsFmtConfigFile(TsConfigFileType.TSFMT, stepConfig.getFileLocator().locateLocal(this.tsfmtFile));
            } else if (this.tslintFile != null) {
                configFile = new TypedTsFmtConfigFile(TsConfigFileType.TSLINT, stepConfig.getFileLocator().locateLocal(this.tslintFile));
            } else {
                if (this.vscodeFile == null) throw new Error("Programming error: the xors did not match the cases");
                configFile = new TypedTsFmtConfigFile(TsConfigFileType.VSCODE, stepConfig.getFileLocator().locateLocal(this.vscodeFile));
            }
        } else {
            if (this.config == null) throw Tsfmt.onlyOneConfig();
            configFile = null;
            configInline = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, String> e : this.config.entrySet()) {
                try {
                    configInline.put(e.getKey(), Integer.parseInt(e.getValue()));
                }
                catch (NumberFormatException ignore) {
                    try {
                        configInline.put(e.getKey(), Boolean.parseBoolean(e.getValue()));
                    }
                    catch (IllegalArgumentException ignore2) {
                        configInline.put(e.getKey(), e.getValue());
                    }
                }
            }
        }
        File buildDir = stepConfig.getFileLocator().getBuildDir();
        return TsFmtFormatterStep.create((Map)devDependencies, (Provisioner)stepConfig.getProvisioner(), (File)buildDir, (File)npm, (TypedTsFmtConfigFile)configFile, configInline);
    }

    private static IllegalArgumentException onlyOneConfig() {
        return new IllegalArgumentException("must specify exactly one configFile or config");
    }
}

