/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.common.base.Errors;
import com.diffplug.spotless.extra.GitRatchet;
import java.io.File;
import java.io.IOException;
import java.util.function.Predicate;
import org.eclipse.jgit.lib.ObjectId;

final class GitRatchetMaven
extends GitRatchet<File> {
    private static volatile GitRatchetMaven instance = new GitRatchetMaven();

    private GitRatchetMaven() {
    }

    protected File getDir(File project) {
        return project;
    }

    protected File getParent(File project) {
        return project.getParentFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static GitRatchetMaven instance() {
        if (instance != null) return instance;
        Class<GitRatchetMaven> clazz = GitRatchetMaven.class;
        synchronized (GitRatchetMaven.class) {
            if (instance != null) return instance;
            instance = new GitRatchetMaven();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    Predicate<File> isGitDirty(File baseDir, String ratchetFrom) {
        ObjectId sha = this.rootTreeShaOf(baseDir, ratchetFrom);
        return file -> {
            try {
                return !this.isClean(baseDir, sha, (File)file);
            }
            catch (IOException e) {
                throw Errors.asRuntime((Throwable)e);
            }
        };
    }
}

