/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import discord4j.gateway.GatewayClient;
import discord4j.gateway.GatewayObserver;
import reactor.netty.ConnectionObserver;

class CompositeGatewayObserver
implements GatewayObserver {
    private final GatewayObserver[] observers;

    private CompositeGatewayObserver(GatewayObserver[] observers) {
        this.observers = observers;
    }

    @Override
    public void onStateChange(ConnectionObserver.State newState, GatewayClient gatewayClient) {
        for (GatewayObserver observer : this.observers) {
            observer.onStateChange(newState, gatewayClient);
        }
    }

    static GatewayObserver compose(GatewayObserver first, GatewayObserver second) {
        int pos;
        GatewayObserver[] secondObservers;
        GatewayObserver[] firstObservers;
        if (first == GatewayObserver.NOOP_LISTENER) {
            return second;
        }
        if (second == GatewayObserver.NOOP_LISTENER) {
            return first;
        }
        int length = 2;
        if (first instanceof CompositeGatewayObserver) {
            firstObservers = ((CompositeGatewayObserver)first).observers;
            length += firstObservers.length - 1;
        } else {
            firstObservers = null;
        }
        if (second instanceof CompositeGatewayObserver) {
            secondObservers = ((CompositeGatewayObserver)second).observers;
            length += secondObservers.length - 1;
        } else {
            secondObservers = null;
        }
        GatewayObserver[] combinedObservers = new GatewayObserver[length];
        if (firstObservers != null) {
            pos = firstObservers.length;
            System.arraycopy(firstObservers, 0, combinedObservers, 0, pos);
        } else {
            pos = 1;
            combinedObservers[0] = first;
        }
        if (secondObservers != null) {
            System.arraycopy(secondObservers, 0, combinedObservers, pos, secondObservers.length);
        } else {
            combinedObservers[pos] = second;
        }
        return new CompositeGatewayObserver(combinedObservers);
    }
}

