/*
 * Decompiled with CFR 0.152.
 */
package discord4j.gateway;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

public class ShardInfo {
    private static final Map<Tuple2<Integer, Integer>, ShardInfo> CACHE = new ConcurrentHashMap<Tuple2<Integer, Integer>, ShardInfo>();
    private final int index;
    private final int count;

    private ShardInfo(int index, int count) {
        this.index = index;
        this.count = count;
    }

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public static ShardInfo create(@JsonProperty(value="index") int index, @JsonProperty(value="count") int count) {
        return CACHE.computeIfAbsent((Tuple2<Integer, Integer>)Tuples.of((Object)index, (Object)count), t2 -> new ShardInfo((Integer)t2.getT1(), (Integer)t2.getT2()));
    }

    public int getIndex() {
        return this.index;
    }

    public int getCount() {
        return this.count;
    }

    public int[] asArray() {
        return new int[]{this.index, this.count};
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShardInfo shardInfo = (ShardInfo)o;
        return this.index == shardInfo.index && this.count == shardInfo.count;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.count);
    }

    public String format() {
        return this.index + "," + this.count;
    }

    public String toString() {
        return "ShardInfo{index=" + this.index + ", count=" + this.count + '}';
    }
}

