/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest;

import discord4j.common.util.Snowflake;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ApplicationInfoData;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildCreateRequest;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildUpdateData;
import discord4j.discordjson.json.InviteData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.RegionData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.TemplateData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.UserGuildData;
import discord4j.discordjson.json.UserModifyRequest;
import discord4j.discordjson.json.WebhookData;
import discord4j.rest.RestClientBuilder;
import discord4j.rest.RestResources;
import discord4j.rest.entity.RestChannel;
import discord4j.rest.entity.RestEmoji;
import discord4j.rest.entity.RestGuild;
import discord4j.rest.entity.RestMember;
import discord4j.rest.entity.RestMessage;
import discord4j.rest.entity.RestRole;
import discord4j.rest.entity.RestSticker;
import discord4j.rest.entity.RestUser;
import discord4j.rest.entity.RestWebhook;
import discord4j.rest.request.Router;
import discord4j.rest.request.RouterOptions;
import discord4j.rest.service.ApplicationService;
import discord4j.rest.service.AuditLogService;
import discord4j.rest.service.AutoModService;
import discord4j.rest.service.ChannelService;
import discord4j.rest.service.EmojiService;
import discord4j.rest.service.GatewayService;
import discord4j.rest.service.GuildService;
import discord4j.rest.service.InteractionService;
import discord4j.rest.service.InviteService;
import discord4j.rest.service.StickerService;
import discord4j.rest.service.TemplateService;
import discord4j.rest.service.UserService;
import discord4j.rest.service.VoiceService;
import discord4j.rest.service.WebhookService;
import discord4j.rest.util.PaginationUtil;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class RestClient {
    private final RestResources restResources;
    private final ApplicationService applicationService;
    private final AuditLogService auditLogService;
    private final ChannelService channelService;
    private final EmojiService emojiService;
    private final StickerService stickerService;
    private final GatewayService gatewayService;
    private final GuildService guildService;
    private final InteractionService interactionService;
    private final InviteService inviteService;
    private final TemplateService templateService;
    private final UserService userService;
    private final VoiceService voiceService;
    private final WebhookService webhookService;
    private final Mono<Long> applicationIdMono;
    private final AutoModService autoModService;

    public static RestClient create(String token) {
        return RestClientBuilder.createRest(token).build();
    }

    public static RestClientBuilder<RestClient, RouterOptions> restBuilder(String token) {
        return RestClientBuilder.createRest(token);
    }

    protected RestClient(RestResources restResources) {
        this.restResources = restResources;
        Router router = restResources.getRouter();
        this.applicationService = new ApplicationService(router);
        this.auditLogService = new AuditLogService(router);
        this.channelService = new ChannelService(router);
        this.emojiService = new EmojiService(router);
        this.stickerService = new StickerService(router);
        this.gatewayService = new GatewayService(router);
        this.guildService = new GuildService(router);
        this.interactionService = new InteractionService(router);
        this.inviteService = new InviteService(router);
        this.templateService = new TemplateService(router);
        this.userService = new UserService(router);
        this.voiceService = new VoiceService(router);
        this.webhookService = new WebhookService(router);
        this.autoModService = new AutoModService(router);
        this.applicationIdMono = this.getApplicationInfo().map(app -> Snowflake.asLong((Id)app.id())).cache(__ -> Duration.ofMillis(Long.MAX_VALUE), __ -> Duration.ZERO, () -> Duration.ZERO);
    }

    public RestResources getRestResources() {
        return this.restResources;
    }

    public RestChannel getChannelById(Snowflake channelId) {
        return RestChannel.create(this, channelId);
    }

    public RestChannel restChannel(ChannelData data) {
        return RestChannel.create(this, Snowflake.of((Id)data.id()));
    }

    public RestGuild getGuildById(Snowflake guildId) {
        return RestGuild.create(this, guildId);
    }

    public RestGuild restGuild(GuildData data) {
        return RestGuild.create(this, Snowflake.of((Id)data.id()));
    }

    public RestEmoji getGuildEmojiById(Snowflake guildId, Snowflake emojiId) {
        return RestEmoji.create(this, guildId, emojiId);
    }

    public RestEmoji restGuildEmoji(Snowflake guildId, EmojiData data) {
        return RestEmoji.create(this, guildId, Snowflake.of((Id)((Id)data.id().orElseThrow(() -> new IllegalArgumentException("Not a guild emoji")))));
    }

    public RestSticker getGuildStickerById(Snowflake guildId, Snowflake stickerId) {
        return RestSticker.create(this, guildId, stickerId);
    }

    public RestSticker restGuildSticker(Snowflake guildId, StickerData data) {
        return RestSticker.create(this, guildId, Snowflake.of((Id)data.id()));
    }

    public RestMember getMemberById(Snowflake guildId, Snowflake userId) {
        return RestMember.create(this, guildId, userId);
    }

    public RestMember restMember(Snowflake guildId, MemberData data) {
        return RestMember.create(this, guildId, Snowflake.of((Id)data.user().id()));
    }

    public RestMember selfRestMember(Snowflake guildId) {
        return RestMember.create(this, guildId, this.restResources.getSelfId());
    }

    public RestMessage getMessageById(Snowflake channelId, Snowflake messageId) {
        return RestMessage.create(this, channelId, messageId);
    }

    public RestMessage restMessage(MessageData data) {
        return RestMessage.create(this, Snowflake.of((Id)data.channelId()), Snowflake.of((Id)data.id()));
    }

    public RestRole getRoleById(Snowflake guildId, Snowflake roleId) {
        return RestRole.create(this, guildId, roleId);
    }

    public RestRole restRole(Snowflake guildId, RoleData data) {
        return RestRole.create(this, guildId, Snowflake.of((Id)data.id()));
    }

    public RestUser getUserById(Snowflake userId) {
        return RestUser.create(this, userId);
    }

    public RestUser restUser(UserData data) {
        return RestUser.create(this, Snowflake.of((Id)data.id()));
    }

    public RestWebhook getWebhookById(Snowflake webhookId) {
        return RestWebhook.create(this, webhookId);
    }

    public RestWebhook restWebhook(WebhookData data) {
        return RestWebhook.create(this, Snowflake.of((Id)data.id()));
    }

    public Mono<ApplicationInfoData> getApplicationInfo() {
        return this.getApplicationService().getCurrentApplicationInfo();
    }

    public Flux<UserGuildData> getGuilds() {
        Function makeRequest = params -> this.getUserService().getCurrentUserGuilds((Map<String, Object>)params);
        return PaginationUtil.paginateAfter(makeRequest, data -> Snowflake.asLong((Id)data.id()), 0L, 100);
    }

    public Flux<RegionData> getRegions() {
        return this.getVoiceService().getVoiceRegions();
    }

    public Mono<UserData> getSelf() {
        return this.userService.getCurrentUser();
    }

    public Mono<MemberData> getSelfMember(Snowflake guildId) {
        return this.guildService.getGuildMember(guildId.asLong(), this.restResources.getSelfId().asLong());
    }

    public Mono<GuildUpdateData> createGuild(GuildCreateRequest request) {
        return this.guildService.createGuild(request);
    }

    public Mono<InviteData> getInvite(String inviteCode) {
        return this.inviteService.getInvite(inviteCode);
    }

    public Mono<InviteData> getInvite(String inviteCode, boolean withCounts, boolean withExpiration, @Nullable Snowflake guildScheduledEventId) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("with_counts", withCounts);
        queryParams.put("with_expiration", withExpiration);
        if (guildScheduledEventId != null) {
            queryParams.put("guild_scheduled_event_id", guildScheduledEventId.asString());
        }
        return this.inviteService.getInvite(inviteCode, queryParams);
    }

    public Mono<TemplateData> getTemplate(String templateCode) {
        return this.templateService.getTemplate(templateCode);
    }

    public Mono<UserData> edit(UserModifyRequest request) {
        return this.userService.modifyCurrentUser(request);
    }

    public ApplicationService getApplicationService() {
        return this.applicationService;
    }

    public AuditLogService getAuditLogService() {
        return this.auditLogService;
    }

    public ChannelService getChannelService() {
        return this.channelService;
    }

    public EmojiService getEmojiService() {
        return this.emojiService;
    }

    public StickerService getStickerService() {
        return this.stickerService;
    }

    public GatewayService getGatewayService() {
        return this.gatewayService;
    }

    public GuildService getGuildService() {
        return this.guildService;
    }

    public InteractionService getInteractionService() {
        return this.interactionService;
    }

    public InviteService getInviteService() {
        return this.inviteService;
    }

    public TemplateService getTemplateService() {
        return this.templateService;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public VoiceService getVoiceService() {
        return this.voiceService;
    }

    public WebhookService getWebhookService() {
        return this.webhookService;
    }

    public AutoModService getAutoModService() {
        return this.autoModService;
    }

    public Mono<Long> getApplicationId() {
        return this.applicationIdMono;
    }
}

