/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import discord4j.rest.http.WriterStrategy;
import io.netty.buffer.ByteBufAllocator;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Mono;
import reactor.netty.ByteBufFlux;
import reactor.netty.http.client.HttpClient;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.annotation.Nullable;

public class JacksonWriterStrategy
implements WriterStrategy<Object> {
    private static final Logger log = Loggers.getLogger(JacksonWriterStrategy.class);
    private final ObjectMapper objectMapper;

    public JacksonWriterStrategy(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean canWrite(@Nullable Class<?> type, @Nullable String contentType) {
        if (type == null || contentType == null || !contentType.startsWith("application/json")) {
            return false;
        }
        Class rawClass = this.getJavaType(type).getRawClass();
        return Object.class == rawClass || !String.class.isAssignableFrom(rawClass) && this.objectMapper.canSerialize(rawClass);
    }

    @Override
    public Mono<HttpClient.ResponseReceiver<?>> write(HttpClient.RequestSender sender, @Nullable Object body) {
        if (body == null) {
            return Mono.error((Throwable)new RuntimeException("Missing body"));
        }
        Mono source = Mono.fromCallable(() -> this.mapToString(body)).doOnNext(json -> {
            if (log.isTraceEnabled()) {
                log.trace("{}", new Object[]{json});
            }
        });
        return Mono.fromCallable(() -> sender.send((Publisher)ByteBufFlux.fromString((Publisher)source, (Charset)StandardCharsets.UTF_8, (ByteBufAllocator)ByteBufAllocator.DEFAULT)));
    }

    private String mapToString(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private JavaType getJavaType(Type type) {
        TypeFactory typeFactory = this.objectMapper.getTypeFactory();
        return typeFactory.constructType(type);
    }
}

