/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.route;

import discord4j.common.annotations.Experimental;
import discord4j.rest.route.Route;

public abstract class Routes {
    public static final String BASE_URL = "https://discord.com/api/v8";
    public static final Route GATEWAY_GET = Route.get("/gateway");
    public static final Route GATEWAY_BOT_GET = Route.get("/gateway/bot");
    public static final Route AUDIT_LOG_GET = Route.get("/guilds/{guild.id}/audit-logs");
    public static final Route AUTO_MOD_RULES_GET = Route.get("/guilds/{guild.id}/auto-moderation/rules");
    public static final Route AUTO_MOD_RULE_GET = Route.get("/guilds/{guild.id}/auto-moderation/rules/{auto_moderation_rule.id}");
    public static final Route AUTO_MOD_RULE_CREATE = Route.post("/guilds/{guild.id}/auto-moderation/rules");
    public static final Route AUTO_MOD_RULE_MODIFY = Route.patch("/guilds/{guild.id}/auto-moderation/rules/{auto_moderation_rule.id}");
    public static final Route AUTO_MOD_RULE_DELETE = Route.patch("/guilds/{guild.id}/auto-moderation/rules/{auto_moderation_rule.id}");
    public static final Route CHANNEL_GET = Route.get("/channels/{channel.id}");
    public static final Route CHANNEL_MODIFY = Route.put("/channels/{channel.id}");
    public static final Route CHANNEL_MODIFY_PARTIAL = Route.patch("/channels/{channel.id}");
    public static final Route CHANNEL_DELETE = Route.delete("/channels/{channel.id}");
    public static final Route MESSAGES_GET = Route.get("/channels/{channel.id}/messages");
    public static final Route MESSAGE_GET = Route.get("/channels/{channel.id}/messages/{message.id}");
    public static final Route MESSAGE_CREATE = Route.post("/channels/{channel.id}/messages");
    public static final Route REACTION_CREATE = Route.put("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}/@me");
    public static final Route REACTION_DELETE_OWN = Route.delete("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}/@me");
    public static final Route REACTION_DELETE_USER = Route.delete("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}/{user.id}");
    public static final Route REACTION_DELETE = Route.delete("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}");
    public static final Route REACTIONS_GET = Route.get("/channels/{channel.id}/messages/{message.id}/reactions/{emoji}");
    public static final Route REACTIONS_DELETE_ALL = Route.delete("/channels/{channel.id}/messages/{message.id}/reactions");
    public static final Route MESSAGE_EDIT = Route.patch("/channels/{channel.id}/messages/{message.id}");
    public static final Route MESSAGE_DELETE = Route.delete("/channels/{channel.id}/messages/{message.id}");
    public static final Route MESSAGE_DELETE_BULK = Route.post("/channels/{channel.id}/messages/bulk-delete");
    @Experimental
    public static final Route MESSAGE_SUPPRESS_EMBEDS = Route.post("/channels/{channel.id}/messages/{message.id}/suppress-embeds");
    public static final Route CROSSPOST_MESSAGE = Route.post("/channels/{channel.id}/messages/{message.id}/crosspost");
    public static final Route CHANNEL_PERMISSIONS_EDIT = Route.put("/channels/{channel.id}/permissions/{overwrite.id}");
    public static final Route CHANNEL_INVITES_GET = Route.get("/channels/{channel.id}/invites");
    public static final Route CHANNEL_INVITE_CREATE = Route.post("/channels/{channel.id}/invites");
    public static final Route CHANNEL_PERMISSION_DELETE = Route.delete("/channels/{channel.id}/permissions/{overwrite.id}");
    public static final Route FOLLOW_NEWS_CHANNEL = Route.post("/channels/{channel.id}/followers");
    public static final Route TYPING_INDICATOR_TRIGGER = Route.post("/channels/{channel.id}/typing");
    public static final Route MESSAGES_PINNED_GET = Route.get("/channels/{channel.id}/pins");
    public static final Route MESSAGES_PINNED_ADD = Route.put("/channels/{channel.id}/pins/{message.id}");
    public static final Route MESSAGES_PINNED_DELETE = Route.delete("/channels/{channel.id}/pins/{message.id}");
    public static final Route GROUP_DM_RECIPIENT_ADD = Route.put("/channels/{channel.id}/recipients/{user.id}");
    public static final Route GROUP_DM_RECIPIENT_DELETE = Route.delete("/channels/{channel.id}/recipients/{user.id}");
    public static final Route STICKER_GET = Route.get("/stickers/{sticker.id}");
    public static final Route NITRO_STICKER_PACKS_GET = Route.get("/sticker-packs");
    public static final Route GUILD_STICKERS_GET = Route.get("/guilds/{guild.id}/stickers");
    public static final Route GUILD_STICKER_GET = Route.get("/guilds/{guild.id}/stickers/{sticker.id}");
    public static final Route GUILD_STICKER_CREATE = Route.post("/guilds/{guild.id}/stickers");
    public static final Route GUILD_STICKER_MODIFY = Route.patch("/guilds/{guild.id}/stickers/{sticker.id}");
    public static final Route GUILD_STICKER_DELETE = Route.delete("/guilds/{guild.id}/stickers/{sticker.id}");
    public static final Route GUILD_EMOJIS_GET = Route.get("/guilds/{guild.id}/emojis");
    public static final Route GUILD_EMOJI_GET = Route.get("/guilds/{guild.id}/emojis/{emoji.id}");
    public static final Route GUILD_EMOJI_CREATE = Route.post("/guilds/{guild.id}/emojis");
    public static final Route GUILD_EMOJI_MODIFY = Route.patch("/guilds/{guild.id}/emojis/{emoji.id}");
    public static final Route GUILD_EMOJI_DELETE = Route.delete("/guilds/{guild.id}/emojis/{emoji.id}");
    public static final Route GUILD_CREATE = Route.post("/guilds");
    public static final Route GUILD_GET = Route.get("/guilds/{guild.id}");
    public static final Route GUILD_MODIFY = Route.patch("/guilds/{guild.id}");
    public static final Route GUILD_DELETE = Route.delete("/guilds/{guild.id}");
    public static final Route GUILD_CHANNELS_GET = Route.get("/guilds/{guild.id}/channels");
    public static final Route GUILD_CHANNEL_CREATE = Route.post("/guilds/{guild.id}/channels");
    public static final Route GUILD_CHANNEL_POSITIONS_MODIFY = Route.patch("/guilds/{guild.id}/channels");
    public static final Route GUILD_MEMBER_GET = Route.get("/guilds/{guild.id}/members/{user.id}");
    public static final Route GUILD_MEMBERS_LIST = Route.get("/guilds/{guild.id}/members");
    public static final Route SEARCH_GUILD_MEMBERS_GET = Route.get("/guilds/{guild.id}/members/search");
    public static final Route GUILD_MEMBER_ADD = Route.put("/guilds/{guild.id}/members/{user.id}");
    public static final Route GUILD_MEMBER_MODIFY = Route.patch("/guilds/{guild.id}/members/{user.id}");
    public static final Route NICKNAME_MODIFY_OWN = Route.patch("/guilds/{guild.id}/members/@me/nick");
    public static final Route GUILD_MEMBER_ROLE_ADD = Route.put("/guilds/{guild.id}/members/{user.id}/roles/{role.id}");
    public static final Route GUILD_MEMBER_ROLE_REMOVE = Route.delete("/guilds/{guild.id}/members/{user.id}/roles/{role.id}");
    public static final Route GUILD_MEMBER_REMOVE = Route.delete("/guilds/{guild.id}/members/{user.id}");
    public static final Route GUILD_BANS_GET = Route.get("/guilds/{guild.id}/bans");
    public static final Route GUILD_BAN_GET = Route.get("/guilds/{guild.id}/bans/{user.id}");
    public static final Route GUILD_BAN_CREATE = Route.put("/guilds/{guild.id}/bans/{user.id}");
    public static final Route GUILD_BAN_REMOVE = Route.delete("/guilds/{guild.id}/bans/{user.id}");
    public static final Route GUILD_ROLES_GET = Route.get("/guilds/{guild.id}/roles");
    public static final Route GUILD_ROLE_CREATE = Route.post("/guilds/{guild.id}/roles");
    public static final Route GUILD_ROLE_POSITIONS_MODIFY = Route.patch("/guilds/{guild.id}/roles");
    public static final Route GUILD_ROLE_MODIFY = Route.patch("/guilds/{guild.id}/roles/{role.id}");
    public static final Route GUILD_ROLE_DELETE = Route.delete("/guilds/{guild.id}/roles/{role.id}");
    public static final Route GUILD_PRUNE_COUNT_GET = Route.get("/guilds/{guild.id}/prune");
    public static final Route GUILD_PRUNE_BEGIN = Route.post("/guilds/{guild.id}/prune");
    public static final Route GUILD_VOICE_REGIONS_GET = Route.get("/guilds/{guild.id}/regions");
    public static final Route GUILD_INVITES_GET = Route.get("/guilds/{guild.id}/invites");
    public static final Route GUILD_INTEGRATIONS_GET = Route.get("/guilds/{guild.id}/integrations");
    public static final Route GUILD_INTEGRATION_CREATE = Route.post("/guilds/{guild.id}/integrations");
    public static final Route GUILD_INTEGRATION_MODIFY = Route.patch("/guilds/{guild.id}/integrations/{integration.id}");
    public static final Route GUILD_INTEGRATION_DELETE = Route.delete("/guilds/{guild.id}/integrations/{integration.id}");
    public static final Route GUILD_INTEGRATION_SYNC = Route.post("/guilds/{guild.id}/integrations/{integration.id}/sync");
    public static final Route GUILD_WIDGET_GET = Route.get("/guilds/{guild.id}/widget");
    public static final Route GUILD_WIDGET_MODIFY = Route.patch("/guilds/{guild.id}/widget");
    public static final Route GUILD_PREVIEW_GET = Route.get("/guilds/{guild.id}/preview");
    public static final Route SELF_VOICE_STATE_MODIFY = Route.patch("/guilds/{guild.id}/voice-states/@me");
    public static final Route OTHERS_VOICE_STATE_MODIFY = Route.patch("/guilds/{guild.id}/voice-states/{user.id}");
    public static final Route INVITE_GET = Route.get("/invites/{invite.code}");
    public static final Route INVITE_DELETE = Route.delete("/invites/{invite.code}");
    public static final Route INVITE_ACCEPT = Route.post("/invites/{invite.code}");
    public static final Route GUILD_TEMPLATE_GET = Route.get("/guilds/templates/{template.code}");
    public static final Route TEMPLATE_GUILD_CREATE = Route.post("/guilds/templates/{template.code}");
    public static final Route GUILD_TEMPLATE_LIST_GET = Route.get("/guilds/{guild.id}/templates");
    public static final Route GUILD_TEMPLATE_CREATE = Route.post("/guilds/{guild.id}/templates");
    public static final Route GUILD_TEMPLATE_SYNC = Route.put("/guilds/{guild.id}/templates/{template.code}");
    public static final Route GUILD_TEMPLATE_MODIFY = Route.patch("/guilds/{guild.id}/templates/{template.code}");
    public static final Route GUILD_TEMPLATE_DELETE = Route.delete("/guilds/{guild.id}/templates/{template.code}");
    public static final Route CURRENT_USER_GET = Route.get("/users/@me");
    public static final Route USER_GET = Route.get("/users/{user.id}");
    public static final Route CURRENT_USER_MODIFY = Route.patch("/users/@me");
    public static final Route CURRENT_USER_GUILDS_GET = Route.get("/users/@me/guilds");
    public static final Route GUILD_LEAVE = Route.delete("/users/@me/guilds/{guild.id}");
    public static final Route USER_DM_CREATE = Route.post("/users/@me/channels");
    public static final Route GROUP_DM_CREATE = Route.post("/users/@me/channels");
    public static final Route USER_CONNECTIONS_GET = Route.get("/users/@me/connections");
    public static final Route VOICE_REGION_LIST = Route.get("/voice/regions");
    public static final Route CHANNEL_WEBHOOK_CREATE = Route.post("/channels/{channel.id}/webhooks");
    public static final Route CHANNEL_WEBHOOKS_GET = Route.get("/channels/{channel.id}/webhooks");
    public static final Route GUILD_WEBHOOKS_GET = Route.get("/guilds/{guild.id}/webhooks");
    public static final Route WEBHOOK_GET = Route.get("/webhooks/{webhook.id}");
    public static final Route WEBHOOK_TOKEN_GET = Route.get("/webhooks/{webhook.id}/{webhook.token}");
    public static final Route WEBHOOK_MODIFY = Route.patch("/webhooks/{webhook.id}");
    public static final Route WEBHOOK_TOKEN_MODIFY = Route.patch("/webhooks/{webhook.id}/{webhook.token}");
    public static final Route WEBHOOK_DELETE = Route.delete("/webhooks/{webhook.id}");
    public static final Route WEBHOOK_TOKEN_DELETE = Route.delete("/webhooks/{webhook.id}/{webhook.token}");
    public static final Route WEBHOOK_EXECUTE = Route.post("/webhooks/{webhook.id}/{webhook.token}");
    public static final Route WEBHOOK_EXECUTE_SLACK = Route.post("/webhooks/{webhook.id}/{webhook.token}/slack");
    public static final Route WEBHOOK_EXECUTE_GITHUB = Route.post("/webhooks/{webhook.id}/{webhook.token}/github");
    public static final Route WEBHOOK_MESSAGE_GET = Route.get("/webhooks/{webhook.id}/{webhook.token}/messages/{message.id}");
    public static final Route WEBHOOK_MESSAGE_EDIT = Route.patch("/webhooks/{webhook.id}/{webhook.token}/messages/{message.id}");
    public static final Route WEBHOOK_MESSAGE_DELETE = Route.delete("/webhooks/{webhook.id}/{webhook.token}/messages/{message.id}");
    public static final Route APPLICATION_INFO_GET = Route.get("/oauth2/applications/@me");
    public static final Route GLOBAL_APPLICATION_COMMANDS_GET = Route.get("/applications/{application.id}/commands");
    public static final Route GLOBAL_APPLICATION_COMMANDS_CREATE = Route.post("/applications/{application.id}/commands");
    public static final Route GLOBAL_APPLICATION_COMMANDS_BULK_OVERWRITE = Route.put("/applications/{application.id}/commands");
    public static final Route GLOBAL_APPLICATION_COMMAND_GET = Route.get("/applications/{application.id}/commands/{command.id}");
    public static final Route GLOBAL_APPLICATION_COMMAND_MODIFY = Route.patch("/applications/{application.id}/commands/{command.id}");
    public static final Route GLOBAL_APPLICATION_COMMAND_DELETE = Route.delete("/applications/{application.id}/commands/{command.id}");
    public static final Route GUILD_APPLICATION_COMMANDS_GET = Route.get("/applications/{application.id}/guilds/{guild.id}/commands");
    public static final Route GUILD_APPLICATION_COMMANDS_CREATE = Route.post("/applications/{application.id}/guilds/{guild.id}/commands");
    public static final Route GUILD_APPLICATION_COMMANDS_BULK_OVERWRITE = Route.put("/applications/{application.id}/guilds/{guild.id}/commands");
    public static final Route GUILD_APPLICATION_COMMAND_GET = Route.get("/applications/{application.id}/guilds/{guild.id}/commands/{command.id}");
    public static final Route GUILD_APPLICATION_COMMAND_MODIFY = Route.patch("/applications/{application.id}/guilds/{guild.id}/commands/{command.id}");
    public static final Route GUILD_APPLICATION_COMMAND_DELETE = Route.delete("/applications/{application.id}/guilds/{guild.id}/commands/{command.id}");
    public static final Route GUILD_APPLICATION_COMMAND_PERMISSIONS_GET = Route.get("/applications/{application.id}/guilds/{guild.id}/commands/permissions");
    public static final Route APPLICATION_COMMAND_PERMISSIONS_GET = Route.get("/applications/{application.id}/guilds/{guild.id}/commands/{command.id}/permissions");
    public static final Route APPLICATION_COMMAND_PERMISSIONS_MODIFY = Route.put("/applications/{application.id}/guilds/{guild.id}/commands/{command.id}/permissions");
    public static final Route APPLICATION_COMMAND_PERMISSIONS_BULK_MODIFY = Route.put("/applications/{application.id}/guilds/{guild.id}/commands/permissions");
    public static final Route INTERACTION_RESPONSE_CREATE = Route.post("/interactions/{interaction.id}/{interaction.token}/callback");
}

