/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

import discord4j.common.annotations.Experimental;
import discord4j.rest.util.Multimap;
import io.netty.handler.codec.http.QueryStringEncoder;
import java.io.ByteArrayOutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import reactor.util.annotation.Nullable;

public class RouteUtils {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("\\{([\\w.]+)\\}");
    private static final Charset UTF_8 = StandardCharsets.UTF_8;

    private RouteUtils() {
    }

    public static String expand(String template, Object ... variables) {
        if (variables.length == 0) {
            return template;
        }
        StringBuffer buf = new StringBuffer();
        Matcher matcher = PARAMETER_PATTERN.matcher(template);
        int index = 0;
        while (matcher.find()) {
            matcher.appendReplacement(buf, RouteUtils.encodeUriPathSegment(variables[index++].toString()));
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @Experimental
    public static Map<String, String> createVariableMap(String template, Object ... variables) {
        LinkedHashMap<String, String> variableMap = new LinkedHashMap<String, String>();
        if (variables.length == 0) {
            return variableMap;
        }
        Matcher matcher = PARAMETER_PATTERN.matcher(template);
        int index = 0;
        while (matcher.find()) {
            variableMap.put(matcher.group().replaceAll("[{}]", ""), variables[index++].toString());
        }
        return variableMap;
    }

    public static String expandQuery(String uri, @Nullable Multimap<String, Object> values) {
        if (values == null) {
            return uri;
        }
        QueryStringEncoder encoder = new QueryStringEncoder(uri);
        values.forEach((key, value) -> value.forEach(o -> encoder.addParam(key, String.valueOf(o))));
        return encoder.toString();
    }

    @Nullable
    public static String getMajorParam(String template, String complete) {
        if (template.contains("{channel.id}") || template.contains("{guild.id}") || template.contains("{webhook.id}")) {
            int start = template.indexOf(123);
            if (start == -1) {
                return null;
            }
            int end = complete.indexOf(47, start);
            if (end == -1) {
                end = complete.length();
            }
            return complete.substring(start, end);
        }
        return null;
    }

    private static String encodeUriPathSegment(@Nullable String source) {
        if (source == null || source.isEmpty()) {
            return "";
        }
        byte[] bytes = source.getBytes(UTF_8);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(bytes.length);
        boolean changed = false;
        for (byte b : bytes) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (RouteUtils.isPathSegmentAllowed(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
            changed = true;
        }
        return changed ? new String(bos.toByteArray(), UTF_8) : source;
    }

    private static boolean isPathSegmentAllowed(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 45 || c == 46 || c == 95 || c == 126 || c == 33 || c == 36 || c == 38 || c == 39 || c == 40 || c == 41 || c == 42 || c == 43 || c == 44 || c == 59 || c == 61 || c == 58 || c == 64;
    }
}

