/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Contains details about the history of the BCC email archive configuration.")
public class BccEmailArchiveHistory {
    @JsonProperty(value="accountId")
    private String accountId = null;
    @JsonProperty(value="action")
    private String action = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="modified")
    private String modified = null;
    @JsonProperty(value="modifiedBy")
    private UserInfo modifiedBy = null;
    @JsonProperty(value="status")
    private String status = null;

    public BccEmailArchiveHistory accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Schema(description="The account ID associated with the envelope.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public BccEmailArchiveHistory action(String action) {
        this.action = action;
        return this;
    }

    @Schema(description="")
    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public BccEmailArchiveHistory email(String email) {
        this.email = email;
        return this;
    }

    @Schema(description="")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public BccEmailArchiveHistory modified(String modified) {
        this.modified = modified;
        return this;
    }

    @Schema(description="")
    public String getModified() {
        return this.modified;
    }

    public void setModified(String modified) {
        this.modified = modified;
    }

    public BccEmailArchiveHistory modifiedBy(UserInfo modifiedBy) {
        this.modifiedBy = modifiedBy;
        return this;
    }

    @Schema(description="Details about the user who last modified the BCC email archive configuration.")
    public UserInfo getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(UserInfo modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public BccEmailArchiveHistory status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BccEmailArchiveHistory bccEmailArchiveHistory = (BccEmailArchiveHistory)o;
        return Objects.equals(this.accountId, bccEmailArchiveHistory.accountId) && Objects.equals(this.action, bccEmailArchiveHistory.action) && Objects.equals(this.email, bccEmailArchiveHistory.email) && Objects.equals(this.modified, bccEmailArchiveHistory.modified) && Objects.equals(this.modifiedBy, bccEmailArchiveHistory.modifiedBy) && Objects.equals(this.status, bccEmailArchiveHistory.status);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.action, this.email, this.modified, this.modifiedBy, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BccEmailArchiveHistory {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    action: ").append(this.toIndentedString(this.action)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    modified: ").append(this.toIndentedString(this.modified)).append("\n");
        sb.append("    modifiedBy: ").append(this.toIndentedString(this.modifiedBy)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

