/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AccountAddress;
import com.docusign.esign.model.AccountSettingsInformation;
import com.docusign.esign.model.CreditCardInformation;
import com.docusign.esign.model.DirectDebitProcessorInformation;
import com.docusign.esign.model.PaymentProcessorInformation;
import com.docusign.esign.model.PlanInformation;
import com.docusign.esign.model.ReferralInformation;
import com.docusign.esign.model.SocialAccountInformation;
import com.docusign.esign.model.UserInformation;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

public class NewAccountDefinition {
    @JsonProperty(value="accountName")
    private String accountName = null;
    @JsonProperty(value="accountSettings")
    private AccountSettingsInformation accountSettings = null;
    @JsonProperty(value="addressInformation")
    private AccountAddress addressInformation = null;
    @JsonProperty(value="creditCardInformation")
    private CreditCardInformation creditCardInformation = null;
    @JsonProperty(value="directDebitProcessorInformation")
    private DirectDebitProcessorInformation directDebitProcessorInformation = null;
    @JsonProperty(value="distributorCode")
    private String distributorCode = null;
    @JsonProperty(value="distributorPassword")
    private String distributorPassword = null;
    @JsonProperty(value="enablePreAuth")
    private String enablePreAuth = null;
    @JsonProperty(value="envelopePartitionId")
    private String envelopePartitionId = null;
    @JsonProperty(value="initialUser")
    private UserInformation initialUser = null;
    @JsonProperty(value="paymentMethod")
    private String paymentMethod = null;
    @JsonProperty(value="paymentProcessor")
    private String paymentProcessor = null;
    @JsonProperty(value="paymentProcessorInformation")
    private PaymentProcessorInformation paymentProcessorInformation = null;
    @JsonProperty(value="planInformation")
    private PlanInformation planInformation = null;
    @JsonProperty(value="processPayment")
    private String processPayment = null;
    @JsonProperty(value="referralInformation")
    private ReferralInformation referralInformation = null;
    @JsonProperty(value="socialAccountInformation")
    private SocialAccountInformation socialAccountInformation = null;
    @JsonProperty(value="taxExemptId")
    private String taxExemptId = null;

    public NewAccountDefinition accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @Schema(description="The account name for the new account.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public NewAccountDefinition accountSettings(AccountSettingsInformation accountSettings) {
        this.accountSettings = accountSettings;
        return this;
    }

    @Schema(description="The list of account settings. These determine the features available for the account. Note that some features are determined by the plan used to create the account, and cannot be overridden.")
    public AccountSettingsInformation getAccountSettings() {
        return this.accountSettings;
    }

    public void setAccountSettings(AccountSettingsInformation accountSettings) {
        this.accountSettings = accountSettings;
    }

    public NewAccountDefinition addressInformation(AccountAddress addressInformation) {
        this.addressInformation = addressInformation;
        return this;
    }

    @Schema(description="A complex type that contains the following information for the new account: `Street1`, `Street2`, `City`, `State`, `Zip`, `Phone`, and `Fax`.")
    public AccountAddress getAddressInformation() {
        return this.addressInformation;
    }

    public void setAddressInformation(AccountAddress addressInformation) {
        this.addressInformation = addressInformation;
    }

    public NewAccountDefinition creditCardInformation(CreditCardInformation creditCardInformation) {
        this.creditCardInformation = creditCardInformation;
        return this;
    }

    @Schema(description="A complex type that has information about the credit card used to pay for this account.")
    public CreditCardInformation getCreditCardInformation() {
        return this.creditCardInformation;
    }

    public void setCreditCardInformation(CreditCardInformation creditCardInformation) {
        this.creditCardInformation = creditCardInformation;
    }

    public NewAccountDefinition directDebitProcessorInformation(DirectDebitProcessorInformation directDebitProcessorInformation) {
        this.directDebitProcessorInformation = directDebitProcessorInformation;
        return this;
    }

    @Schema(description="Information about the bank that processes direct debits for the payment plan.")
    public DirectDebitProcessorInformation getDirectDebitProcessorInformation() {
        return this.directDebitProcessorInformation;
    }

    public void setDirectDebitProcessorInformation(DirectDebitProcessorInformation directDebitProcessorInformation) {
        this.directDebitProcessorInformation = directDebitProcessorInformation;
    }

    public NewAccountDefinition distributorCode(String distributorCode) {
        this.distributorCode = distributorCode;
        return this;
    }

    @Schema(description="The code that identifies the billing plan groups and plans for the new account.")
    public String getDistributorCode() {
        return this.distributorCode;
    }

    public void setDistributorCode(String distributorCode) {
        this.distributorCode = distributorCode;
    }

    public NewAccountDefinition distributorPassword(String distributorPassword) {
        this.distributorPassword = distributorPassword;
        return this;
    }

    @Schema(description="The password for the distributorCode.")
    public String getDistributorPassword() {
        return this.distributorPassword;
    }

    public void setDistributorPassword(String distributorPassword) {
        this.distributorPassword = distributorPassword;
    }

    public NewAccountDefinition enablePreAuth(String enablePreAuth) {
        this.enablePreAuth = enablePreAuth;
        return this;
    }

    @Schema(description="")
    public String getEnablePreAuth() {
        return this.enablePreAuth;
    }

    public void setEnablePreAuth(String enablePreAuth) {
        this.enablePreAuth = enablePreAuth;
    }

    public NewAccountDefinition envelopePartitionId(String envelopePartitionId) {
        this.envelopePartitionId = envelopePartitionId;
        return this;
    }

    @Schema(description="")
    public String getEnvelopePartitionId() {
        return this.envelopePartitionId;
    }

    public void setEnvelopePartitionId(String envelopePartitionId) {
        this.envelopePartitionId = envelopePartitionId;
    }

    public NewAccountDefinition initialUser(UserInformation initialUser) {
        this.initialUser = initialUser;
        return this;
    }

    @Schema(description="A complex type with the initial user information for the new account. Note that some user information is set internally based on the plan and cannot be overridden.")
    public UserInformation getInitialUser() {
        return this.initialUser;
    }

    public void setInitialUser(UserInformation initialUser) {
        this.initialUser = initialUser;
    }

    public NewAccountDefinition paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description="")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public NewAccountDefinition paymentProcessor(String paymentProcessor) {
        this.paymentProcessor = paymentProcessor;
        return this;
    }

    @Schema(description="")
    public String getPaymentProcessor() {
        return this.paymentProcessor;
    }

    public void setPaymentProcessor(String paymentProcessor) {
        this.paymentProcessor = paymentProcessor;
    }

    public NewAccountDefinition paymentProcessorInformation(PaymentProcessorInformation paymentProcessorInformation) {
        this.paymentProcessorInformation = paymentProcessorInformation;
        return this;
    }

    @Schema(description="Information about the entity that processes payments for the billing plan.")
    public PaymentProcessorInformation getPaymentProcessorInformation() {
        return this.paymentProcessorInformation;
    }

    public void setPaymentProcessorInformation(PaymentProcessorInformation paymentProcessorInformation) {
        this.paymentProcessorInformation = paymentProcessorInformation;
    }

    public NewAccountDefinition planInformation(PlanInformation planInformation) {
        this.planInformation = planInformation;
        return this;
    }

    @Schema(description="An object used to identify the features and attributes of the account being created.")
    public PlanInformation getPlanInformation() {
        return this.planInformation;
    }

    public void setPlanInformation(PlanInformation planInformation) {
        this.planInformation = planInformation;
    }

    public NewAccountDefinition processPayment(String processPayment) {
        this.processPayment = processPayment;
        return this;
    }

    @Schema(description="")
    public String getProcessPayment() {
        return this.processPayment;
    }

    public void setProcessPayment(String processPayment) {
        this.processPayment = processPayment;
    }

    public NewAccountDefinition referralInformation(ReferralInformation referralInformation) {
        this.referralInformation = referralInformation;
        return this;
    }

    @Schema(description="A complex type that contains properties for entering referral and discount information.")
    public ReferralInformation getReferralInformation() {
        return this.referralInformation;
    }

    public void setReferralInformation(ReferralInformation referralInformation) {
        this.referralInformation = referralInformation;
    }

    public NewAccountDefinition socialAccountInformation(SocialAccountInformation socialAccountInformation) {
        this.socialAccountInformation = socialAccountInformation;
        return this;
    }

    @Schema(description="Contains properties that map a DocuSign user to a social account (Facebook, Yahoo, etc.)")
    public SocialAccountInformation getSocialAccountInformation() {
        return this.socialAccountInformation;
    }

    public void setSocialAccountInformation(SocialAccountInformation socialAccountInformation) {
        this.socialAccountInformation = socialAccountInformation;
    }

    public NewAccountDefinition taxExemptId(String taxExemptId) {
        this.taxExemptId = taxExemptId;
        return this;
    }

    @Schema(description="")
    public String getTaxExemptId() {
        return this.taxExemptId;
    }

    public void setTaxExemptId(String taxExemptId) {
        this.taxExemptId = taxExemptId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewAccountDefinition newAccountDefinition = (NewAccountDefinition)o;
        return Objects.equals(this.accountName, newAccountDefinition.accountName) && Objects.equals(this.accountSettings, newAccountDefinition.accountSettings) && Objects.equals(this.addressInformation, newAccountDefinition.addressInformation) && Objects.equals(this.creditCardInformation, newAccountDefinition.creditCardInformation) && Objects.equals(this.directDebitProcessorInformation, newAccountDefinition.directDebitProcessorInformation) && Objects.equals(this.distributorCode, newAccountDefinition.distributorCode) && Objects.equals(this.distributorPassword, newAccountDefinition.distributorPassword) && Objects.equals(this.enablePreAuth, newAccountDefinition.enablePreAuth) && Objects.equals(this.envelopePartitionId, newAccountDefinition.envelopePartitionId) && Objects.equals(this.initialUser, newAccountDefinition.initialUser) && Objects.equals(this.paymentMethod, newAccountDefinition.paymentMethod) && Objects.equals(this.paymentProcessor, newAccountDefinition.paymentProcessor) && Objects.equals(this.paymentProcessorInformation, newAccountDefinition.paymentProcessorInformation) && Objects.equals(this.planInformation, newAccountDefinition.planInformation) && Objects.equals(this.processPayment, newAccountDefinition.processPayment) && Objects.equals(this.referralInformation, newAccountDefinition.referralInformation) && Objects.equals(this.socialAccountInformation, newAccountDefinition.socialAccountInformation) && Objects.equals(this.taxExemptId, newAccountDefinition.taxExemptId);
    }

    public int hashCode() {
        return Objects.hash(this.accountName, this.accountSettings, this.addressInformation, this.creditCardInformation, this.directDebitProcessorInformation, this.distributorCode, this.distributorPassword, this.enablePreAuth, this.envelopePartitionId, this.initialUser, this.paymentMethod, this.paymentProcessor, this.paymentProcessorInformation, this.planInformation, this.processPayment, this.referralInformation, this.socialAccountInformation, this.taxExemptId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewAccountDefinition {\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountSettings: ").append(this.toIndentedString(this.accountSettings)).append("\n");
        sb.append("    addressInformation: ").append(this.toIndentedString(this.addressInformation)).append("\n");
        sb.append("    creditCardInformation: ").append(this.toIndentedString(this.creditCardInformation)).append("\n");
        sb.append("    directDebitProcessorInformation: ").append(this.toIndentedString(this.directDebitProcessorInformation)).append("\n");
        sb.append("    distributorCode: ").append(this.toIndentedString(this.distributorCode)).append("\n");
        sb.append("    distributorPassword: ").append(this.toIndentedString(this.distributorPassword)).append("\n");
        sb.append("    enablePreAuth: ").append(this.toIndentedString(this.enablePreAuth)).append("\n");
        sb.append("    envelopePartitionId: ").append(this.toIndentedString(this.envelopePartitionId)).append("\n");
        sb.append("    initialUser: ").append(this.toIndentedString(this.initialUser)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    paymentProcessor: ").append(this.toIndentedString(this.paymentProcessor)).append("\n");
        sb.append("    paymentProcessorInformation: ").append(this.toIndentedString(this.paymentProcessorInformation)).append("\n");
        sb.append("    planInformation: ").append(this.toIndentedString(this.planInformation)).append("\n");
        sb.append("    processPayment: ").append(this.toIndentedString(this.processPayment)).append("\n");
        sb.append("    referralInformation: ").append(this.toIndentedString(this.referralInformation)).append("\n");
        sb.append("    socialAccountInformation: ").append(this.toIndentedString(this.socialAccountInformation)).append("\n");
        sb.append("    taxExemptId: ").append(this.toIndentedString(this.taxExemptId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

