/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="An array of email notifications that specifies the email the user receives when they are a sender. When the specific email notification is set to true, the user receives those types of email notifications from DocuSign. The user inherits the default account sender email notification settings when the user is created.")
public class SignerEmailNotifications {
    @JsonProperty(value="agentNotification")
    private String agentNotification = null;
    @JsonProperty(value="carbonCopyNotification")
    private String carbonCopyNotification = null;
    @JsonProperty(value="certifiedDeliveryNotification")
    private String certifiedDeliveryNotification = null;
    @JsonProperty(value="commentsOnlyPrivateAndMention")
    private String commentsOnlyPrivateAndMention = null;
    @JsonProperty(value="commentsReceiveAll")
    private String commentsReceiveAll = null;
    @JsonProperty(value="documentMarkupActivation")
    private String documentMarkupActivation = null;
    @JsonProperty(value="envelopeActivation")
    private String envelopeActivation = null;
    @JsonProperty(value="envelopeComplete")
    private String envelopeComplete = null;
    @JsonProperty(value="envelopeCorrected")
    private String envelopeCorrected = null;
    @JsonProperty(value="envelopeDeclined")
    private String envelopeDeclined = null;
    @JsonProperty(value="envelopeVoided")
    private String envelopeVoided = null;
    @JsonProperty(value="faxReceived")
    private String faxReceived = null;
    @JsonProperty(value="offlineSigningFailed")
    private String offlineSigningFailed = null;
    @JsonProperty(value="purgeDocuments")
    private String purgeDocuments = null;
    @JsonProperty(value="reassignedSigner")
    private String reassignedSigner = null;
    @JsonProperty(value="whenSigningGroupMember")
    private String whenSigningGroupMember = null;

    public SignerEmailNotifications agentNotification(String agentNotification) {
        this.agentNotification = agentNotification;
        return this;
    }

    @Schema(description="When set to **true**, the user receives agent notification emails.")
    public String getAgentNotification() {
        return this.agentNotification;
    }

    public void setAgentNotification(String agentNotification) {
        this.agentNotification = agentNotification;
    }

    public SignerEmailNotifications carbonCopyNotification(String carbonCopyNotification) {
        this.carbonCopyNotification = carbonCopyNotification;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notifications of carbon copy deliveries.")
    public String getCarbonCopyNotification() {
        return this.carbonCopyNotification;
    }

    public void setCarbonCopyNotification(String carbonCopyNotification) {
        this.carbonCopyNotification = carbonCopyNotification;
    }

    public SignerEmailNotifications certifiedDeliveryNotification(String certifiedDeliveryNotification) {
        this.certifiedDeliveryNotification = certifiedDeliveryNotification;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notifications of certified deliveries.")
    public String getCertifiedDeliveryNotification() {
        return this.certifiedDeliveryNotification;
    }

    public void setCertifiedDeliveryNotification(String certifiedDeliveryNotification) {
        this.certifiedDeliveryNotification = certifiedDeliveryNotification;
    }

    public SignerEmailNotifications commentsOnlyPrivateAndMention(String commentsOnlyPrivateAndMention) {
        this.commentsOnlyPrivateAndMention = commentsOnlyPrivateAndMention;
        return this;
    }

    @Schema(description="")
    public String getCommentsOnlyPrivateAndMention() {
        return this.commentsOnlyPrivateAndMention;
    }

    public void setCommentsOnlyPrivateAndMention(String commentsOnlyPrivateAndMention) {
        this.commentsOnlyPrivateAndMention = commentsOnlyPrivateAndMention;
    }

    public SignerEmailNotifications commentsReceiveAll(String commentsReceiveAll) {
        this.commentsReceiveAll = commentsReceiveAll;
        return this;
    }

    @Schema(description="")
    public String getCommentsReceiveAll() {
        return this.commentsReceiveAll;
    }

    public void setCommentsReceiveAll(String commentsReceiveAll) {
        this.commentsReceiveAll = commentsReceiveAll;
    }

    public SignerEmailNotifications documentMarkupActivation(String documentMarkupActivation) {
        this.documentMarkupActivation = documentMarkupActivation;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification that document markup has been activated.")
    public String getDocumentMarkupActivation() {
        return this.documentMarkupActivation;
    }

    public void setDocumentMarkupActivation(String documentMarkupActivation) {
        this.documentMarkupActivation = documentMarkupActivation;
    }

    public SignerEmailNotifications envelopeActivation(String envelopeActivation) {
        this.envelopeActivation = envelopeActivation;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification that the envelope has been activated.")
    public String getEnvelopeActivation() {
        return this.envelopeActivation;
    }

    public void setEnvelopeActivation(String envelopeActivation) {
        this.envelopeActivation = envelopeActivation;
    }

    public SignerEmailNotifications envelopeComplete(String envelopeComplete) {
        this.envelopeComplete = envelopeComplete;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification that the envelope has been completed.")
    public String getEnvelopeComplete() {
        return this.envelopeComplete;
    }

    public void setEnvelopeComplete(String envelopeComplete) {
        this.envelopeComplete = envelopeComplete;
    }

    public SignerEmailNotifications envelopeCorrected(String envelopeCorrected) {
        this.envelopeCorrected = envelopeCorrected;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification that the envelope has been corrected.")
    public String getEnvelopeCorrected() {
        return this.envelopeCorrected;
    }

    public void setEnvelopeCorrected(String envelopeCorrected) {
        this.envelopeCorrected = envelopeCorrected;
    }

    public SignerEmailNotifications envelopeDeclined(String envelopeDeclined) {
        this.envelopeDeclined = envelopeDeclined;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification that the envelope has been declined.")
    public String getEnvelopeDeclined() {
        return this.envelopeDeclined;
    }

    public void setEnvelopeDeclined(String envelopeDeclined) {
        this.envelopeDeclined = envelopeDeclined;
    }

    public SignerEmailNotifications envelopeVoided(String envelopeVoided) {
        this.envelopeVoided = envelopeVoided;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification that the envelope has been voided.")
    public String getEnvelopeVoided() {
        return this.envelopeVoided;
    }

    public void setEnvelopeVoided(String envelopeVoided) {
        this.envelopeVoided = envelopeVoided;
    }

    public SignerEmailNotifications faxReceived(String faxReceived) {
        this.faxReceived = faxReceived;
        return this;
    }

    @Schema(description="Reserved:")
    public String getFaxReceived() {
        return this.faxReceived;
    }

    public void setFaxReceived(String faxReceived) {
        this.faxReceived = faxReceived;
    }

    public SignerEmailNotifications offlineSigningFailed(String offlineSigningFailed) {
        this.offlineSigningFailed = offlineSigningFailed;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification if the offline signing failed.")
    public String getOfflineSigningFailed() {
        return this.offlineSigningFailed;
    }

    public void setOfflineSigningFailed(String offlineSigningFailed) {
        this.offlineSigningFailed = offlineSigningFailed;
    }

    public SignerEmailNotifications purgeDocuments(String purgeDocuments) {
        this.purgeDocuments = purgeDocuments;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification of document purges.")
    public String getPurgeDocuments() {
        return this.purgeDocuments;
    }

    public void setPurgeDocuments(String purgeDocuments) {
        this.purgeDocuments = purgeDocuments;
    }

    public SignerEmailNotifications reassignedSigner(String reassignedSigner) {
        this.reassignedSigner = reassignedSigner;
        return this;
    }

    @Schema(description="When set to **true**, the user receives notification that the envelope has been reassigned.")
    public String getReassignedSigner() {
        return this.reassignedSigner;
    }

    public void setReassignedSigner(String reassignedSigner) {
        this.reassignedSigner = reassignedSigner;
    }

    public SignerEmailNotifications whenSigningGroupMember(String whenSigningGroupMember) {
        this.whenSigningGroupMember = whenSigningGroupMember;
        return this;
    }

    @Schema(description="")
    public String getWhenSigningGroupMember() {
        return this.whenSigningGroupMember;
    }

    public void setWhenSigningGroupMember(String whenSigningGroupMember) {
        this.whenSigningGroupMember = whenSigningGroupMember;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignerEmailNotifications signerEmailNotifications = (SignerEmailNotifications)o;
        return Objects.equals(this.agentNotification, signerEmailNotifications.agentNotification) && Objects.equals(this.carbonCopyNotification, signerEmailNotifications.carbonCopyNotification) && Objects.equals(this.certifiedDeliveryNotification, signerEmailNotifications.certifiedDeliveryNotification) && Objects.equals(this.commentsOnlyPrivateAndMention, signerEmailNotifications.commentsOnlyPrivateAndMention) && Objects.equals(this.commentsReceiveAll, signerEmailNotifications.commentsReceiveAll) && Objects.equals(this.documentMarkupActivation, signerEmailNotifications.documentMarkupActivation) && Objects.equals(this.envelopeActivation, signerEmailNotifications.envelopeActivation) && Objects.equals(this.envelopeComplete, signerEmailNotifications.envelopeComplete) && Objects.equals(this.envelopeCorrected, signerEmailNotifications.envelopeCorrected) && Objects.equals(this.envelopeDeclined, signerEmailNotifications.envelopeDeclined) && Objects.equals(this.envelopeVoided, signerEmailNotifications.envelopeVoided) && Objects.equals(this.faxReceived, signerEmailNotifications.faxReceived) && Objects.equals(this.offlineSigningFailed, signerEmailNotifications.offlineSigningFailed) && Objects.equals(this.purgeDocuments, signerEmailNotifications.purgeDocuments) && Objects.equals(this.reassignedSigner, signerEmailNotifications.reassignedSigner) && Objects.equals(this.whenSigningGroupMember, signerEmailNotifications.whenSigningGroupMember);
    }

    public int hashCode() {
        return Objects.hash(this.agentNotification, this.carbonCopyNotification, this.certifiedDeliveryNotification, this.commentsOnlyPrivateAndMention, this.commentsReceiveAll, this.documentMarkupActivation, this.envelopeActivation, this.envelopeComplete, this.envelopeCorrected, this.envelopeDeclined, this.envelopeVoided, this.faxReceived, this.offlineSigningFailed, this.purgeDocuments, this.reassignedSigner, this.whenSigningGroupMember);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignerEmailNotifications {\n");
        sb.append("    agentNotification: ").append(this.toIndentedString(this.agentNotification)).append("\n");
        sb.append("    carbonCopyNotification: ").append(this.toIndentedString(this.carbonCopyNotification)).append("\n");
        sb.append("    certifiedDeliveryNotification: ").append(this.toIndentedString(this.certifiedDeliveryNotification)).append("\n");
        sb.append("    commentsOnlyPrivateAndMention: ").append(this.toIndentedString(this.commentsOnlyPrivateAndMention)).append("\n");
        sb.append("    commentsReceiveAll: ").append(this.toIndentedString(this.commentsReceiveAll)).append("\n");
        sb.append("    documentMarkupActivation: ").append(this.toIndentedString(this.documentMarkupActivation)).append("\n");
        sb.append("    envelopeActivation: ").append(this.toIndentedString(this.envelopeActivation)).append("\n");
        sb.append("    envelopeComplete: ").append(this.toIndentedString(this.envelopeComplete)).append("\n");
        sb.append("    envelopeCorrected: ").append(this.toIndentedString(this.envelopeCorrected)).append("\n");
        sb.append("    envelopeDeclined: ").append(this.toIndentedString(this.envelopeDeclined)).append("\n");
        sb.append("    envelopeVoided: ").append(this.toIndentedString(this.envelopeVoided)).append("\n");
        sb.append("    faxReceived: ").append(this.toIndentedString(this.faxReceived)).append("\n");
        sb.append("    offlineSigningFailed: ").append(this.toIndentedString(this.offlineSigningFailed)).append("\n");
        sb.append("    purgeDocuments: ").append(this.toIndentedString(this.purgeDocuments)).append("\n");
        sb.append("    reassignedSigner: ").append(this.toIndentedString(this.reassignedSigner)).append("\n");
        sb.append("    whenSigningGroupMember: ").append(this.toIndentedString(this.whenSigningGroupMember)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

