/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamcommon.MemberSpaceLimitType;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class TeamSpaceAllocation {
    protected final long used;
    protected final long allocated;
    protected final long userWithinTeamSpaceAllocated;
    protected final MemberSpaceLimitType userWithinTeamSpaceLimitType;

    public TeamSpaceAllocation(long used, long allocated, long userWithinTeamSpaceAllocated, MemberSpaceLimitType userWithinTeamSpaceLimitType) {
        this.used = used;
        this.allocated = allocated;
        this.userWithinTeamSpaceAllocated = userWithinTeamSpaceAllocated;
        if (userWithinTeamSpaceLimitType == null) {
            throw new IllegalArgumentException("Required value for 'userWithinTeamSpaceLimitType' is null");
        }
        this.userWithinTeamSpaceLimitType = userWithinTeamSpaceLimitType;
    }

    public long getUsed() {
        return this.used;
    }

    public long getAllocated() {
        return this.allocated;
    }

    public long getUserWithinTeamSpaceAllocated() {
        return this.userWithinTeamSpaceAllocated;
    }

    public MemberSpaceLimitType getUserWithinTeamSpaceLimitType() {
        return this.userWithinTeamSpaceLimitType;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.used, this.allocated, this.userWithinTeamSpaceAllocated, this.userWithinTeamSpaceLimitType});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamSpaceAllocation other = (TeamSpaceAllocation)obj;
            return this.used == other.used && this.allocated == other.allocated && this.userWithinTeamSpaceAllocated == other.userWithinTeamSpaceAllocated && (this.userWithinTeamSpaceLimitType == other.userWithinTeamSpaceLimitType || this.userWithinTeamSpaceLimitType.equals((Object)other.userWithinTeamSpaceLimitType));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamSpaceAllocation> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamSpaceAllocation value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("used");
            StoneSerializers.uInt64().serialize((Long)value.used, g);
            g.writeFieldName("allocated");
            StoneSerializers.uInt64().serialize((Long)value.allocated, g);
            g.writeFieldName("user_within_team_space_allocated");
            StoneSerializers.uInt64().serialize((Long)value.userWithinTeamSpaceAllocated, g);
            g.writeFieldName("user_within_team_space_limit_type");
            MemberSpaceLimitType.Serializer.INSTANCE.serialize(value.userWithinTeamSpaceLimitType, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamSpaceAllocation deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            MemberSpaceLimitType f_userWithinTeamSpaceLimitType;
            Long f_userWithinTeamSpaceAllocated;
            Long f_allocated;
            Long f_used;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_used = null;
                f_allocated = null;
                f_userWithinTeamSpaceAllocated = null;
                f_userWithinTeamSpaceLimitType = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("used".equals(field)) {
                        f_used = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("allocated".equals(field)) {
                        f_allocated = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("user_within_team_space_allocated".equals(field)) {
                        f_userWithinTeamSpaceAllocated = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    if ("user_within_team_space_limit_type".equals(field)) {
                        f_userWithinTeamSpaceLimitType = MemberSpaceLimitType.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_used == null) {
                    throw new JsonParseException(p, "Required field \"used\" missing.");
                }
                if (f_allocated == null) {
                    throw new JsonParseException(p, "Required field \"allocated\" missing.");
                }
                if (f_userWithinTeamSpaceAllocated == null) {
                    throw new JsonParseException(p, "Required field \"user_within_team_space_allocated\" missing.");
                }
                if (f_userWithinTeamSpaceLimitType == null) {
                    throw new JsonParseException(p, "Required field \"user_within_team_space_limit_type\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamSpaceAllocation value = new TeamSpaceAllocation(f_used, f_allocated, f_userWithinTeamSpaceAllocated, f_userWithinTeamSpaceLimitType);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

