/* DO NOT EDIT */
/* This file was generated from cloud_docs.stone */

package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;

public enum CloudDocsAccessError {
    // union cloud_docs.CloudDocsAccessError (cloud_docs.stone)
    /**
     * The Cloud Doc ID is invalid.
     */
    INVALID_DOC_ID,
    /**
     * A Cloud Doc could not be found for the given ID.
     */
    NOT_FOUND,
    /**
     * Permission denied for the Cloud Doc with the given ID.
     */
    PERMISSION_DENIED,
    /**
     * Catch-all used for unknown tag values returned by the Dropbox servers.
     *
     * <p> Receiving a catch-all value typically indicates this SDK version is
     * not up to date. Consider updating your SDK version to handle the new
     * tags. </p>
     */
    OTHER; // *catch_all

    /**
     * For internal use only.
     */
    static class Serializer extends UnionSerializer<CloudDocsAccessError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(CloudDocsAccessError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INVALID_DOC_ID: {
                    g.writeString("invalid_doc_id");
                    break;
                }
                case NOT_FOUND: {
                    g.writeString("not_found");
                    break;
                }
                case PERMISSION_DENIED: {
                    g.writeString("permission_denied");
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public CloudDocsAccessError deserialize(JsonParser p) throws IOException, JsonParseException {
            CloudDocsAccessError value;
            boolean collapsed;
            String tag;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = getStringValue(p);
                p.nextToken();
            }
            else {
                collapsed = false;
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: " + TAG_FIELD);
            }
            else if ("invalid_doc_id".equals(tag)) {
                value = CloudDocsAccessError.INVALID_DOC_ID;
            }
            else if ("not_found".equals(tag)) {
                value = CloudDocsAccessError.NOT_FOUND;
            }
            else if ("permission_denied".equals(tag)) {
                value = CloudDocsAccessError.PERMISSION_DENIED;
            }
            else {
                value = CloudDocsAccessError.OTHER;
            }
            if (!collapsed) {
                skipFields(p);
                expectEndObject(p);
            }
            return value;
        }
    }
}
