/* DO NOT EDIT */
/* This file was generated from cloud_docs.stone, cloud_docs_cloud_docs_public_api.stone, cloud_docs_cloud_docs_public_service.stone */

package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.DbxDownloader;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxUploader;
import com.dropbox.core.DbxWrappedException;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.v2.DbxDownloadStyleBuilder;
import com.dropbox.core.v2.DbxRawClientV2;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Routes in namespace "cloud_docs".
 */
public class DbxUserCloudDocsRequests {
    // namespace cloud_docs (cloud_docs.stone, cloud_docs_cloud_docs_public_api.stone, cloud_docs_cloud_docs_public_service.stone)

    private final DbxRawClientV2 client;

    public DbxUserCloudDocsRequests(DbxRawClientV2 client) {
        this.client = client;
    }

    //
    // route 2/cloud_docs/get_content
    //

    /**
     * Fetch the binary content of the requested document. This route requires
     * Cloud Docs auth. Please make a request to cloud_docs/authorize and supply
     * that token in the Authorization header.
     *
     * @param _headers  Extra headers to send with request.
     *
     * @return Downloader used to download the response body and view the server
     *     response.
     */
    DbxDownloader<Void> getContent(GetContentArg arg, List<HttpRequestor.Header> _headers) throws CloudDocsAccessErrorException, DbxException {
        try {
            return this.client.downloadStyle(this.client.getHost().getContent(),
                                             "2/cloud_docs/get_content",
                                             arg,
                                             false,
                                             _headers,
                                             GetContentArg.Serializer.INSTANCE,
                                             com.dropbox.core.stone.StoneSerializers.void_(),
                                             CloudDocsAccessError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new CloudDocsAccessErrorException("2/cloud_docs/get_content", ex.getRequestId(), ex.getUserMessage(), (CloudDocsAccessError) ex.getErrorValue());
        }
    }

    /**
     * Fetch the binary content of the requested document. This route requires
     * Cloud Docs auth. Please make a request to cloud_docs/authorize and supply
     * that token in the Authorization header.
     *
     * @param fileId  Must have length of at least 4, match pattern "{@code
     *     id:.+}", and not be {@code null}.
     *
     * @return Downloader used to download the response body and view the server
     *     response.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public DbxDownloader<Void> getContent(String fileId) throws CloudDocsAccessErrorException, DbxException {
        GetContentArg _arg = new GetContentArg(fileId);
        return getContent(_arg, Collections.<HttpRequestor.Header>emptyList());
    }

    /**
     * Fetch the binary content of the requested document. This route requires
     * Cloud Docs auth. Please make a request to cloud_docs/authorize and supply
     * that token in the Authorization header.
     *
     * @param fileId  Must have length of at least 4, match pattern "{@code
     *     id:.+}", and not be {@code null}.
     *
     * @return Downloader builder for configuring the request parameters and
     *     instantiating a downloader.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public GetContentBuilder getContentBuilder(String fileId) {
        return new GetContentBuilder(this, fileId);
    }

    //
    // route 2/cloud_docs/get_metadata
    //

    /**
     * Fetches metadata associated with a Cloud Doc and user. This route
     * requires Cloud Docs auth. Please make a request to cloud_docs/authorize
     * and supply that token in the Authorization header.
     *
     */
    GetMetadataResult getMetadata(GetMetadataArg arg) throws GetMetadataErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(),
                                        "2/cloud_docs/get_metadata",
                                        arg,
                                        false,
                                        GetMetadataArg.Serializer.INSTANCE,
                                        GetMetadataResult.Serializer.INSTANCE,
                                        GetMetadataError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new GetMetadataErrorException("2/cloud_docs/get_metadata", ex.getRequestId(), ex.getUserMessage(), (GetMetadataError) ex.getErrorValue());
        }
    }

    /**
     * Fetches metadata associated with a Cloud Doc and user. This route
     * requires Cloud Docs auth. Please make a request to cloud_docs/authorize
     * and supply that token in the Authorization header.
     *
     * <p> The {@code fileId} request parameter will default to {@code "\"\""}
     * (see {@link #getMetadata(String)}). </p>
     */
    public GetMetadataResult getMetadata() throws GetMetadataErrorException, DbxException {
        GetMetadataArg _arg = new GetMetadataArg();
        return getMetadata(_arg);
    }

    /**
     * Fetches metadata associated with a Cloud Doc and user. This route
     * requires Cloud Docs auth. Please make a request to cloud_docs/authorize
     * and supply that token in the Authorization header.
     *
     * @param fileId  API ID ("id:...") associated with the Cloud Doc. Must not
     *     be {@code null}.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public GetMetadataResult getMetadata(String fileId) throws GetMetadataErrorException, DbxException {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        GetMetadataArg _arg = new GetMetadataArg(fileId);
        return getMetadata(_arg);
    }

    //
    // route 2/cloud_docs/lock
    //

    /**
     * Lock a Cloud Doc. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     */
    LockResult lock(LockArg arg) throws LockingErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(),
                                        "2/cloud_docs/lock",
                                        arg,
                                        false,
                                        LockArg.Serializer.INSTANCE,
                                        LockResult.Serializer.INSTANCE,
                                        LockingError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new LockingErrorException("2/cloud_docs/lock", ex.getRequestId(), ex.getUserMessage(), (LockingError) ex.getErrorValue());
        }
    }

    /**
     * Lock a Cloud Doc. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     * <p> The {@code fileId} request parameter will default to {@code "\"\""}
     * (see {@link #lock(String)}). </p>
     */
    public LockResult lock() throws LockingErrorException, DbxException {
        LockArg _arg = new LockArg();
        return lock(_arg);
    }

    /**
     * Lock a Cloud Doc. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     * @param fileId  The API ID ("id:...") associated with the Cloud Doc. Must
     *     not be {@code null}.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public LockResult lock(String fileId) throws LockingErrorException, DbxException {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        LockArg _arg = new LockArg(fileId);
        return lock(_arg);
    }

    //
    // route 2/cloud_docs/rename
    //

    /**
     * Update the title of a Cloud Doc. This route requires Cloud Docs auth.
     * Please make a request to cloud_docs/authorize and supply that token in
     * the Authorization header.
     *
     */
    RenameResult rename(RenameArg arg) throws RenameErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(),
                                        "2/cloud_docs/rename",
                                        arg,
                                        false,
                                        RenameArg.Serializer.INSTANCE,
                                        RenameResult.Serializer.INSTANCE,
                                        RenameError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new RenameErrorException("2/cloud_docs/rename", ex.getRequestId(), ex.getUserMessage(), (RenameError) ex.getErrorValue());
        }
    }

    /**
     * Update the title of a Cloud Doc. This route requires Cloud Docs auth.
     * Please make a request to cloud_docs/authorize and supply that token in
     * the Authorization header.
     *
     * <p> The default values for the optional request parameters will be used.
     * See {@link RenameBuilder} for more details. </p>
     */
    public RenameResult rename() throws RenameErrorException, DbxException {
        RenameArg _arg = new RenameArg();
        return rename(_arg);
    }

    /**
     * Update the title of a Cloud Doc. This route requires Cloud Docs auth.
     * Please make a request to cloud_docs/authorize and supply that token in
     * the Authorization header.
     *
     * @return Request builder for configuring request parameters and completing
     *     the request.
     */
    public RenameBuilder renameBuilder() {
        RenameArg.Builder argBuilder_ = RenameArg.newBuilder();
        return new RenameBuilder(this, argBuilder_);
    }

    //
    // route 2/cloud_docs/unlock
    //

    /**
     * Unlock a Cloud Doc. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     *
     * @return Empty message for unlock
     */
    UnlockResult unlock(UnlockArg arg) throws LockingErrorException, DbxException {
        try {
            return this.client.rpcStyle(this.client.getHost().getApi(),
                                        "2/cloud_docs/unlock",
                                        arg,
                                        false,
                                        UnlockArg.Serializer.INSTANCE,
                                        UnlockResult.Serializer.INSTANCE,
                                        LockingError.Serializer.INSTANCE);
        }
        catch (DbxWrappedException ex) {
            throw new LockingErrorException("2/cloud_docs/unlock", ex.getRequestId(), ex.getUserMessage(), (LockingError) ex.getErrorValue());
        }
    }

    /**
     * Unlock a Cloud Doc. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     * <p> The {@code fileId} request parameter will default to {@code "\"\""}
     * (see {@link #unlock(String)}). </p>
     *
     * @return Empty message for unlock
     */
    public UnlockResult unlock() throws LockingErrorException, DbxException {
        UnlockArg _arg = new UnlockArg();
        return unlock(_arg);
    }

    /**
     * Unlock a Cloud Doc. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     * @param fileId  The API ID ("id:...") associated with the Cloud Doc. Must
     *     not be {@code null}.
     *
     * @return Empty message for unlock
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public UnlockResult unlock(String fileId) throws LockingErrorException, DbxException {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        UnlockArg _arg = new UnlockArg(fileId);
        return unlock(_arg);
    }

    //
    // route 2/cloud_docs/update_content
    //

    /**
     * Update the contents of a Cloud Doc. This should be called for files with
     * a max size of 150MB. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     *
     * @return Uploader used to upload the request body and finish request.
     */
    UpdateContentUploader updateContent(UpdateContentArg arg) throws DbxException {
        HttpRequestor.Uploader _uploader = this.client.uploadStyle(this.client.getHost().getContent(),
                                                                   "2/cloud_docs/update_content",
                                                                   arg,
                                                                   false,
                                                                   UpdateContentArg.Serializer.INSTANCE);
        return new UpdateContentUploader(_uploader, this.client.getUserId());
    }

    /**
     * Update the contents of a Cloud Doc. This should be called for files with
     * a max size of 150MB. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     * @param fileId  Must have length of at least 4, match pattern "{@code
     *     id:.+}", and not be {@code null}.
     * @param actorTokens  A list of auth_tokens, one for each editor who made
     *     changes to the document since the last call to update_content. Must
     *     not contain a {@code null} item and not be {@code null}.
     *
     * @return Uploader used to upload the request body and finish request.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public UpdateContentUploader updateContent(String fileId, List<String> actorTokens) throws DbxException {
        UpdateContentArg _arg = new UpdateContentArg(fileId, actorTokens);
        return updateContent(_arg);
    }

    /**
     * Update the contents of a Cloud Doc. This should be called for files with
     * a max size of 150MB. This route requires Cloud Docs auth. Please make a
     * request to cloud_docs/authorize and supply that token in the
     * Authorization header.
     *
     * @param fileId  Must have length of at least 4, match pattern "{@code
     *     id:.+}", and not be {@code null}.
     * @param actorTokens  A list of auth_tokens, one for each editor who made
     *     changes to the document since the last call to update_content. Must
     *     not contain a {@code null} item and not be {@code null}.
     * @param additionalContents  Currently, this will always be empty until we
     *     implement upload_additional_content. Must not contain a {@code null}
     *     item.
     *
     * @return Uploader used to upload the request body and finish request.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public UpdateContentUploader updateContent(String fileId, List<String> actorTokens, List<Content> additionalContents) throws DbxException {
        if (additionalContents != null) {
            for (Content x : additionalContents) {
                if (x == null) {
                    throw new IllegalArgumentException("An item in list 'additionalContents' is null");
                }
            }
        }
        UpdateContentArg _arg = new UpdateContentArg(fileId, actorTokens, additionalContents);
        return updateContent(_arg);
    }
}
