/* DO NOT EDIT */
/* This file was generated from cloud_docs.stone */

package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class UpdateContentArg {
    // struct cloud_docs.UpdateContentArg (cloud_docs.stone)

    protected final String fileId;
    protected final List<String> actorTokens;
    protected final List<Content> additionalContents;

    /**
     *
     * @param fileId  Must have length of at least 4, match pattern "{@code
     *     id:.+}", and not be {@code null}.
     * @param actorTokens  A list of auth_tokens, one for each editor who made
     *     changes to the document since the last call to update_content. Must
     *     not contain a {@code null} item and not be {@code null}.
     * @param additionalContents  Currently, this will always be empty until we
     *     implement upload_additional_content. Must not contain a {@code null}
     *     item.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public UpdateContentArg(String fileId, List<String> actorTokens, List<Content> additionalContents) {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        if (fileId.length() < 4) {
            throw new IllegalArgumentException("String 'fileId' is shorter than 4");
        }
        if (!Pattern.matches("id:.+", fileId)) {
            throw new IllegalArgumentException("String 'fileId' does not match pattern");
        }
        this.fileId = fileId;
        if (actorTokens == null) {
            throw new IllegalArgumentException("Required value for 'actorTokens' is null");
        }
        for (String x : actorTokens) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'actorTokens' is null");
            }
        }
        this.actorTokens = actorTokens;
        if (additionalContents != null) {
            for (Content x : additionalContents) {
                if (x == null) {
                    throw new IllegalArgumentException("An item in list 'additionalContents' is null");
                }
            }
        }
        this.additionalContents = additionalContents;
    }

    /**
     * None
     *
     * <p> The default values for unset fields will be used. </p>
     *
     * @param fileId  Must have length of at least 4, match pattern "{@code
     *     id:.+}", and not be {@code null}.
     * @param actorTokens  A list of auth_tokens, one for each editor who made
     *     changes to the document since the last call to update_content. Must
     *     not contain a {@code null} item and not be {@code null}.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public UpdateContentArg(String fileId, List<String> actorTokens) {
        this(fileId, actorTokens, null);
    }

    /**
     *
     * @return value for this field, never {@code null}.
     */
    public String getFileId() {
        return fileId;
    }

    /**
     * A list of auth_tokens, one for each editor who made changes to the
     * document since the last call to update_content.
     *
     * @return value for this field, never {@code null}.
     */
    public List<String> getActorTokens() {
        return actorTokens;
    }

    /**
     * Currently, this will always be empty until we implement
     * upload_additional_content.
     *
     * @return value for this field, or {@code null} if not present.
     */
    public List<Content> getAdditionalContents() {
        return additionalContents;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object [] {
            fileId,
            actorTokens,
            additionalContents
        });
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        // be careful with inheritance
        else if (obj.getClass().equals(this.getClass())) {
            UpdateContentArg other = (UpdateContentArg) obj;
            return ((this.fileId == other.fileId) || (this.fileId.equals(other.fileId)))
                && ((this.actorTokens == other.actorTokens) || (this.actorTokens.equals(other.actorTokens)))
                && ((this.additionalContents == other.additionalContents) || (this.additionalContents != null && this.additionalContents.equals(other.additionalContents)))
                ;
        }
        else {
            return false;
        }
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    /**
     * Returns a String representation of this object formatted for easier
     * readability.
     *
     * <p> The returned String may contain newlines. </p>
     *
     * @return Formatted, multiline String representation of this object
     */
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    /**
     * For internal use only.
     */
    static class Serializer extends StructSerializer<UpdateContentArg> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(UpdateContentArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("file_id");
            StoneSerializers.string().serialize(value.fileId, g);
            g.writeFieldName("actor_tokens");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.actorTokens, g);
            if (value.additionalContents != null) {
                g.writeFieldName("additional_contents");
                StoneSerializers.nullable(StoneSerializers.list(Content.Serializer.INSTANCE)).serialize(value.additionalContents, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UpdateContentArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            UpdateContentArg value;
            String tag = null;
            if (!collapsed) {
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                String f_fileId = null;
                List<String> f_actorTokens = null;
                List<Content> f_additionalContents = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.string().deserialize(p);
                    }
                    else if ("actor_tokens".equals(field)) {
                        f_actorTokens = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                    }
                    else if ("additional_contents".equals(field)) {
                        f_additionalContents = StoneSerializers.nullable(StoneSerializers.list(Content.Serializer.INSTANCE)).deserialize(p);
                    }
                    else {
                        skipValue(p);
                    }
                }
                if (f_fileId == null) {
                    throw new JsonParseException(p, "Required field \"file_id\" missing.");
                }
                if (f_actorTokens == null) {
                    throw new JsonParseException(p, "Required field \"actor_tokens\" missing.");
                }
                value = new UpdateContentArg(f_fileId, f_actorTokens, f_additionalContents);
            }
            else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}
