/* DO NOT EDIT */
/* This file was generated from cloud_docs.stone */

package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;

public enum UpdateContentError {
    // union cloud_docs.UpdateContentError (cloud_docs.stone)
    /**
     * The Cloud Doc ID is invalid.
     */
    INVALID_DOC_ID,
    /**
     * A Cloud Doc could not be found for the given ID.
     */
    NOT_FOUND,
    /**
     * Permission denied for the Cloud Doc with the given ID.
     */
    PERMISSION_DENIED,
    /**
     * Catch-all used for unknown tag values returned by the Dropbox servers.
     *
     * <p> Receiving a catch-all value typically indicates this SDK version is
     * not up to date. Consider updating your SDK version to handle the new
     * tags. </p>
     */
    OTHER,
    /**
     * Upload payload exceeds maximum allowed size of 150MB.
     */
    UPLOAD_SIZE_TOO_LARGE,
    /**
     * A lock on the document identified by path_or_id is held by another
     * editor.
     */
    CONFLICT,
    /**
     * A lock is not held on the document identified by path_or_id. Acquire lock
     * before uploading content for the document.
     */
    UNLOCKED;

    /**
     * For internal use only.
     */
    static class Serializer extends UnionSerializer<UpdateContentError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(UpdateContentError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value) {
                case INVALID_DOC_ID: {
                    g.writeString("invalid_doc_id");
                    break;
                }
                case NOT_FOUND: {
                    g.writeString("not_found");
                    break;
                }
                case PERMISSION_DENIED: {
                    g.writeString("permission_denied");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case UPLOAD_SIZE_TOO_LARGE: {
                    g.writeString("upload_size_too_large");
                    break;
                }
                case CONFLICT: {
                    g.writeString("conflict");
                    break;
                }
                case UNLOCKED: {
                    g.writeString("unlocked");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + value);
                }
            }
        }

        @Override
        public UpdateContentError deserialize(JsonParser p) throws IOException, JsonParseException {
            UpdateContentError value;
            boolean collapsed;
            String tag;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = getStringValue(p);
                p.nextToken();
            }
            else {
                collapsed = false;
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: " + TAG_FIELD);
            }
            else if ("invalid_doc_id".equals(tag)) {
                value = UpdateContentError.INVALID_DOC_ID;
            }
            else if ("not_found".equals(tag)) {
                value = UpdateContentError.NOT_FOUND;
            }
            else if ("permission_denied".equals(tag)) {
                value = UpdateContentError.PERMISSION_DENIED;
            }
            else if ("other".equals(tag)) {
                value = UpdateContentError.OTHER;
            }
            else if ("upload_size_too_large".equals(tag)) {
                value = UpdateContentError.UPLOAD_SIZE_TOO_LARGE;
            }
            else if ("conflict".equals(tag)) {
                value = UpdateContentError.CONFLICT;
            }
            else if ("unlocked".equals(tag)) {
                value = UpdateContentError.UNLOCKED;
            }
            else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                skipFields(p);
                expectEndObject(p);
            }
            return value;
        }
    }
}
