/* DO NOT EDIT */
/* This file was generated from cloud_docs_cloud_docs_public_api.stone */

package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;

public class UserPermissions {
    // struct cloud_docs.UserPermissions (cloud_docs_cloud_docs_public_api.stone)

    protected final boolean canEdit;
    protected final boolean canRename;
    protected final boolean canComment;
    protected final boolean canDownload;

    /**
     * Use {@link newBuilder} to create instances of this class without
     * specifying values for all optional fields.
     *
     * @param canEdit  true if the user can edit the content of this document.
     * @param canRename  true if the user can edit the title of this document.
     * @param canComment  true if the user can comment on this document.
     * @param canDownload  true if the user can download the contents of this
     *     document. currently always true if the user has view access to the
     *     document.
     */
    public UserPermissions(boolean canEdit, boolean canRename, boolean canComment, boolean canDownload) {
        this.canEdit = canEdit;
        this.canRename = canRename;
        this.canComment = canComment;
        this.canDownload = canDownload;
    }

    /**
     * None
     *
     * <p> The default values for unset fields will be used. </p>
     */
    public UserPermissions() {
        this(false, false, false, false);
    }

    /**
     * true if the user can edit the content of this document
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     false.
     */
    public boolean getCanEdit() {
        return canEdit;
    }

    /**
     * true if the user can edit the title of this document
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     false.
     */
    public boolean getCanRename() {
        return canRename;
    }

    /**
     * true if the user can comment on this document
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     false.
     */
    public boolean getCanComment() {
        return canComment;
    }

    /**
     * true if the user can download the contents of this document. currently
     * always true if the user has view access to the document.
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     false.
     */
    public boolean getCanDownload() {
        return canDownload;
    }

    /**
     * Returns a new builder for creating an instance of this class.
     *
     * @return builder for this class.
     */
    public static Builder newBuilder() {
        return new Builder();
    }

    /**
     * Builder for {@link UserPermissions}.
     */
    public static class Builder {

        protected boolean canEdit;
        protected boolean canRename;
        protected boolean canComment;
        protected boolean canDownload;

        protected Builder() {
            this.canEdit = false;
            this.canRename = false;
            this.canComment = false;
            this.canDownload = false;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code false}.
         * </p>
         *
         * @param canEdit  true if the user can edit the content of this
         *     document. Defaults to {@code false} when set to {@code null}.
         *
         * @return this builder
         */
        public Builder withCanEdit(Boolean canEdit) {
            if (canEdit != null) {
                this.canEdit = canEdit;
            }
            else {
                this.canEdit = false;
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code false}.
         * </p>
         *
         * @param canRename  true if the user can edit the title of this
         *     document. Defaults to {@code false} when set to {@code null}.
         *
         * @return this builder
         */
        public Builder withCanRename(Boolean canRename) {
            if (canRename != null) {
                this.canRename = canRename;
            }
            else {
                this.canRename = false;
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code false}.
         * </p>
         *
         * @param canComment  true if the user can comment on this document.
         *     Defaults to {@code false} when set to {@code null}.
         *
         * @return this builder
         */
        public Builder withCanComment(Boolean canComment) {
            if (canComment != null) {
                this.canComment = canComment;
            }
            else {
                this.canComment = false;
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code false}.
         * </p>
         *
         * @param canDownload  true if the user can download the contents of
         *     this document. currently always true if the user has view access
         *     to the document. Defaults to {@code false} when set to {@code
         *     null}.
         *
         * @return this builder
         */
        public Builder withCanDownload(Boolean canDownload) {
            if (canDownload != null) {
                this.canDownload = canDownload;
            }
            else {
                this.canDownload = false;
            }
            return this;
        }

        /**
         * Builds an instance of {@link UserPermissions} configured with this
         * builder's values
         *
         * @return new instance of {@link UserPermissions}
         */
        public UserPermissions build() {
            return new UserPermissions(canEdit, canRename, canComment, canDownload);
        }
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object [] {
            canEdit,
            canRename,
            canComment,
            canDownload
        });
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        // be careful with inheritance
        else if (obj.getClass().equals(this.getClass())) {
            UserPermissions other = (UserPermissions) obj;
            return (this.canEdit == other.canEdit)
                && (this.canRename == other.canRename)
                && (this.canComment == other.canComment)
                && (this.canDownload == other.canDownload)
                ;
        }
        else {
            return false;
        }
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    /**
     * Returns a String representation of this object formatted for easier
     * readability.
     *
     * <p> The returned String may contain newlines. </p>
     *
     * @return Formatted, multiline String representation of this object
     */
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    /**
     * For internal use only.
     */
    static class Serializer extends StructSerializer<UserPermissions> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(UserPermissions value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("can_edit");
            StoneSerializers.boolean_().serialize(value.canEdit, g);
            g.writeFieldName("can_rename");
            StoneSerializers.boolean_().serialize(value.canRename, g);
            g.writeFieldName("can_comment");
            StoneSerializers.boolean_().serialize(value.canComment, g);
            g.writeFieldName("can_download");
            StoneSerializers.boolean_().serialize(value.canDownload, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UserPermissions deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            UserPermissions value;
            String tag = null;
            if (!collapsed) {
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                Boolean f_canEdit = false;
                Boolean f_canRename = false;
                Boolean f_canComment = false;
                Boolean f_canDownload = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("can_edit".equals(field)) {
                        f_canEdit = StoneSerializers.boolean_().deserialize(p);
                    }
                    else if ("can_rename".equals(field)) {
                        f_canRename = StoneSerializers.boolean_().deserialize(p);
                    }
                    else if ("can_comment".equals(field)) {
                        f_canComment = StoneSerializers.boolean_().deserialize(p);
                    }
                    else if ("can_download".equals(field)) {
                        f_canDownload = StoneSerializers.boolean_().deserialize(p);
                    }
                    else {
                        skipValue(p);
                    }
                }
                value = new UserPermissions(f_canEdit, f_canRename, f_canComment, f_canDownload);
            }
            else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}
