/* DO NOT EDIT */
/* This file was generated by Stone */

package com.dropbox.core.v2.paper;

import com.dropbox.core.DbxApiException;
import com.dropbox.core.DbxException;

/**
 * The request builder returned by {@link DbxUserPaperRequests#docsListBuilder}.
 *
 * <p> Use this class to set optional request parameters and complete the
 * request. </p>
 */
public class DocsListBuilder {
    private final DbxUserPaperRequests _client;
    private final ListPaperDocsArgs.Builder _builder;

    /**
     * Creates a new instance of this builder.
     *
     * @param _client  Dropbox namespace-specific client used to issue paper
     *     requests.
     * @param _builder  Request argument builder.
     *
     * @return instsance of this builder
     */
    DocsListBuilder(DbxUserPaperRequests _client, ListPaperDocsArgs.Builder _builder) {
        if (_client == null) {
            throw new NullPointerException("_client");
        }
        this._client = _client;
        if (_builder == null) {
            throw new NullPointerException("_builder");
        }
        this._builder = _builder;
    }

    /**
     * Set value for optional field.
     *
     * <p> If left unset or set to {@code null}, defaults to {@code
     * ListPaperDocsFilterBy.DOCS_ACCESSED}. </p>
     *
     * @param filterBy  Allows user to specify how the Paper docs should be
     *     filtered. Must not be {@code null}. Defaults to {@code
     *     ListPaperDocsFilterBy.DOCS_ACCESSED} when set to {@code null}.
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public DocsListBuilder withFilterBy(ListPaperDocsFilterBy filterBy) {
        this._builder.withFilterBy(filterBy);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * <p> If left unset or set to {@code null}, defaults to {@code
     * ListPaperDocsSortBy.ACCESSED}. </p>
     *
     * @param sortBy  Allows user to specify how the Paper docs should be
     *     sorted. Must not be {@code null}. Defaults to {@code
     *     ListPaperDocsSortBy.ACCESSED} when set to {@code null}.
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public DocsListBuilder withSortBy(ListPaperDocsSortBy sortBy) {
        this._builder.withSortBy(sortBy);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * <p> If left unset or set to {@code null}, defaults to {@code
     * ListPaperDocsSortOrder.ASCENDING}. </p>
     *
     * @param sortOrder  Allows user to specify the sort order of the result.
     *     Must not be {@code null}. Defaults to {@code
     *     ListPaperDocsSortOrder.ASCENDING} when set to {@code null}.
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public DocsListBuilder withSortOrder(ListPaperDocsSortOrder sortOrder) {
        this._builder.withSortOrder(sortOrder);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * <p> If left unset or set to {@code null}, defaults to {@code 1000}. </p>
     *
     * @param limit  Size limit per batch. The maximum number of docs that can
     *     be retrieved per batch is 1000. Higher value results in invalid
     *     arguments error. Must be greater than or equal to 1 and be less than
     *     or equal to 1000. Defaults to {@code 1000} when set to {@code null}.
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public DocsListBuilder withLimit(Integer limit) {
        this._builder.withLimit(limit);
        return this;
    }

    /**
     * Issues the request.
     */
    @SuppressWarnings("deprecation")
    public ListPaperDocsResponse start() throws DbxApiException, DbxException {
        ListPaperDocsArgs arg_ = this._builder.build();
        return _client.docsList(arg_);
    }
}
