/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.CodePoints;

final class MetricKeyValidator {
    private MetricKeyValidator() {
    }

    static boolean isValidFirstSectionStartCharacter(int codePoint) {
        return codePoint >= CodePoints.A_LOWERCASE && codePoint <= CodePoints.Z_LOWERCASE || codePoint >= CodePoints.A_UPPERCASE && codePoint <= CodePoints.Z_UPPERCASE || codePoint == CodePoints.UNDERSCORE;
    }

    static boolean isValidConsecutiveSectionStartCharacter(int codePoint) {
        return MetricKeyValidator.isValidFirstSectionStartCharacter(codePoint) || MetricKeyValidator.isNumber(codePoint);
    }

    static boolean isValidSection(int codePoint) {
        return MetricKeyValidator.isValidConsecutiveSectionStartCharacter(codePoint) || MetricKeyValidator.isSpecialCharacter(codePoint);
    }

    static boolean isSectionSeparator(int codePoint) {
        return codePoint == CodePoints.DOT;
    }

    static boolean normalizationRequired(String key) {
        int codePoint;
        if (key == null || key.isEmpty()) {
            return true;
        }
        int length = key.length();
        if (length > 250) {
            return true;
        }
        State state = State.START;
        block5: for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = key.codePointAt(offset);
            switch (state) {
                case START: {
                    if (!MetricKeyValidator.isValidFirstSectionStartCharacter(codePoint)) {
                        return true;
                    }
                    state = State.SECTION;
                    continue block5;
                }
                case CONSECUTIVE_SECTION_START: {
                    if (!MetricKeyValidator.isValidConsecutiveSectionStartCharacter(codePoint)) {
                        return true;
                    }
                    state = State.SECTION;
                    continue block5;
                }
                case SECTION: {
                    if (MetricKeyValidator.isSectionSeparator(codePoint)) {
                        if (offset + Character.charCount(codePoint) == length) {
                            return true;
                        }
                        state = State.CONSECUTIVE_SECTION_START;
                        continue block5;
                    }
                    if (MetricKeyValidator.isValidSection(codePoint)) continue block5;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isNumber(int codePoint) {
        return codePoint >= CodePoints.ZERO && codePoint <= CodePoints.NINE;
    }

    private static boolean isSpecialCharacter(int codePoint) {
        return codePoint == CodePoints.HYPHEN || codePoint == CodePoints.UNDERSCORE;
    }

    static enum State {
        START,
        CONSECUTIVE_SECTION_START,
        SECTION;

    }
}

