/*
 * Decompiled with CFR 0.152.
 */
package com.dynatrace.metric.util;

import com.dynatrace.metric.util.CodePoints;
import com.dynatrace.metric.util.DimensionKeyValidator;
import com.dynatrace.metric.util.MetricKeyValidator;
import com.dynatrace.metric.util.NormalizationResult;
import com.dynatrace.metric.util.StringValueValidator;

final class Normalizer {
    private Normalizer() {
    }

    static String doubleToString(double value) {
        if (value == (double)((long)value)) {
            return Long.toString((long)value);
        }
        return Double.toString(value);
    }

    static NormalizationResult normalizeMetricKey(String key) {
        int codePoint;
        if (StringValueValidator.isNullOrEmpty(key)) {
            return NormalizationResult.newInvalid();
        }
        int length = key.length();
        boolean needsToTruncate = length > 250;
        int effectiveLength = needsToTruncate ? 250 : length;
        boolean previousCodePointSanitized = false;
        int invalidCharsEncountered = 0;
        StringBuilder sb = new StringBuilder(effectiveLength);
        MetricKeyValidator.State state = MetricKeyValidator.State.START;
        block5: for (int offset = 0; offset < effectiveLength; offset += Character.charCount(codePoint)) {
            codePoint = key.codePointAt(offset);
            switch (state) {
                case START: {
                    if (MetricKeyValidator.isSectionSeparator(codePoint) && offset == 0) {
                        return NormalizationResult.newInvalid();
                    }
                    if (MetricKeyValidator.isValidFirstSectionStartCharacter(codePoint)) {
                        sb.appendCodePoint(codePoint);
                    } else {
                        sb.appendCodePoint(CodePoints.UNDERSCORE);
                        previousCodePointSanitized = true;
                        ++invalidCharsEncountered;
                    }
                    state = MetricKeyValidator.State.SECTION;
                    continue block5;
                }
                case CONSECUTIVE_SECTION_START: {
                    if (MetricKeyValidator.isSectionSeparator(codePoint)) {
                        ++invalidCharsEncountered;
                        continue block5;
                    }
                    sb.appendCodePoint(CodePoints.DOT);
                    if (MetricKeyValidator.isValidConsecutiveSectionStartCharacter(codePoint)) {
                        sb.appendCodePoint(codePoint);
                        previousCodePointSanitized = false;
                    } else {
                        previousCodePointSanitized = true;
                        ++invalidCharsEncountered;
                        sb.appendCodePoint(CodePoints.UNDERSCORE);
                    }
                    state = MetricKeyValidator.State.SECTION;
                    continue block5;
                }
                case SECTION: {
                    if (MetricKeyValidator.isSectionSeparator(codePoint)) {
                        if (offset + Character.charCount(codePoint) == effectiveLength) {
                            ++invalidCharsEncountered;
                            continue block5;
                        }
                        previousCodePointSanitized = false;
                        state = MetricKeyValidator.State.CONSECUTIVE_SECTION_START;
                        continue block5;
                    }
                    if (MetricKeyValidator.isValidSection(codePoint)) {
                        sb.appendCodePoint(codePoint);
                        previousCodePointSanitized = false;
                        continue block5;
                    }
                    if (!previousCodePointSanitized) {
                        sb.appendCodePoint(CodePoints.UNDERSCORE);
                        previousCodePointSanitized = true;
                    }
                    ++invalidCharsEncountered;
                }
            }
        }
        String normalizedMetricKey = sb.toString();
        if (invalidCharsEncountered > 0 || needsToTruncate) {
            return NormalizationResult.newWarning(normalizedMetricKey, () -> String.format("Metric key normalized from '%s' to '%s'", key, normalizedMetricKey));
        }
        return NormalizationResult.newValid(normalizedMetricKey);
    }

    static NormalizationResult normalizeDimensionKey(String key) {
        int codePoint;
        if (StringValueValidator.isNullOrEmpty(key)) {
            return NormalizationResult.newValid(null);
        }
        int length = key.length();
        boolean needsToTruncate = length > 100;
        int effectiveLength = needsToTruncate ? 100 : length;
        boolean previousCodePointSanitized = false;
        int invalidCharsEncountered = 0;
        StringBuilder sb = new StringBuilder(effectiveLength);
        DimensionKeyValidator.State state = DimensionKeyValidator.State.START;
        block4: for (int offset = 0; offset < effectiveLength; offset += Character.charCount(codePoint)) {
            codePoint = Character.toLowerCase(key.codePointAt(offset));
            switch (state) {
                case START: {
                    if (DimensionKeyValidator.isSectionSeparator(codePoint)) {
                        ++invalidCharsEncountered;
                        continue block4;
                    }
                    if (sb.length() != 0) {
                        sb.appendCodePoint(CodePoints.DOT);
                    }
                    if (DimensionKeyValidator.isValidFirstSectionStartCharacter(codePoint)) {
                        sb.appendCodePoint(codePoint);
                        previousCodePointSanitized = false;
                    } else {
                        sb.appendCodePoint(CodePoints.UNDERSCORE);
                        previousCodePointSanitized = true;
                        ++invalidCharsEncountered;
                    }
                    state = DimensionKeyValidator.State.SECTION;
                    continue block4;
                }
                case SECTION: {
                    if (DimensionKeyValidator.isSectionSeparator(codePoint)) {
                        if (offset + Character.charCount(codePoint) == effectiveLength) {
                            ++invalidCharsEncountered;
                            continue block4;
                        }
                        previousCodePointSanitized = false;
                        state = DimensionKeyValidator.State.START;
                        continue block4;
                    }
                    if (DimensionKeyValidator.isValidSection(codePoint)) {
                        sb.appendCodePoint(codePoint);
                        previousCodePointSanitized = false;
                        continue block4;
                    }
                    if (!previousCodePointSanitized) {
                        sb.appendCodePoint(CodePoints.UNDERSCORE);
                        previousCodePointSanitized = true;
                    }
                    ++invalidCharsEncountered;
                }
            }
        }
        if (sb.length() == 0) {
            return NormalizationResult.newInvalid(() -> String.format("Dimension key normalized from '%s' to '%s'", key, ""));
        }
        String normalizedDimKey = sb.toString();
        if (invalidCharsEncountered > 0 || needsToTruncate) {
            return NormalizationResult.newWarning(normalizedDimKey, () -> String.format("Dimension key normalized from '%s' to '%s'", key, normalizedDimKey));
        }
        return NormalizationResult.newValid(normalizedDimKey);
    }

    static NormalizationResult normalizeDimensionValue(String value, int maxDimensionValueLength) {
        boolean isQuoted;
        if (StringValueValidator.isNullOrEmpty(value)) {
            return NormalizationResult.newValid("");
        }
        boolean bl = isQuoted = value.startsWith("\"") && value.endsWith("\"");
        if (isQuoted) {
            return Normalizer.normalizeQuotedDimValue(value, maxDimensionValueLength);
        }
        return Normalizer.normalizeUnquotedStringDimValue(value, maxDimensionValueLength);
    }

    static NormalizationResult normalizeMetadataString(String value, int maxLength) {
        int codePointLength;
        int codePointLength2;
        if (StringValueValidator.isNullOrEmpty(value)) {
            return NormalizationResult.newValid("");
        }
        boolean isQuoted = value.startsWith("\"") && value.endsWith("\"");
        int numValidBytes = 0;
        boolean needsNormalization = false;
        boolean needsEscaping = false;
        int start = isQuoted ? 1 : 0;
        int end = isQuoted ? value.length() - 1 : value.length();
        for (int i = start; i < end; i += codePointLength2) {
            int codePoint = value.codePointAt(i);
            codePointLength2 = Character.charCount(codePoint);
            if (Normalizer.codePointNeedsEscaping(codePoint)) {
                needsEscaping = true;
            }
            if (Normalizer.codePointNeedsNormalizing(codePoint)) {
                needsNormalization = true;
                continue;
            }
            if ((numValidBytes += codePointLength2) <= maxLength) continue;
            needsNormalization = true;
            break;
        }
        if (!needsNormalization) {
            if (isQuoted || !needsEscaping) {
                return NormalizationResult.newValid(value);
            }
            return NormalizationResult.newValid("\"" + value + "\"");
        }
        StringBuilder builder = new StringBuilder(numValidBytes + 2);
        builder.append("\"");
        Object warningMessageSupplier = null;
        for (int i = start; i < end; i += codePointLength) {
            int codePoint = value.codePointAt(i);
            codePointLength = Character.charCount(codePoint);
            if (codePoint == CodePoints.NEWLINE) {
                if (i + "\\n".length() > maxLength) break;
                builder.append("\\n");
                continue;
            }
            if (codePoint == CodePoints.QUOTE) {
                if (i + "\\\"".length() > maxLength) break;
                builder.append("\\\"");
                continue;
            }
            if (Normalizer.codePointNeedsNormalizing(codePoint)) continue;
            if (i + codePointLength > maxLength) break;
            builder.appendCodePoint(codePoint);
        }
        builder.append("\"");
        String normalized = builder.toString();
        if (normalized.length() == 2) {
            return NormalizationResult.newInvalid(() -> "no valid characters after normalization (input: " + value + ")");
        }
        return NormalizationResult.newWarning(normalized, () -> String.format("Metadata value normalized from '%s' to '%s'", value, normalized));
    }

    private static boolean codePointNeedsEscaping(int codePoint) {
        return codePoint == CodePoints.NEWLINE || codePoint == CodePoints.BLANK || codePoint == CodePoints.COMMA || codePoint == CodePoints.EQUALS || codePoint == CodePoints.QUOTE || codePoint == CodePoints.BACKSLASH;
    }

    private static boolean codePointNeedsNormalizing(int codePoint) {
        int type = Character.getType(codePoint);
        if (type == 0) {
            return codePoint <= 129280 || codePoint >= 129535;
        }
        return type == 15 || type == 18 || type == 19 || type == 13 || type == 14 || codePoint == CodePoints.QUOTE;
    }

    private static NormalizationResult normalizeUnquotedStringDimValue(String value, int maxDimensionValueLength) {
        if (!StringValueValidator.normalizationRequiredUnqoutedStringValue(value, maxDimensionValueLength)) {
            return NormalizationResult.newValid(value);
        }
        StringBuilder sb = new StringBuilder();
        int length = value.length();
        boolean previousCodePointSanitized = false;
        int invalidCharsEncountered = 0;
        boolean wasTruncated = false;
        int offset = 0;
        while (offset < length) {
            int codePoint = value.codePointAt(offset);
            if (StringValueValidator.isInvalidCodePoint(codePoint)) {
                if (previousCodePointSanitized) {
                    offset += Character.charCount(codePoint);
                    continue;
                }
                if (!StringValueValidator.canAppendToValue(sb.length(), CodePoints.UNDERSCORE, false, false, maxDimensionValueLength)) {
                    wasTruncated = true;
                    break;
                }
                sb.appendCodePoint(CodePoints.UNDERSCORE);
                previousCodePointSanitized = true;
                ++invalidCharsEncountered;
            } else {
                boolean shouldEscape = StringValueValidator.shouldEscapeString(codePoint);
                boolean canAppend = StringValueValidator.canAppendToValue(sb.length(), codePoint, false, shouldEscape, maxDimensionValueLength);
                if (!canAppend) {
                    wasTruncated = true;
                    break;
                }
                if (shouldEscape) {
                    sb.appendCodePoint(CodePoints.BACKSLASH).appendCodePoint(codePoint);
                } else {
                    sb.appendCodePoint(codePoint);
                }
                previousCodePointSanitized = false;
            }
            offset += Character.charCount(codePoint);
        }
        String normalizedDimValue = sb.toString();
        if (invalidCharsEncountered > 0 || wasTruncated) {
            return NormalizationResult.newWarning(normalizedDimValue, () -> String.format("Dimension value normalized from '%s' to '%s'", value, normalizedDimValue));
        }
        return NormalizationResult.newValid(normalizedDimValue);
    }

    private static NormalizationResult normalizeQuotedDimValue(String value, int maxDimensionValueLength) {
        int codePoint;
        if (!StringValueValidator.normalizationRequiredQuotedStringValue(value, maxDimensionValueLength)) {
            return NormalizationResult.newValid(value);
        }
        StringBuilder sb = new StringBuilder();
        int length = value.length();
        boolean previousCodePointSanitized = false;
        int invalidCharsEncountered = 0;
        boolean wasTruncated = false;
        StringValueValidator.State state = StringValueValidator.State.START;
        for (int offset = 0; offset < length; offset += Character.charCount(codePoint)) {
            codePoint = value.codePointAt(offset);
            switch (state) {
                case START: {
                    sb.appendCodePoint(codePoint);
                    state = StringValueValidator.State.QUOTED_STRING_INTERMEDIATE;
                    break;
                }
                case QUOTED_STRING_INTERMEDIATE: {
                    boolean isLastChar;
                    boolean bl = isLastChar = offset + Character.charCount(codePoint) == length;
                    if (codePoint == CodePoints.QUOTE && isLastChar) {
                        sb.appendCodePoint(codePoint);
                        state = StringValueValidator.State.QUOTED_STRING;
                        break;
                    }
                    if (StringValueValidator.isInvalidCodePoint(codePoint)) {
                        if (previousCodePointSanitized) break;
                        if (!StringValueValidator.canAppendToValue(sb.length(), CodePoints.UNDERSCORE, true, false, maxDimensionValueLength)) {
                            wasTruncated = true;
                            break;
                        }
                        sb.appendCodePoint(CodePoints.UNDERSCORE);
                        previousCodePointSanitized = true;
                        ++invalidCharsEncountered;
                        break;
                    }
                    boolean shouldEscape = StringValueValidator.shouldEscapeQuotedString(codePoint);
                    boolean canAppend = StringValueValidator.canAppendToValue(sb.length(), codePoint, true, shouldEscape, maxDimensionValueLength);
                    if (!canAppend) {
                        wasTruncated = true;
                        break;
                    }
                    if (shouldEscape) {
                        sb.appendCodePoint(CodePoints.BACKSLASH).appendCodePoint(codePoint);
                    } else {
                        sb.appendCodePoint(codePoint);
                    }
                    previousCodePointSanitized = false;
                }
            }
            if (!wasTruncated) continue;
            sb.appendCodePoint(CodePoints.QUOTE);
            break;
        }
        String normalizedDimValue = sb.toString();
        if (invalidCharsEncountered > 0 || wasTruncated) {
            return NormalizationResult.newWarning(normalizedDimValue, () -> String.format("Dimension value normalized from '%s' to '%s'", value, normalizedDimValue));
        }
        return NormalizationResult.newValid(normalizedDimValue);
    }
}

