/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.util;

import com.eatthepath.pushy.apns.ApnsPushNotification;
import com.eatthepath.pushy.apns.DeliveryPriority;
import com.eatthepath.pushy.apns.PushType;
import com.eatthepath.uuid.FastUUID;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;

public class SimpleApnsPushNotification
implements ApnsPushNotification {
    private final String token;
    private final String payload;
    private final Instant invalidationTime;
    private final DeliveryPriority priority;
    private final PushType pushType;
    private final String topic;
    private final String collapseId;
    private final UUID apnsId;
    public static final Duration DEFAULT_EXPIRATION_PERIOD = Duration.ofDays(1L);

    public SimpleApnsPushNotification(String token, String topic, String payload) {
        this(token, topic, payload, Instant.now().plus(DEFAULT_EXPIRATION_PERIOD), DeliveryPriority.IMMEDIATE, null, null, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Instant invalidationTime) {
        this(token, topic, payload, invalidationTime, DeliveryPriority.IMMEDIATE, null, null, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Instant invalidationTime, DeliveryPriority priority) {
        this(token, topic, payload, invalidationTime, priority, null, null, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Instant invalidationTime, DeliveryPriority priority, PushType pushType) {
        this(token, topic, payload, invalidationTime, priority, pushType, null, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Instant invalidationTime, DeliveryPriority priority, String collapseId) {
        this(token, topic, payload, invalidationTime, priority, null, collapseId, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Instant invalidationTime, DeliveryPriority priority, PushType pushType, String collapseId) {
        this(token, topic, payload, invalidationTime, priority, pushType, collapseId, null);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Instant invalidationTime, DeliveryPriority priority, String collapseId, UUID apnsId) {
        this(token, topic, payload, invalidationTime, priority, null, collapseId, apnsId);
    }

    public SimpleApnsPushNotification(String token, String topic, String payload, Instant invalidationTime, DeliveryPriority priority, PushType pushType, String collapseId, UUID apnsId) {
        this.token = Objects.requireNonNull(token, "Destination device token must not be null.");
        this.topic = Objects.requireNonNull(topic, "Destination topic must not be null.");
        this.payload = Objects.requireNonNull(payload, "Payload must not be null.");
        this.invalidationTime = invalidationTime;
        this.priority = priority;
        this.pushType = pushType;
        this.collapseId = collapseId;
        this.apnsId = apnsId;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    @Override
    public String getPayload() {
        return this.payload;
    }

    @Override
    public Instant getExpiration() {
        return this.invalidationTime;
    }

    @Override
    public DeliveryPriority getPriority() {
        return this.priority;
    }

    @Override
    public PushType getPushType() {
        return this.pushType;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public String getCollapseId() {
        return this.collapseId;
    }

    @Override
    public UUID getApnsId() {
        return this.apnsId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleApnsPushNotification that = (SimpleApnsPushNotification)o;
        return this.token.equals(that.token) && this.payload.equals(that.payload) && Objects.equals(this.invalidationTime, that.invalidationTime) && this.priority == that.priority && this.pushType == that.pushType && this.topic.equals(that.topic) && Objects.equals(this.collapseId, that.collapseId) && Objects.equals(this.apnsId, that.apnsId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.token, this.payload, this.invalidationTime, this.priority, this.pushType, this.topic, this.collapseId, this.apnsId});
    }

    public String toString() {
        return "SimpleApnsPushNotification{token='" + this.token + '\'' + ", payload='" + this.payload + '\'' + ", invalidationTime=" + this.invalidationTime + ", priority=" + (Object)((Object)this.priority) + ", pushType=" + (Object)((Object)this.pushType) + ", topic='" + this.topic + '\'' + ", collapseId='" + this.collapseId + '\'' + ", apnsId=" + (this.apnsId != null ? FastUUID.toString((UUID)this.apnsId) : null) + '}';
    }
}

