/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.KryoSerializable;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.CollectionSerializer;
import com.esotericsoftware.kryo.serializers.MapSerializer;
import com.esotericsoftware.kryo.util.Util;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Currency;
import java.util.EnumSet;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;

public class DefaultSerializers {

    public static class URLSerializer
    extends Serializer<URL> {
        public URLSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, URL object) {
            output.writeString(object.toExternalForm());
        }

        @Override
        public URL read(Kryo kryo, Input input, Class<URL> type) {
            try {
                return new URL(input.readString());
            }
            catch (MalformedURLException e) {
                throw new KryoException(e);
            }
        }
    }

    public static class CharsetSerializer
    extends Serializer<Charset> {
        public CharsetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Charset object) {
            output.writeString(object.name());
        }

        @Override
        public Charset read(Kryo kryo, Input input, Class<Charset> type) {
            return Charset.forName(input.readString());
        }
    }

    public static class LocaleSerializer
    extends Serializer<Locale> {
        public static final Locale SPANISH = new Locale("es", "", "");
        public static final Locale SPAIN = new Locale("es", "ES", "");

        public LocaleSerializer() {
            this.setImmutable(true);
        }

        protected Locale create(String language, String country, String variant) {
            Locale defaultLocale = Locale.getDefault();
            if (LocaleSerializer.isSameLocale(defaultLocale, language, country, variant)) {
                return defaultLocale;
            }
            if (defaultLocale != Locale.US && LocaleSerializer.isSameLocale(Locale.US, language, country, variant)) {
                return Locale.US;
            }
            if (LocaleSerializer.isSameLocale(Locale.ENGLISH, language, country, variant)) {
                return Locale.ENGLISH;
            }
            if (LocaleSerializer.isSameLocale(Locale.GERMAN, language, country, variant)) {
                return Locale.GERMAN;
            }
            if (LocaleSerializer.isSameLocale(SPANISH, language, country, variant)) {
                return SPANISH;
            }
            if (LocaleSerializer.isSameLocale(Locale.FRENCH, language, country, variant)) {
                return Locale.FRENCH;
            }
            if (LocaleSerializer.isSameLocale(Locale.ITALIAN, language, country, variant)) {
                return Locale.ITALIAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.JAPANESE, language, country, variant)) {
                return Locale.JAPANESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.KOREAN, language, country, variant)) {
                return Locale.KOREAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.SIMPLIFIED_CHINESE, language, country, variant)) {
                return Locale.SIMPLIFIED_CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.CHINESE, language, country, variant)) {
                return Locale.CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.TRADITIONAL_CHINESE, language, country, variant)) {
                return Locale.TRADITIONAL_CHINESE;
            }
            if (LocaleSerializer.isSameLocale(Locale.UK, language, country, variant)) {
                return Locale.UK;
            }
            if (LocaleSerializer.isSameLocale(Locale.GERMANY, language, country, variant)) {
                return Locale.GERMANY;
            }
            if (LocaleSerializer.isSameLocale(SPAIN, language, country, variant)) {
                return SPAIN;
            }
            if (LocaleSerializer.isSameLocale(Locale.FRANCE, language, country, variant)) {
                return Locale.FRANCE;
            }
            if (LocaleSerializer.isSameLocale(Locale.ITALY, language, country, variant)) {
                return Locale.ITALY;
            }
            if (LocaleSerializer.isSameLocale(Locale.JAPAN, language, country, variant)) {
                return Locale.JAPAN;
            }
            if (LocaleSerializer.isSameLocale(Locale.KOREA, language, country, variant)) {
                return Locale.KOREA;
            }
            if (LocaleSerializer.isSameLocale(Locale.CANADA, language, country, variant)) {
                return Locale.CANADA;
            }
            if (LocaleSerializer.isSameLocale(Locale.CANADA_FRENCH, language, country, variant)) {
                return Locale.CANADA_FRENCH;
            }
            return new Locale(language, country, variant);
        }

        @Override
        public void write(Kryo kryo, Output output, Locale l) {
            output.writeAscii(l.getLanguage());
            output.writeAscii(l.getCountry());
            output.writeString(l.getVariant());
        }

        @Override
        public Locale read(Kryo kryo, Input input, Class<Locale> type) {
            String language = input.readString();
            String country = input.readString();
            String variant = input.readString();
            return this.create(language, country, variant);
        }

        protected static boolean isSameLocale(Locale locale, String language, String country, String variant) {
            try {
                return locale.getLanguage().equals(language) && locale.getCountry().equals(country) && locale.getVariant().equals(variant);
            }
            catch (NullPointerException npe) {
                return false;
            }
        }
    }

    public static class TreeSetSerializer
    extends CollectionSerializer {
        @Override
        public void write(Kryo kryo, Output output, Collection collection) {
            TreeSet treeSet = (TreeSet)collection;
            kryo.writeClassAndObject(output, treeSet.comparator());
            super.write(kryo, output, collection);
        }

        @Override
        protected TreeSet create(Kryo kryo, Input input, Class<Collection> type) {
            return this.createTreeSet(type, (Comparator)kryo.readClassAndObject(input));
        }

        @Override
        protected TreeSet createCopy(Kryo kryo, Collection original) {
            return this.createTreeSet(original.getClass(), ((TreeSet)original).comparator());
        }

        private TreeSet createTreeSet(Class<? extends Collection> type, Comparator comparator) {
            if (type != TreeSet.class && type != null) {
                try {
                    Constructor<? extends Collection> constructor = type.getConstructor(Comparator.class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return (TreeSet)constructor.newInstance(comparator);
                }
                catch (Exception ex) {
                    throw new KryoException(ex);
                }
            }
            return new TreeSet(comparator);
        }
    }

    public static class TreeMapSerializer
    extends MapSerializer {
        @Override
        public void write(Kryo kryo, Output output, Map map) {
            TreeMap treeMap = (TreeMap)map;
            kryo.writeClassAndObject(output, treeMap.comparator());
            super.write(kryo, output, map);
        }

        @Override
        protected Map create(Kryo kryo, Input input, Class<Map> type) {
            return this.createTreeMap(type, (Comparator)kryo.readClassAndObject(input));
        }

        @Override
        protected Map createCopy(Kryo kryo, Map original) {
            return this.createTreeMap(original.getClass(), ((TreeMap)original).comparator());
        }

        private TreeMap createTreeMap(Class<? extends Map> type, Comparator comparator) {
            if (type != TreeMap.class && type != null) {
                try {
                    Constructor<? extends Map> constructor = type.getConstructor(Comparator.class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return (TreeMap)constructor.newInstance(comparator);
                }
                catch (Exception ex) {
                    throw new KryoException(ex);
                }
            }
            return new TreeMap(comparator);
        }
    }

    public static class CalendarSerializer
    extends Serializer<Calendar> {
        private static final long DEFAULT_GREGORIAN_CUTOVER = -12219292800000L;
        TimeZoneSerializer timeZoneSerializer = new TimeZoneSerializer();

        @Override
        public void write(Kryo kryo, Output output, Calendar object) {
            this.timeZoneSerializer.write(kryo, output, object.getTimeZone());
            output.writeLong(object.getTimeInMillis(), true);
            output.writeBoolean(object.isLenient());
            output.writeInt(object.getFirstDayOfWeek(), true);
            output.writeInt(object.getMinimalDaysInFirstWeek(), true);
            if (object instanceof GregorianCalendar) {
                output.writeLong(((GregorianCalendar)object).getGregorianChange().getTime(), false);
            } else {
                output.writeLong(-12219292800000L, false);
            }
        }

        @Override
        public Calendar read(Kryo kryo, Input input, Class<Calendar> type) {
            Calendar result = Calendar.getInstance((TimeZone)this.timeZoneSerializer.read(kryo, input, (Class)TimeZone.class));
            result.setTimeInMillis(input.readLong(true));
            result.setLenient(input.readBoolean());
            result.setFirstDayOfWeek(input.readInt(true));
            result.setMinimalDaysInFirstWeek(input.readInt(true));
            long gregorianChange = input.readLong(false);
            if (gregorianChange != -12219292800000L && result instanceof GregorianCalendar) {
                ((GregorianCalendar)result).setGregorianChange(new java.util.Date(gregorianChange));
            }
            return result;
        }

        @Override
        public Calendar copy(Kryo kryo, Calendar original) {
            return (Calendar)original.clone();
        }
    }

    public static class TimeZoneSerializer
    extends Serializer<TimeZone> {
        public TimeZoneSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, TimeZone object) {
            output.writeString(object.getID());
        }

        @Override
        public TimeZone read(Kryo kryo, Input input, Class<TimeZone> type) {
            return TimeZone.getTimeZone(input.readString());
        }
    }

    public static class CollectionsSingletonSetSerializer
    extends Serializer<Set> {
        public CollectionsSingletonSetSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Set object) {
            kryo.writeClassAndObject(output, object.iterator().next());
        }

        @Override
        public Set read(Kryo kryo, Input input, Class type) {
            return Collections.singleton(kryo.readClassAndObject(input));
        }
    }

    public static class CollectionsSingletonMapSerializer
    extends Serializer<Map> {
        public CollectionsSingletonMapSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Map object) {
            Map.Entry entry = object.entrySet().iterator().next();
            kryo.writeClassAndObject(output, entry.getKey());
            kryo.writeClassAndObject(output, entry.getValue());
        }

        @Override
        public Map read(Kryo kryo, Input input, Class type) {
            Object key = kryo.readClassAndObject(input);
            Object value = kryo.readClassAndObject(input);
            return Collections.singletonMap(key, value);
        }
    }

    public static class CollectionsSingletonListSerializer
    extends Serializer<List> {
        public CollectionsSingletonListSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, List object) {
            kryo.writeClassAndObject(output, object.get(0));
        }

        @Override
        public List read(Kryo kryo, Input input, Class type) {
            return Collections.singletonList(kryo.readClassAndObject(input));
        }
    }

    public static class CollectionsEmptySetSerializer
    extends Serializer {
        public CollectionsEmptySetSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class type) {
            return Collections.EMPTY_SET;
        }
    }

    public static class CollectionsEmptyMapSerializer
    extends Serializer {
        public CollectionsEmptyMapSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class type) {
            return Collections.EMPTY_MAP;
        }
    }

    public static class CollectionsEmptyListSerializer
    extends Serializer {
        public CollectionsEmptyListSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class type) {
            return Collections.EMPTY_LIST;
        }
    }

    public static class KryoSerializableSerializer
    extends Serializer<KryoSerializable> {
        @Override
        public void write(Kryo kryo, Output output, KryoSerializable object) {
            object.write(kryo, output);
        }

        @Override
        public KryoSerializable read(Kryo kryo, Input input, Class<KryoSerializable> type) {
            KryoSerializable object = kryo.newInstance(type);
            kryo.reference(object);
            object.read(kryo, input);
            return object;
        }
    }

    public static class StringBuilderSerializer
    extends Serializer<StringBuilder> {
        public StringBuilderSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuilder object) {
            output.writeString(object);
        }

        @Override
        public StringBuilder read(Kryo kryo, Input input, Class<StringBuilder> type) {
            return input.readStringBuilder();
        }

        @Override
        public StringBuilder copy(Kryo kryo, StringBuilder original) {
            return new StringBuilder(original);
        }
    }

    public static class StringBufferSerializer
    extends Serializer<StringBuffer> {
        public StringBufferSerializer() {
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, StringBuffer object) {
            output.writeString(object);
        }

        @Override
        public StringBuffer read(Kryo kryo, Input input, Class<StringBuffer> type) {
            String value = input.readString();
            if (value == null) {
                return null;
            }
            return new StringBuffer(value);
        }

        @Override
        public StringBuffer copy(Kryo kryo, StringBuffer original) {
            return new StringBuffer(original);
        }
    }

    public static class CurrencySerializer
    extends Serializer<Currency> {
        public CurrencySerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Currency object) {
            output.writeString(object == null ? null : object.getCurrencyCode());
        }

        @Override
        public Currency read(Kryo kryo, Input input, Class<Currency> type) {
            String currencyCode = input.readString();
            if (currencyCode == null) {
                return null;
            }
            return Currency.getInstance(currencyCode);
        }
    }

    public static class EnumSetSerializer
    extends Serializer<EnumSet> {
        @Override
        public void write(Kryo kryo, Output output, EnumSet object) {
            Serializer serializer;
            if (object.isEmpty()) {
                EnumSet tmp = EnumSet.complementOf(object);
                if (tmp.isEmpty()) {
                    throw new KryoException("An EnumSet must have a defined Enum to be serialized.");
                }
                serializer = kryo.writeClass(output, tmp.iterator().next().getClass()).getSerializer();
            } else {
                serializer = kryo.writeClass(output, object.iterator().next().getClass()).getSerializer();
            }
            output.writeInt(object.size(), true);
            for (Object element : object) {
                serializer.write(kryo, output, element);
            }
        }

        @Override
        public EnumSet read(Kryo kryo, Input input, Class<EnumSet> type) {
            Registration registration = kryo.readClass(input);
            EnumSet object = EnumSet.noneOf(registration.getType());
            Serializer serializer = registration.getSerializer();
            int length = input.readInt(true);
            for (int i = 0; i < length; ++i) {
                object.add(serializer.read(kryo, input, null));
            }
            return object;
        }

        @Override
        public EnumSet copy(Kryo kryo, EnumSet original) {
            return EnumSet.copyOf(original);
        }
    }

    public static class EnumSerializer
    extends Serializer<Enum> {
        private Object[] enumConstants;

        public EnumSerializer(Class<? extends Enum> type) {
            this.setImmutable(true);
            this.setAcceptsNull(true);
            this.enumConstants = type.getEnumConstants();
            if (this.enumConstants == null) {
                throw new IllegalArgumentException("The type must be an enum: " + type);
            }
        }

        @Override
        public void write(Kryo kryo, Output output, Enum object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            output.writeVarInt(object.ordinal() + 1, true);
        }

        @Override
        public Enum read(Kryo kryo, Input input, Class<Enum> type) {
            int ordinal = input.readVarInt(true);
            if (ordinal == 0) {
                return null;
            }
            if (--ordinal < 0 || ordinal > this.enumConstants.length - 1) {
                throw new KryoException("Invalid ordinal for enum \"" + type.getName() + "\": " + ordinal);
            }
            Object constant = this.enumConstants[ordinal];
            return (Enum)constant;
        }
    }

    public static class DateSerializer
    extends Serializer<java.util.Date> {
        private java.util.Date create(Kryo kryo, Class<? extends java.util.Date> type, long time) throws KryoException {
            if (type == java.util.Date.class || type == null) {
                return new java.util.Date(time);
            }
            if (type == Timestamp.class) {
                return new Timestamp(time);
            }
            if (type == Date.class) {
                return new Date(time);
            }
            if (type == Time.class) {
                return new Time(time);
            }
            try {
                Constructor<? extends java.util.Date> constructor = type.getConstructor(Long.TYPE);
                if (!constructor.isAccessible()) {
                    try {
                        constructor.setAccessible(true);
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                }
                return constructor.newInstance(time);
            }
            catch (Exception ex) {
                java.util.Date d = kryo.newInstance(type);
                d.setTime(time);
                return d;
            }
        }

        @Override
        public void write(Kryo kryo, Output output, java.util.Date object) {
            output.writeLong(object.getTime(), true);
        }

        @Override
        public java.util.Date read(Kryo kryo, Input input, Class<java.util.Date> type) {
            return this.create(kryo, type, input.readLong(true));
        }

        @Override
        public java.util.Date copy(Kryo kryo, java.util.Date original) {
            return this.create(kryo, original.getClass(), original.getTime());
        }
    }

    public static class ClassSerializer
    extends Serializer<Class> {
        public ClassSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Class object) {
            kryo.writeClass(output, object);
            output.writeByte(object != null && object.isPrimitive() ? 1 : 0);
        }

        @Override
        public Class read(Kryo kryo, Input input, Class<Class> type) {
            Class typ;
            Registration registration = kryo.readClass(input);
            int isPrimitive = input.read();
            Class clazz = typ = registration != null ? registration.getType() : null;
            if (typ == null || !typ.isPrimitive()) {
                return typ;
            }
            return isPrimitive == 1 ? typ : Util.getWrapperClass(typ);
        }
    }

    public static class BigDecimalSerializer
    extends Serializer<BigDecimal> {
        private final BigIntegerSerializer bigIntegerSerializer = new BigIntegerSerializer();

        public BigDecimalSerializer() {
            this.setAcceptsNull(true);
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigDecimal object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            BigDecimal value = object;
            if (value == BigDecimal.ZERO) {
                this.bigIntegerSerializer.write(kryo, output, BigInteger.ZERO);
                output.writeInt(0, false);
                return;
            }
            this.bigIntegerSerializer.write(kryo, output, value.unscaledValue());
            output.writeInt(value.scale(), false);
        }

        @Override
        public BigDecimal read(Kryo kryo, Input input, Class<BigDecimal> type) {
            Object unscaledValue = this.bigIntegerSerializer.read(kryo, input, (Class)BigInteger.class);
            if (unscaledValue == null) {
                return null;
            }
            int scale = input.readInt(false);
            if (type != BigDecimal.class && type != null) {
                try {
                    Constructor<BigDecimal> constructor = type.getConstructor(BigInteger.class, Integer.TYPE);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return constructor.newInstance(unscaledValue, scale);
                }
                catch (Exception ex) {
                    throw new KryoException(ex);
                }
            }
            if (unscaledValue == BigInteger.ZERO && scale == 0) {
                return BigDecimal.ZERO;
            }
            return new BigDecimal((BigInteger)unscaledValue, scale);
        }
    }

    public static class BigIntegerSerializer
    extends Serializer<BigInteger> {
        public BigIntegerSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, BigInteger object) {
            if (object == null) {
                output.writeVarInt(0, true);
                return;
            }
            BigInteger value = object;
            if (value == BigInteger.ZERO) {
                output.writeVarInt(2, true);
                output.writeByte(0);
                return;
            }
            byte[] bytes = value.toByteArray();
            output.writeVarInt(bytes.length + 1, true);
            output.writeBytes(bytes);
        }

        @Override
        public BigInteger read(Kryo kryo, Input input, Class<BigInteger> type) {
            int length = input.readVarInt(true);
            if (length == 0) {
                return null;
            }
            byte[] bytes = input.readBytes(length - 1);
            if (type != BigInteger.class && type != null) {
                try {
                    Constructor<BigInteger> constructor = type.getConstructor(byte[].class);
                    if (!constructor.isAccessible()) {
                        try {
                            constructor.setAccessible(true);
                        }
                        catch (SecurityException securityException) {
                            // empty catch block
                        }
                    }
                    return constructor.newInstance(new Object[]{bytes});
                }
                catch (Exception ex) {
                    throw new KryoException(ex);
                }
            }
            if (length == 2) {
                switch (bytes[0]) {
                    case 0: {
                        return BigInteger.ZERO;
                    }
                    case 1: {
                        return BigInteger.ONE;
                    }
                    case 10: {
                        return BigInteger.TEN;
                    }
                }
            }
            return new BigInteger(bytes);
        }
    }

    public static class StringSerializer
    extends Serializer<String> {
        public StringSerializer() {
            this.setImmutable(true);
            this.setAcceptsNull(true);
        }

        @Override
        public void write(Kryo kryo, Output output, String object) {
            output.writeString(object);
        }

        @Override
        public String read(Kryo kryo, Input input, Class<String> type) {
            return input.readString();
        }
    }

    public static class DoubleSerializer
    extends Serializer<Double> {
        public DoubleSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Double object) {
            output.writeDouble(object);
        }

        @Override
        public Double read(Kryo kryo, Input input, Class<Double> type) {
            return input.readDouble();
        }
    }

    public static class FloatSerializer
    extends Serializer<Float> {
        public FloatSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Float object) {
            output.writeFloat(object.floatValue());
        }

        @Override
        public Float read(Kryo kryo, Input input, Class<Float> type) {
            return Float.valueOf(input.readFloat());
        }
    }

    public static class LongSerializer
    extends Serializer<Long> {
        public LongSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Long object) {
            output.writeLong(object, false);
        }

        @Override
        public Long read(Kryo kryo, Input input, Class<Long> type) {
            return input.readLong(false);
        }
    }

    public static class IntSerializer
    extends Serializer<Integer> {
        public IntSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Integer object) {
            output.writeInt(object, false);
        }

        @Override
        public Integer read(Kryo kryo, Input input, Class<Integer> type) {
            return input.readInt(false);
        }
    }

    public static class ShortSerializer
    extends Serializer<Short> {
        public ShortSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Short object) {
            output.writeShort(object.shortValue());
        }

        @Override
        public Short read(Kryo kryo, Input input, Class<Short> type) {
            return input.readShort();
        }
    }

    public static class CharSerializer
    extends Serializer<Character> {
        public CharSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Character object) {
            output.writeChar(object.charValue());
        }

        @Override
        public Character read(Kryo kryo, Input input, Class<Character> type) {
            return Character.valueOf(input.readChar());
        }
    }

    public static class ByteSerializer
    extends Serializer<Byte> {
        public ByteSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Byte object) {
            output.writeByte(object);
        }

        @Override
        public Byte read(Kryo kryo, Input input, Class<Byte> type) {
            return input.readByte();
        }
    }

    public static class BooleanSerializer
    extends Serializer<Boolean> {
        public BooleanSerializer() {
            this.setImmutable(true);
        }

        @Override
        public void write(Kryo kryo, Output output, Boolean object) {
            output.writeBoolean(object);
        }

        @Override
        public Boolean read(Kryo kryo, Input input, Class<Boolean> type) {
            return input.readBoolean();
        }
    }

    public static class VoidSerializer
    extends Serializer {
        public VoidSerializer() {
            this.setImmutable(true);
        }

        public void write(Kryo kryo, Output output, Object object) {
        }

        public Object read(Kryo kryo, Input input, Class type) {
            return null;
        }
    }
}

