/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.JsonReader;
import com.esri.core.geometry.NumberUtils;
import java.io.IOException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonToken;

final class JSONUtils {
    JSONUtils() {
    }

    static boolean isObjectStart(JsonReader parser) throws Exception {
        return parser.currentToken() == null ? parser.nextToken() == JsonToken.START_OBJECT : parser.currentToken() == JsonToken.START_OBJECT;
    }

    static double readDouble(JsonReader parser) throws JsonParseException, IOException, Exception {
        if (parser.currentToken() == JsonToken.VALUE_NUMBER_FLOAT) {
            return parser.currentDoubleValue();
        }
        if (parser.currentToken() == JsonToken.VALUE_NUMBER_INT) {
            return parser.currentIntValue();
        }
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return NumberUtils.NaN();
        }
        if (parser.currentToken() == JsonToken.VALUE_STRING && parser.currentString().equals("NaN")) {
            return NumberUtils.NaN();
        }
        throw new GeometryException("invalid parameter");
    }
}

