/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.core.runner;

import akka.dispatch.Await;
import akka.dispatch.Await$;
import akka.dispatch.Future;
import akka.util.Timeout;
import com.excilys.ebi.gatling.core.action.AkkaDefaults;
import com.excilys.ebi.gatling.core.action.AkkaDefaults$class;
import com.excilys.ebi.gatling.core.action.package$;
import com.excilys.ebi.gatling.core.config.GatlingConfiguration$;
import com.excilys.ebi.gatling.core.result.message.RunRecord;
import com.excilys.ebi.gatling.core.result.terminator.Terminator$;
import com.excilys.ebi.gatling.core.result.writer.DataWriter$;
import com.excilys.ebi.gatling.core.runner.Selection;
import com.excilys.ebi.gatling.core.scenario.Scenario;
import com.excilys.ebi.gatling.core.scenario.configuration.Simulation;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u000113A!\u0001\u0002\u0001\u001f\t1!+\u001e8oKJT!a\u0001\u0003\u0002\rI,hN\\3s\u0015\t)a!\u0001\u0003d_J,'BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT!!\u0003\u0006\u0002\u0007\u0015\u0014\u0017N\u0003\u0002\f\u0019\u00059Q\r_2jYf\u001c(\"A\u0007\u0002\u0007\r|Wn\u0001\u0001\u0014\u000b\u0001\u0001\u0002D\b\u0014\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00027b]\u001eT\u0011!F\u0001\u0005U\u00064\u0018-\u0003\u0002\u0018%\t1qJ\u00196fGR\u0004\"!\u0007\u000f\u000e\u0003iQ!a\u0007\u0003\u0002\r\u0005\u001cG/[8o\u0013\ti\"D\u0001\u0007BW.\fG)\u001a4bk2$8\u000f\u0005\u0002 I5\t\u0001E\u0003\u0002\"E\u0005)1\u000f\u001c45U*\t1%\u0001\u0005he&T(\u0010\\3e\u0013\t)\u0003EA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t[\u0001\u0011\t\u0011)A\u0005]\u0005I1/\u001a7fGRLwN\u001c\t\u0003_Aj\u0011AA\u0005\u0003c\t\u0011\u0011bU3mK\u000e$\u0018n\u001c8\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\t)d\u0007\u0005\u00020\u0001!)QF\ra\u0001]!)\u0001\b\u0001C\u0001s\u0005\u0019!/\u001e8\u0016\u0003i\u0002BaJ\u001e>\t&\u0011A\b\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005y\neBA\u0014@\u0013\t\u0001\u0005&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!)!\t)%*D\u0001G\u0015\t9\u0005*A\u0007d_:4\u0017nZ;sCRLwN\u001c\u0006\u0003\u0013\u0012\t\u0001b]2f]\u0006\u0014\u0018n\\\u0005\u0003\u0017\u001a\u0013!bU5nk2\fG/[8o\u0001")
public class Runner
implements AkkaDefaults,
Logging {
    private final Selection selection;
    private final Logger grizzled$slf4j$Logging$$_logger;
    private final Timeout defaultTimeOut;
    private volatile int bitmap$priv$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Logger grizzled$slf4j$Logging$$_logger() {
        if ((this.bitmap$priv$0 & 1) != 0) return this.grizzled$slf4j$Logging$$_logger;
        Runner runner = this;
        synchronized (runner) {
            if ((this.bitmap$priv$0 & 1) == 0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.class.grizzled$slf4j$Logging$$_logger((Logging)this);
                this.bitmap$priv$0 |= 1;
            }
            return this.grizzled$slf4j$Logging$$_logger;
        }
    }

    public Logger logger() {
        return Logging.class.logger((Logging)this);
    }

    public String loggerName() {
        return Logging.class.loggerName((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.trace((Logging)this, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.debug((Logging)this, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.class.isErrorEnabled((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.error((Logging)this, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.class.isInfoEnabled((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.info((Logging)this, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.class.isWarnEnabled((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.class.warn((Logging)this, msg, t);
    }

    @Override
    public Timeout defaultTimeOut() {
        return this.defaultTimeOut;
    }

    @Override
    public void com$excilys$ebi$gatling$core$action$AkkaDefaults$_setter_$defaultTimeOut_$eq(Timeout timeout) {
        this.defaultTimeOut = timeout;
    }

    public Tuple2<String, Simulation> run() {
        Tuple2 exceptionResult1 = null;
        try {
            Class<Simulation> simulationClass$1 = this.selection.simulationClass();
            Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Simulation ").append((Object)simulationClass$1.getName()).append((Object)" started...").toString());
            RunRecord runRecord$1 = new RunRecord(DateTime.now(), this.selection.simulationId(), this.selection.description());
            Simulation simulation = simulationClass$1.newInstance();
            Seq<Scenario> scenarios$1 = simulation.scenarios();
            Predef$.MODULE$.require(!scenarios$1.isEmpty(), (Function0)new Serializable(this, simulationClass$1){
                public static final long serialVersionUID;
                private final Class simulationClass$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)this.simulationClass$1.getName()).append((Object)" returned an empty scenario list. Did you forget to migrate your Simulations?").toString();
                }
                {
                    this.simulationClass$1 = clazz;
                }
            });
            Seq scenarioNames$1 = (Seq)scenarios$1.map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply(Scenario scenario) {
                    return scenario.name();
                }
            }, Seq$.MODULE$.canBuildFrom());
            Predef$.MODULE$.require(scenarioNames$1.toSet().size() == scenarioNames$1.size(), (Function0)new Serializable(this, scenarioNames$1){
                public static final long serialVersionUID;
                private final Seq scenarioNames$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Scenario names must be unique but found ").append((Object)this.scenarioNames$1).toString();
                }
                {
                    this.scenarioNames$1 = seq;
                }
            });
            int totalNumberOfUsers$1 = BoxesRunTime.unboxToInt((Object)((TraversableOnce)scenarios$1.map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Scenario scenario) {
                    return scenario.configuration().users();
                }
            }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
            this.info((Function0)new Serializable(this, totalNumberOfUsers$1){
                public static final long serialVersionUID;
                private final int totalNumberOfUsers$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return new StringBuilder().append((Object)"Total number of users : ").append((Object)BoxesRunTime.boxToInteger((int)this.totalNumberOfUsers$1)).toString();
                }
                {
                    this.totalNumberOfUsers$1 = n;
                }
            });
            CountDownLatch terminatorLatch = new CountDownLatch(1);
            Future init = Terminator$.MODULE$.askInit(terminatorLatch, totalNumberOfUsers$1).flatMap((Function1)new Serializable(this, runRecord$1, scenarios$1){
                public static final long serialVersionUID;
                private final RunRecord runRecord$1;
                private final Seq scenarios$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Future<Iterable<Object>> apply(Object x$3) {
                    return DataWriter$.MODULE$.askInit(this.runRecord$1, (Seq<Scenario>)this.scenarios$1);
                }
                {
                    this.runRecord$1 = runRecord;
                    this.scenarios$1 = seq;
                }
            });
            Await$.MODULE$.result((Await.Awaitable)init, this.defaultTimeOut().duration());
            this.debug((Function0)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Launching All Scenarios";
                }
            });
            scenarios$1.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(int i, Scenario scenario) {
                    scenario.run(i);
                    return i + scenario.configuration().users();
                }
            });
            this.debug((Function0)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Finished Launching scenarios executions";
                }
            });
            terminatorLatch.await(GatlingConfiguration$.MODULE$.configuration().core().timeOut().simulation(), TimeUnit.SECONDS);
            Predef$.MODULE$.println((Object)"Simulation finished.");
            exceptionResult1 = new Tuple2((Object)runRecord$1.runId(), (Object)simulation);
            return exceptionResult1;
        }
        finally {
            package$.MODULE$.system().shutdown();
        }
    }

    public Runner(Selection selection) {
        this.selection = selection;
        AkkaDefaults$class.$init$(this);
        Logging.class.$init$((Logging)this);
    }
}

