/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.mojo;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.codehaus.plexus.util.StringUtils;
import scala_maven_executions.JavaMainCallerInProcess;

public class GatlingJavaMainCallerInProcess
extends JavaMainCallerInProcess {
    public GatlingJavaMainCallerInProcess(AbstractMojo requester, String mainClassName, String classpath, String[] args) throws Exception {
        super(requester, mainClassName, classpath, null, args);
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String path : classpath.split(File.pathSeparator)) {
            try {
                urls.add(new File(path).toURI().toURL());
            }
            catch (MalformedURLException e) {
                requester.getLog().error((Throwable)e);
            }
        }
        Thread.currentThread().setContextClassLoader(new URLClassLoader(urls.toArray(new URL[urls.size()])));
    }

    public void addJvmArgs(String ... args) {
    }

    public boolean run(boolean displayCmd, boolean throwFailure) throws Exception {
        return false;
    }

    public int run() throws Exception {
        return this.runInternal(false);
    }

    private int runInternal(boolean displayCmd) throws Exception {
        Object[] argArray = this.args.toArray(new String[this.args.size()]);
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd : " + this.mainClassName + "(" + StringUtils.join((Object[])argArray, (String)",") + ")"));
        }
        return this.runGatling(this.mainClassName, this.args);
    }

    private int runGatling(String mainClassName, List<String> args) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<?> mainClass = cl.loadClass(mainClassName);
        Method runGatlingMethod = mainClass.getMethod("runGatling", String[].class);
        String[] argArray = args.toArray(new String[args.size()]);
        return (Integer)runGatlingMethod.invoke(null, new Object[]{argArray});
    }
}

