/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit;

import com.excilys.ebi.spring.dbunit.DataLoader;
import com.excilys.ebi.spring.dbunit.DbUnitDatabasePopulator;
import com.excilys.ebi.spring.dbunit.config.DataSetConfiguration;
import com.excilys.ebi.spring.dbunit.config.Phase;
import com.excilys.ebi.spring.dbunit.utils.DbUnitUtils;
import java.sql.Connection;
import javax.sql.DataSource;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class DefaultDataLoader
implements DataLoader {
    @Override
    public void execute(ApplicationContext context, DataSetConfiguration dataSetConfiguration, Phase phase) throws Exception {
        if (dataSetConfiguration != null) {
            DbUnitDatabasePopulator populator = new DbUnitDatabasePopulator();
            populator.setDataSetConfiguration(dataSetConfiguration);
            populator.setPhase(phase);
            DataSource dataSource = DbUnitUtils.lookUpDataSource(context, dataSetConfiguration);
            this.executeOperation(populator, dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeOperation(DbUnitDatabasePopulator populator, DataSource dataSource) throws Exception {
        Connection connection = null;
        try {
            connection = DataSourceUtils.getConnection((DataSource)dataSource);
            populator.populate(connection);
        }
        finally {
            if (connection != null && !DataSourceUtils.isConnectionTransactional((Connection)connection, (DataSource)dataSource)) {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)dataSource);
            }
        }
    }
}

