/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit.config;

import org.dbunit.database.DefaultMetadataHandler;
import org.dbunit.database.IMetadataHandler;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.ext.db2.Db2DataTypeFactory;
import org.dbunit.ext.db2.Db2MetadataHandler;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.ext.mckoi.MckoiDataTypeFactory;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlMetadataHandler;
import org.dbunit.ext.netezza.NetezzaDataTypeFactory;
import org.dbunit.ext.netezza.NetezzaMetadataHandler;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;

public enum DBType {
    DB2(Db2DataTypeFactory.class, Db2MetadataHandler.class),
    HSQLDB(HsqldbDataTypeFactory.class, DefaultMetadataHandler.class),
    H2(H2DataTypeFactory.class, DefaultMetadataHandler.class),
    MCKOY(MckoiDataTypeFactory.class, DefaultMetadataHandler.class),
    MSSQL(MsSqlDataTypeFactory.class, DefaultMetadataHandler.class),
    MYSQL(MySqlDataTypeFactory.class, MySqlMetadataHandler.class),
    NETEZZA(NetezzaDataTypeFactory.class, NetezzaMetadataHandler.class),
    ORACLE(OracleDataTypeFactory.class, DefaultMetadataHandler.class),
    ORACLE10(Oracle10DataTypeFactory.class, DefaultMetadataHandler.class),
    POSTGRESQL(PostgresqlDataTypeFactory.class, DefaultMetadataHandler.class);

    private final Class<? extends IDataTypeFactory> dataTypeFactoryClass;
    private final Class<? extends IMetadataHandler> metadataHandlerClass;
    private IDataTypeFactory dataTypeFactory;
    private IMetadataHandler metadataHandler;

    private DBType(Class<? extends IDataTypeFactory> dataTypeFactoryClass, Class<? extends IMetadataHandler> metadataHandlerClass) {
        this.dataTypeFactoryClass = dataTypeFactoryClass;
        this.metadataHandlerClass = metadataHandlerClass;
    }

    IDataTypeFactory getDataTypeFactory() {
        if (this.dataTypeFactory == null) {
            this.dataTypeFactory = this.getInstance(this.dataTypeFactoryClass);
        }
        return this.dataTypeFactory;
    }

    IMetadataHandler getMetadataHandler() {
        if (this.metadataHandler == null) {
            this.metadataHandler = this.getInstance(this.metadataHandlerClass);
        }
        return this.metadataHandler;
    }

    private <T> T getInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

