/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit.config;

import com.excilys.ebi.spring.dbunit.config.Constants;
import com.excilys.ebi.spring.dbunit.config.DBOperation;
import com.excilys.ebi.spring.dbunit.config.DBType;
import com.excilys.ebi.spring.dbunit.config.DataSetFormat;
import com.excilys.ebi.spring.dbunit.config.DataSetFormatOptions;
import com.excilys.ebi.spring.dbunit.config.DatabaseConnectionConfigurer;
import com.excilys.ebi.spring.dbunit.dataset.DataSetDecorator;
import java.io.IOException;
import java.util.List;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DataSetConfiguration
implements DatabaseConnectionConfigurer {
    private boolean disabled;
    private String dataSourceSpringName;
    private DBOperation[] setUpOperation = new DBOperation[]{Constants.ConfigurationDefaults.DEFAULT_SETUP_OPERATION};
    private DBOperation[] tearDownOperation = new DBOperation[]{Constants.ConfigurationDefaults.DEFAULT_TEARDOWN_OPERATION};
    private DBType dbType = Constants.ConfigurationDefaults.DEFAULT_DB_TYPE;
    private String[] dataSetResourceLocations = new String[]{"classpath:dataSet.xml"};
    private DataSetFormat format = Constants.ConfigurationDefaults.DEFAULT_DB_FORMAT;
    private DataSetFormatOptions formatOptions = new DataSetFormatOptions();
    private String escapePattern = "";
    private int batchSize = 100;
    private int fetchSize = 100;
    private boolean qualifiedTableNames = false;
    private boolean batchedStatements = false;
    private boolean skipOracleRecycleBinTables = false;
    private String[] tableType = Constants.ConfigurationDefaults.DEFAULT_TABLE_TYPE;
    private String schema = Constants.ConfigurationDefaults.DEFAULT_SCHEMA;
    private Class<? extends DataSetDecorator>[] decorators = null;

    public IDataSet getDataSet() throws DataSetException, IOException {
        List<IDataSet> dataSets = this.format.loadMultiple(this.formatOptions, this.dataSetResourceLocations);
        return dataSets.size() == 1 ? dataSets.get(0) : new CompositeDataSet(dataSets.toArray(new IDataSet[dataSets.size()]));
    }

    @Override
    public void configure(DatabaseConfig databaseConfig) {
        Assert.notNull((Object)((Object)this.dbType), (String)"dbType is required");
        databaseConfig.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)this.dbType.getDataTypeFactory());
        databaseConfig.setProperty("http://www.dbunit.org/properties/metadataHandler", (Object)this.dbType.getMetadataHandler());
        databaseConfig.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)this.escapePattern);
        databaseConfig.setProperty("http://www.dbunit.org/properties/batchSize", (Object)this.batchSize);
        databaseConfig.setProperty("http://www.dbunit.org/properties/fetchSize", (Object)this.fetchSize);
        databaseConfig.setProperty("http://www.dbunit.org/features/caseSensitiveTableNames", (Object)this.formatOptions.isCaseSensitiveTableNames());
        databaseConfig.setProperty("http://www.dbunit.org/features/qualifiedTableNames", (Object)this.qualifiedTableNames);
        databaseConfig.setProperty("http://www.dbunit.org/features/batchedStatements", (Object)this.batchedStatements);
        databaseConfig.setProperty("http://www.dbunit.org/features/skipOracleRecycleBinTables", (Object)this.skipOracleRecycleBinTables);
        databaseConfig.setProperty("http://www.dbunit.org/properties/tableType", (Object)this.tableType);
    }

    public static Builder newDataSetConfiguration() {
        return new Builder();
    }

    public String getDataSetResourceLocation() {
        throw new UnsupportedOperationException();
    }

    public void setDataSetResourceLocation(String dataSetResourceLocation) {
        this.dataSetResourceLocations = StringUtils.tokenizeToStringArray((String)dataSetResourceLocation, (String)",; \t\n");
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getDataSourceSpringName() {
        return this.dataSourceSpringName;
    }

    public DBOperation[] getSetUpOperation() {
        return this.setUpOperation;
    }

    public DBOperation[] getTearDownOperation() {
        return this.tearDownOperation;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public String[] getDataSetResourceLocations() {
        return this.dataSetResourceLocations;
    }

    public DataSetFormat getFormat() {
        return this.format;
    }

    public DataSetFormatOptions getFormatOptions() {
        return this.formatOptions;
    }

    public String getEscapePattern() {
        return this.escapePattern;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public boolean isQualifiedTableNames() {
        return this.qualifiedTableNames;
    }

    public boolean isBatchedStatements() {
        return this.batchedStatements;
    }

    public boolean isSkipOracleRecycleBinTables() {
        return this.skipOracleRecycleBinTables;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setDataSourceSpringName(String dataSourceSpringName) {
        this.dataSourceSpringName = dataSourceSpringName;
    }

    public void setSetUpOperation(DBOperation[] setUpOperation) {
        this.setUpOperation = setUpOperation;
    }

    public void setTearDownOperation(DBOperation[] tearDownOperation) {
        this.tearDownOperation = tearDownOperation;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public void setDataSetResourceLocations(String[] dataSetResourceLocations) {
        this.dataSetResourceLocations = dataSetResourceLocations;
    }

    public void setFormat(DataSetFormat format) {
        this.format = format;
    }

    public void setFormatOptions(DataSetFormatOptions formatOptions) {
        this.formatOptions = formatOptions;
    }

    public void setEscapePattern(String escapePattern) {
        this.escapePattern = escapePattern;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setQualifiedTableNames(boolean qualifiedTableNames) {
        this.qualifiedTableNames = qualifiedTableNames;
    }

    public void setBatchedStatements(boolean batchedStatements) {
        this.batchedStatements = batchedStatements;
    }

    public void setSkipOracleRecycleBinTables(boolean skipOracleRecycleBinTables) {
        this.skipOracleRecycleBinTables = skipOracleRecycleBinTables;
    }

    public String[] getTableType() {
        return this.tableType;
    }

    public void setTableType(String[] tableType) {
        this.tableType = tableType;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public Class<? extends DataSetDecorator>[] getDecorators() {
        return this.decorators;
    }

    public void setDecorators(Class<? extends DataSetDecorator>[] decorators) {
        this.decorators = decorators;
    }

    static /* synthetic */ DBOperation[] access$302(DataSetConfiguration x0, DBOperation[] x1) {
        x0.setUpOperation = x1;
        return x1;
    }

    static /* synthetic */ DBOperation[] access$402(DataSetConfiguration x0, DBOperation[] x1) {
        x0.tearDownOperation = x1;
        return x1;
    }

    static /* synthetic */ String[] access$602(DataSetConfiguration x0, String[] x1) {
        x0.dataSetResourceLocations = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1502(DataSetConfiguration x0, String[] x1) {
        x0.tableType = x1;
        return x1;
    }

    static /* synthetic */ Class[] access$1702(DataSetConfiguration x0, Class[] x1) {
        x0.decorators = x1;
        return x1;
    }

    public static class Builder {
        private DataSetConfiguration dataSetConfiguration = new DataSetConfiguration();

        private Builder() {
        }

        public Builder withDisabled(boolean disabled) {
            this.dataSetConfiguration.disabled = disabled;
            return this;
        }

        public Builder withDataSourceSpringName(String dataSourceSpringName) {
            this.dataSetConfiguration.dataSourceSpringName = dataSourceSpringName;
            return this;
        }

        public Builder withSetUpOp(DBOperation[] setUpOp) {
            DataSetConfiguration.access$302(this.dataSetConfiguration, setUpOp);
            return this;
        }

        public Builder withTearDownOp(DBOperation[] tearDownOp) {
            DataSetConfiguration.access$402(this.dataSetConfiguration, tearDownOp);
            return this;
        }

        public Builder withDbType(DBType dbType) {
            if (dbType != null) {
                this.dataSetConfiguration.dbType = dbType;
            }
            return this;
        }

        public Builder withDataSetResourceLocations(String[] dataSetResourceLocations) {
            DataSetConfiguration.access$602(this.dataSetConfiguration, dataSetResourceLocations);
            return this;
        }

        public Builder withFormat(DataSetFormat format) {
            this.dataSetConfiguration.format = format;
            return this;
        }

        public Builder withFormatOptions(DataSetFormatOptions formatOptions) {
            this.dataSetConfiguration.formatOptions = formatOptions;
            return this;
        }

        public Builder withEscapePattern(String escapePattern) {
            this.dataSetConfiguration.escapePattern = (escapePattern = escapePattern.trim()).isEmpty() ? null : escapePattern;
            return this;
        }

        public Builder withBatchSize(int batchSize) {
            this.dataSetConfiguration.batchSize = batchSize;
            return this;
        }

        public Builder withFetchSize(int fetchSize) {
            this.dataSetConfiguration.fetchSize = fetchSize;
            return this;
        }

        public Builder withQualifiedTableNames(boolean qualifiedTableNames) {
            this.dataSetConfiguration.qualifiedTableNames = qualifiedTableNames;
            return this;
        }

        public Builder withBatchedStatements(boolean batchedStatements) {
            this.dataSetConfiguration.batchedStatements = batchedStatements;
            return this;
        }

        public Builder withSkipOracleRecycleBinTables(boolean skipOracleRecycleBinTables) {
            this.dataSetConfiguration.skipOracleRecycleBinTables = skipOracleRecycleBinTables;
            return this;
        }

        public Builder withTableType(String[] tableType) {
            if (tableType != null) {
                DataSetConfiguration.access$1502(this.dataSetConfiguration, tableType);
            }
            return this;
        }

        public Builder withSchema(String schema) {
            if (!(schema = schema.trim()).isEmpty()) {
                this.dataSetConfiguration.schema = schema;
            }
            return this;
        }

        public Builder withDecorators(Class<? extends DataSetDecorator>[] decorators) {
            if (decorators != null) {
                DataSetConfiguration.access$1702(this.dataSetConfiguration, decorators);
            }
            return this;
        }

        public DataSetConfiguration build() {
            Assert.notNull((Object)this.dataSetConfiguration.dataSetResourceLocations, (String)"dataSetResourceLocations is required");
            Assert.notNull((Object)this.dataSetConfiguration.setUpOperation, (String)"setUpOperation is required");
            Assert.notNull((Object)this.dataSetConfiguration.tearDownOperation, (String)"tearDownOperation is required");
            Assert.notNull((Object)((Object)this.dataSetConfiguration.dbType), (String)"dbType is required");
            Assert.notNull((Object)((Object)this.dataSetConfiguration.format), (String)"format is required");
            Assert.notNull((Object)this.dataSetConfiguration.formatOptions, (String)"formatOptions are required");
            return this.dataSetConfiguration;
        }
    }
}

