/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit.config;

import com.excilys.ebi.spring.dbunit.config.DataSetFormatOptions;
import com.excilys.ebi.spring.dbunit.dataset.xml.LinkedHashMapFlatDtdProducer;
import com.excilys.ebi.spring.dbunit.dataset.xml.flyweight.FlyWeightFlatXmlDataSetBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.csv.CsvDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.stream.StreamingDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.dataset.xml.XmlProducer;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StringUtils;
import org.xml.sax.InputSource;

public enum DataSetFormat {
    FLYWEIGHT_FLAT{

        @Override
        protected IDataSet fromResource(Resource resource, DataSetFormatOptions options) throws DataSetException, IOException {
            FlyWeightFlatXmlDataSetBuilder builder = new FlyWeightFlatXmlDataSetBuilder();
            builder.setColumnSensing(options.isColumnSensing());
            builder.setDtdMetadata(options.isDtdMetadata());
            builder.setCaseSensitiveTableNames(options.isCaseSensitiveTableNames());
            if (StringUtils.hasText((String)options.getDtdLocation())) {
                IDataSet metaDataSet = FLAT_DTD.loadUnique(null, options.getDtdLocation());
                builder.setMetaDataSet(metaDataSet);
            }
            return builder.build(resource.getInputStream());
        }
    }
    ,
    FLAT{

        @Override
        protected IDataSet fromResource(Resource resource, DataSetFormatOptions options) throws DataSetException, IOException {
            FlatXmlDataSetBuilder builder = new FlatXmlDataSetBuilder();
            builder.setColumnSensing(options.isColumnSensing());
            builder.setDtdMetadata(options.isDtdMetadata());
            builder.setCaseSensitiveTableNames(options.isCaseSensitiveTableNames());
            if (StringUtils.hasText((String)options.getDtdLocation())) {
                IDataSet metaDataSet = FLAT_DTD.loadUnique(null, options.getDtdLocation());
                builder.setMetaDataSet(metaDataSet);
            }
            return builder.build(resource.getInputStream());
        }
    }
    ,
    XML{

        @Override
        protected IDataSet fromResource(Resource resource, DataSetFormatOptions options) throws DataSetException, IOException {
            return new XmlDataSet(resource.getInputStream());
        }
    }
    ,
    STREAMING{

        @Override
        protected IDataSet fromResource(Resource resource, DataSetFormatOptions options) throws IOException {
            return new StreamingDataSet((IDataSetProducer)new XmlProducer(new InputSource(resource.getInputStream())));
        }
    }
    ,
    FLAT_DTD{

        @Override
        protected IDataSet fromResource(Resource resource, DataSetFormatOptions options) throws DataSetException, IOException {
            return new FlatDtdDataSet((IDataSetProducer)new LinkedHashMapFlatDtdProducer(new InputSource(resource.getInputStream())));
        }
    }
    ,
    CSV{

        @Override
        protected IDataSet fromResource(Resource resource, DataSetFormatOptions options) throws DataSetException, IOException {
            return new CsvDataSet(resource.getFile());
        }
    }
    ,
    XLS{

        @Override
        protected IDataSet fromResource(Resource resource, DataSetFormatOptions options) throws DataSetException, IOException {
            return new XlsDataSet(resource.getFile());
        }
    };

    private static final ResourcePatternResolver RESOURCE_LOADER;

    protected abstract IDataSet fromResource(Resource var1, DataSetFormatOptions var2) throws DataSetException, IOException;

    public IDataSet loadUnique(DataSetFormatOptions options, String location) throws DataSetException, IOException {
        Resource resource = RESOURCE_LOADER.getResource(location);
        return this.fromResource(resource, options);
    }

    public List<IDataSet> loadMultiple(DataSetFormatOptions options, String[] locations) throws DataSetException, IOException {
        ArrayList<IDataSet> dataSets = new ArrayList<IDataSet>(locations.length);
        for (String location : locations) {
            Resource[] resources;
            for (Resource resource : resources = RESOURCE_LOADER.getResources(location)) {
                dataSets.add(this.fromResource(resource, options));
            }
        }
        return dataSets;
    }

    static {
        RESOURCE_LOADER = new PathMatchingResourcePatternResolver();
    }
}

