/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit.config;

import com.excilys.ebi.spring.dbunit.config.Constants;

public class DataSetFormatOptions {
    private boolean columnSensing = false;
    private String dtdLocation = Constants.ConfigurationDefaults.DEFAULT_DTD_LOCATION;
    private boolean dtdMetadata = false;
    private boolean caseSensitiveTableNames = false;

    public static Builder newFormatOptions() {
        return new Builder();
    }

    public boolean isColumnSensing() {
        return this.columnSensing;
    }

    public String getDtdLocation() {
        return this.dtdLocation;
    }

    public boolean isDtdMetadata() {
        return this.dtdMetadata;
    }

    public boolean isCaseSensitiveTableNames() {
        return this.caseSensitiveTableNames;
    }

    public void setColumnSensing(boolean columnSensing) {
        this.columnSensing = columnSensing;
    }

    public void setDtdLocation(String dtdLocation) {
        this.dtdLocation = dtdLocation;
    }

    public void setDtdMetadata(boolean dtdMetadata) {
        this.dtdMetadata = dtdMetadata;
    }

    public void setCaseSensitiveTableNames(boolean caseSensitiveTableNames) {
        this.caseSensitiveTableNames = caseSensitiveTableNames;
    }

    public static class Builder {
        private DataSetFormatOptions options = new DataSetFormatOptions();

        private Builder() {
        }

        public Builder withColumnSensing(boolean columnSensing) {
            this.options.columnSensing = columnSensing;
            return this;
        }

        public Builder withDtdLocation(String dtdLocation) {
            this.options.dtdLocation = dtdLocation;
            return this;
        }

        public Builder withDtdMetadata(boolean dtdMetadata) {
            this.options.dtdMetadata = dtdMetadata;
            return this;
        }

        public Builder withCaseSensitiveTableNames(boolean caseSensitiveTableNames) {
            this.options.caseSensitiveTableNames = caseSensitiveTableNames;
            return this;
        }

        public DataSetFormatOptions build() {
            return this.options;
        }
    }
}

